/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.jupyter;

public interface RepositoryStatus {
    public STATUS getStatus();

    public Integer getUntrackedFiles();

    public String getActiveBranch();

    public String getLastCommit();

    public static class ModifiableRepositoryStatus
    implements RepositoryStatus {
        private STATUS status;
        private Integer untrackedFiles;
        private String activeBranch;
        private String lastCommit;

        @Override
        public STATUS getStatus() {
            return this.status;
        }

        public void setStatus(STATUS status) {
            this.status = status;
        }

        @Override
        public Integer getUntrackedFiles() {
            return this.untrackedFiles;
        }

        public void setUntrackedFiles(Integer untrackedFiles) {
            this.untrackedFiles = untrackedFiles;
        }

        @Override
        public String getActiveBranch() {
            return this.activeBranch;
        }

        public void setActiveBranch(String activeBranch) {
            this.activeBranch = activeBranch;
        }

        @Override
        public String getLastCommit() {
            return this.lastCommit;
        }

        public void setLastCommit(String lastCommit) {
            this.lastCommit = lastCommit;
        }
    }

    public static final class UnmodifiableRepositoryStatus
    implements RepositoryStatus {
        private final STATUS status = STATUS.UNINITIALIZED;
        private final Integer untrackedFiles = -1;
        private final String activeBranch = "UNKNOWN";
        private final String lastCommit = "UNKNOWN";

        @Override
        public STATUS getStatus() {
            return this.status;
        }

        @Override
        public Integer getUntrackedFiles() {
            return this.untrackedFiles;
        }

        @Override
        public String getActiveBranch() {
            return "UNKNOWN";
        }

        @Override
        public String getLastCommit() {
            return "UNKNOWN";
        }
    }

    public static enum STATUS {
        DIRTY,
        CLEAN,
        UNINITIALIZED;

    }
}

