/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.jwt;

import io.hops.hopsworks.jwt.JWTController;
import java.io.Serializable;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import javax.ejb.EJB;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.ejb.Timeout;
import javax.ejb.Timer;
import javax.ejb.TimerService;

@Startup
@Singleton
public class InvalidatedJWTCleanup {
    private static final Logger LOGGER = Logger.getLogger(InvalidatedJWTCleanup.class.getName());
    private static final long CLEANUP_INTERVAL = 172800000L;
    @EJB
    private JWTController jWTController;
    @Resource
    TimerService timerService;

    @PostConstruct
    private void init() {
        this.timerService.createTimer(0L, 172800000L, (Serializable)((Object)"Invalidated JWT cleanup"));
    }

    @PreDestroy
    private void destroyTimer() {
        for (Timer timer : this.timerService.getTimers()) {
            timer.cancel();
        }
    }

    @Timeout
    public void performTimeout(Timer timer) {
        int count = this.jWTController.cleanupInvalidTokens();
        LOGGER.log(Level.INFO, "{0} timer event: {1}, removed {2} tokens.", new Object[]{timer.getInfo(), new Date(), count});
    }
}

