/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.kafka;

import io.hops.hopsworks.common.dao.certificates.CertsFacade;
import io.hops.hopsworks.common.dao.certificates.UserCerts;
import io.hops.hopsworks.common.dao.kafka.AclDTO;
import io.hops.hopsworks.common.dao.kafka.KafkaFacade;
import io.hops.hopsworks.common.dao.kafka.ProjectTopics;
import io.hops.hopsworks.common.dao.kafka.SchemaTopics;
import io.hops.hopsworks.common.dao.kafka.SharedTopics;
import io.hops.hopsworks.common.dao.kafka.TopicDTO;
import io.hops.hopsworks.common.dao.project.Project;
import io.hops.hopsworks.common.dao.user.Users;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.exceptions.KafkaException;
import io.hops.hopsworks.exceptions.ProjectException;
import io.hops.hopsworks.exceptions.UserException;
import io.hops.hopsworks.restutils.RESTCodes;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.ejb.Stateless;

@Stateless
public class KafkaController {
    private static final Logger LOGGER = Logger.getLogger(KafkaController.class.getName());
    @EJB
    private KafkaFacade kafkaFacade;
    @EJB
    private CertsFacade userCerts;
    @EJB
    private Settings settings;

    public String getKafkaCertPaths(Project project) {
        UserCerts userCert = this.userCerts.findUserCert(project.getName(), project.getOwner().getUsername());
        if (userCert.getUserCert() != null && userCert.getUserCert().length > 0 && userCert.getUserKey() != null && userCert.getUserKey().length > 0) {
            File certDir = new File(this.settings.getHopsworksTrueTempCertDir() + "/" + project.getName());
            if (!certDir.exists()) {
                try {
                    certDir.mkdirs();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                FileOutputStream fos = new FileOutputStream(certDir.getAbsolutePath() + "/keystore.jks");
                fos.write(userCert.getUserKey());
                fos.close();
                fos = new FileOutputStream(certDir.getAbsolutePath() + "/truststore.jks");
                fos.write(userCert.getUserCert());
                fos.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return certDir.getAbsolutePath();
        }
        return null;
    }

    public void addProjectMemberToTopics(Project project, String member) throws KafkaException, ProjectException, UserException {
        List<TopicDTO> topics = this.kafkaFacade.findTopicsByProject(project);
        List<SharedTopics> sharedTopics = this.kafkaFacade.findSharedTopicsByProject(project.getId());
        for (SharedTopics sharedTopic : sharedTopics) {
            this.kafkaFacade.addAclsToTopic(sharedTopic.getSharedTopicsPK().getTopicName(), sharedTopic.getProjectId(), new AclDTO(project.getName(), member, "allow", "*", "*", "*"));
        }
        for (TopicDTO topic : topics) {
            this.kafkaFacade.addAclsToTopic(topic.getName(), project.getId(), new AclDTO(project.getName(), member, "allow", "*", "*", "*"));
        }
    }

    public void removeProjectMemberFromTopics(Project project, Users user) throws ProjectException {
        List<SharedTopics> sharedTopics = this.kafkaFacade.findSharedTopicsByProject(project.getId());
        ArrayList<Integer> projectSharedTopics = new ArrayList<Integer>();
        for (SharedTopics sharedTopic : sharedTopics) {
            projectSharedTopics.add(sharedTopic.getProjectId());
        }
        if (!projectSharedTopics.isEmpty()) {
            for (Integer projectSharedTopic : projectSharedTopics) {
                this.kafkaFacade.removeAclsForUser(user, projectSharedTopic);
            }
        }
        this.kafkaFacade.removeAclsForUser(user, project);
    }

    public List<TopicDTO> findSharedTopicsByProject(Integer projectId) {
        List<SharedTopics> res = this.kafkaFacade.findSharedTopicsByProject(projectId);
        ArrayList<TopicDTO> topics = new ArrayList<TopicDTO>();
        for (SharedTopics pt : res) {
            topics.add(new TopicDTO(pt.getSharedTopicsPK().getTopicName()));
        }
        return topics;
    }

    public void updateTopicSchemaVersion(Project project, String topicName, Integer schemaVersion) throws KafkaException {
        ProjectTopics pt = this.kafkaFacade.getTopicByProjectAndTopicName(project, topicName).orElseThrow(() -> new KafkaException(RESTCodes.KafkaErrorCode.TOPIC_NOT_FOUND, Level.FINE, "topic: " + topicName));
        String schemaName = pt.getSchemaTopics().getSchemaTopicsPK().getName();
        SchemaTopics st = this.kafkaFacade.getSchemaByNameAndVersion(schemaName, schemaVersion).orElseThrow(() -> new KafkaException(RESTCodes.KafkaErrorCode.SCHEMA_VERSION_NOT_FOUND, Level.FINE, "schema: " + schemaName + ", version: " + schemaVersion));
        this.kafkaFacade.updateTopicSchemaVersion(pt, st);
    }
}

