/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.upload;

import io.hops.hopsworks.common.util.Settings;
import java.io.File;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ejb.DependsOn;
import javax.ejb.EJB;
import javax.ejb.Singleton;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.flink.shaded.com.google.common.io.Files;

@Singleton
@DependsOn(value={"Settings"})
public class StagingManager {
    private File stagingFolder;
    @EJB
    private Settings settings;

    @PostConstruct
    public void init() {
        String path = RandomStringUtils.randomAlphanumeric((int)8);
        this.stagingFolder = new File(this.settings.getStagingDir() + "/" + path);
        this.stagingFolder.mkdirs();
    }

    public String getStagingPath() {
        if (this.stagingFolder == null) {
            this.stagingFolder = Files.createTempDir();
        }
        return this.stagingFolder.getAbsolutePath();
    }

    @PreDestroy
    public void removeTmpDir() {
        if (this.stagingFolder != null) {
            this.stagingFolder.delete();
        }
    }
}

