/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.util;

import io.hops.hopsworks.common.dao.project.Project;
import java.util.ArrayList;
import java.util.List;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class ProjectUtils {
    public boolean isReservedProjectName(String projName) {
        boolean res = false;
        for (String name : this.getReservedProjectNames()) {
            if (name.compareToIgnoreCase(projName) != 0) continue;
            res = true;
            break;
        }
        return res;
    }

    public List<String> getReservedProjectNames() {
        ArrayList<String> reservedNames = new ArrayList<String>();
        reservedNames.add("python27");
        reservedNames.add("python36");
        reservedNames.add("python37");
        reservedNames.add("python38");
        reservedNames.add("python39");
        reservedNames.add("hops-system");
        return reservedNames;
    }

    public String getCurrentCondaEnvironment(Project project) {
        String condaEnv = project.getName();
        if (project.getConda().booleanValue() && !project.getCondaEnv().booleanValue()) {
            if (project.getPythonVersion().compareToIgnoreCase("2.7") == 0) {
                condaEnv = "python27";
            } else if (project.getPythonVersion().compareToIgnoreCase("3.6") == 0) {
                condaEnv = "python36";
            } else {
                throw new IllegalArgumentException("Error. Python has not been enabled for this project.");
            }
        }
        return condaEnv;
    }

    public String getCurrentCondaBaseEnvironment(Project project) {
        if (project.getPythonVersion().compareToIgnoreCase("2.7") == 0) {
            return "python27";
        }
        if (project.getPythonVersion().compareToIgnoreCase("3.6") == 0) {
            return "python36";
        }
        throw new IllegalArgumentException("Error. Python has not been enabled for this project.");
    }
}

