/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.airflow;

import com.auth0.jwt.exceptions.JWTDecodeException;
import com.auth0.jwt.interfaces.DecodedJWT;
import io.hops.hopsworks.common.dao.airflow.AirflowDag;
import io.hops.hopsworks.common.dao.airflow.AirflowDagFacade;
import io.hops.hopsworks.common.dao.airflow.MaterializedJWT;
import io.hops.hopsworks.common.dao.airflow.MaterializedJWTFacade;
import io.hops.hopsworks.common.dao.airflow.MaterializedJWTID;
import io.hops.hopsworks.common.dao.project.Project;
import io.hops.hopsworks.common.dao.project.ProjectFacade;
import io.hops.hopsworks.common.dao.user.BbcGroup;
import io.hops.hopsworks.common.dao.user.UserFacade;
import io.hops.hopsworks.common.dao.user.Users;
import io.hops.hopsworks.common.hdfs.HdfsUsersController;
import io.hops.hopsworks.common.security.CertificateMaterializer;
import io.hops.hopsworks.common.util.DateUtils;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.exceptions.AirflowException;
import io.hops.hopsworks.jwt.JWTController;
import io.hops.hopsworks.jwt.SignatureAlgorithm;
import io.hops.hopsworks.jwt.exception.InvalidationException;
import io.hops.hopsworks.jwt.exception.JWTException;
import io.hops.hopsworks.restutils.RESTCodes;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.GroupPrincipal;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFilePermission;
import java.security.GeneralSecurityException;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.ejb.AccessTimeout;
import javax.ejb.DependsOn;
import javax.ejb.EJB;
import javax.ejb.Lock;
import javax.ejb.LockType;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.ejb.Timeout;
import javax.ejb.Timer;
import javax.ejb.TimerConfig;
import javax.ejb.TimerService;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;

@Singleton
@Startup
@TransactionAttribute(value=TransactionAttributeType.NEVER)
@DependsOn(value={"Settings"})
public class AirflowManager {
    private static final Logger LOG = Logger.getLogger(AirflowManager.class.getName());
    private static final String TOKEN_FILE_SUFFIX = ".jwt";
    private static final Set<PosixFilePermission> TOKEN_FILE_PERMISSIONS = new HashSet<PosixFilePermission>(5);
    private final TreeSet<AirflowJWT> airflowJWTs = new TreeSet<AirflowJWT>(new Comparator<AirflowJWT>(){

        @Override
        public int compare(AirflowJWT t0, AirflowJWT t1) {
            if (t0.equals(t1)) {
                return 0;
            }
            if (t0.expiration.isBefore(t1.expiration)) {
                return -1;
            }
            if (t0.expiration.isAfter(t1.expiration)) {
                return 1;
            }
            return 0;
        }
    });
    @EJB
    private HdfsUsersController hdfsUsersController;
    @EJB
    private Settings settings;
    @EJB
    private JWTController jwtController;
    @EJB
    private AirflowDagFacade airflowDagFacade;
    @EJB
    private CertificateMaterializer certificateMaterializer;
    @EJB
    private MaterializedJWTFacade materializedJWTFacade;
    @EJB
    private UserFacade userFacade;
    @EJB
    private ProjectFacade projectFacade;
    @Resource
    private TimerService timerService;
    private GroupPrincipal airflowGroup;

    @PostConstruct
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public void init() throws RuntimeException {
        try {
            Path airflowPath = Paths.get(this.settings.getAirflowDir(), new String[0]);
            this.airflowGroup = Files.getFileAttributeView(airflowPath, PosixFileAttributeView.class, LinkOption.NOFOLLOW_LINKS).readAttributes().group();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        try {
            this.recover();
        }
        catch (Exception ex) {
            LOG.log(Level.WARNING, "Failed to recover material for Airflow sessions", ex);
        }
        long interval = Math.max(1000L, (long)(this.settings.getJWTExpLeewaySec() * 1000 / 2));
        this.timerService.createIntervalTimer(10L, interval, new TimerConfig((Serializable)((Object)"Airflow JWT renewal"), false));
    }

    private void recover() {
        LOG.log(Level.FINE, "Starting Airflow manager recovery");
        ArrayList<MaterializedJWT> failed2recover = new ArrayList<MaterializedJWT>();
        Project project = null;
        Users user = null;
        for (MaterializedJWT material : this.materializedJWTFacade.findAll4Airflow()) {
            AirflowJWT airflowJWT;
            LOG.log(Level.FINEST, "Recovering material: " + material.getIdentifier().getProjectId() + " - " + material.getIdentifier().getUserId());
            project = this.projectFacade.find(material.getIdentifier().getProjectId());
            user = (Users)this.userFacade.find(material.getIdentifier().getUserId());
            if (project == null || user == null) {
                LOG.log(Level.WARNING, "Error while recovering Project with ID: " + material.getIdentifier().getProjectId() + " and User ID: " + material.getIdentifier().getUserId() + ". Project or user is null");
                failed2recover.add(material);
                continue;
            }
            Path tokenFile = Paths.get(this.getProjectSecretsDirectory(user.getUsername()).toString(), this.getTokenFileName(project.getName(), user.getUsername()));
            String token = null;
            String materialIdentifier = "Project: " + project.getName() + " - User: " + user.getUsername();
            try {
                token = FileUtils.readFileToString((File)tokenFile.toFile(), (Charset)Charset.defaultCharset());
                DecodedJWT decoded = this.jwtController.verifyToken(token, this.settings.getJWTIssuer());
                airflowJWT = new AirflowJWT(user.getUsername(), project.getId(), project.getName(), DateUtils.date2LocalDateTime(decoded.getExpiresAt()), user.getUid());
                airflowJWT.tokenFile = tokenFile;
                airflowJWT.token = token;
                LOG.log(Level.FINE, "Successfully read existing JWT from local filesystem for " + materialIdentifier);
            }
            catch (JWTDecodeException | JWTException | IOException ex) {
                String[] audience = new String[]{"api"};
                LocalDateTime expirationDate = DateUtils.getNow().plus(this.settings.getJWTLifetimeMs(), ChronoUnit.MILLIS);
                String[] roles = this.getUserRoles(user);
                try {
                    LOG.log(Level.FINEST, "JWT for " + materialIdentifier + " does not exist in the local FS or it is not valid any longer, creating new one...");
                    HashMap<String, Object> claims = new HashMap<String, Object>(3);
                    claims.put("renewable", false);
                    claims.put("expLeeway", this.settings.getJWTExpLeewaySec());
                    claims.put("roles", roles);
                    token = this.jwtController.createToken(this.settings.getJWTSigningKeyName(), false, this.settings.getJWTIssuer(), audience, DateUtils.localDateTime2Date(expirationDate), DateUtils.localDateTime2Date(DateUtils.getNow()), user.getUsername(), claims, SignatureAlgorithm.valueOf((String)this.settings.getJWTSignatureAlg()));
                    airflowJWT = new AirflowJWT(user.getUsername(), project.getId(), project.getName(), expirationDate, user.getUid());
                    airflowJWT.tokenFile = tokenFile;
                    airflowJWT.token = token;
                    this.writeTokenToFile(airflowJWT);
                    LOG.log(Level.FINE, "Created new JWT for " + materialIdentifier + " and flushed to local FS");
                }
                catch (IOException ex1) {
                    LOG.log(Level.WARNING, "Could not write to local FS new JWT for recovered material " + materialIdentifier + ". We will invalidate it and won't renew it.", ex1);
                    if (token != null) {
                        try {
                            LOG.log(Level.FINE, "Failed to write JWT for " + materialIdentifier + ". Invalidating it...");
                            this.jwtController.invalidate(token);
                        }
                        catch (InvalidationException invalidationException) {
                            // empty catch block
                        }
                    }
                    failed2recover.add(material);
                    continue;
                }
                catch (JWTException | GeneralSecurityException ex1) {
                    LOG.log(Level.WARNING, "Tried to recover JWT for " + materialIdentifier + " but we failed. Giving up... JWT will not be available for Airflow DAGs", ex1);
                    failed2recover.add(material);
                    continue;
                }
            }
            try {
                LOG.log(Level.FINEST, "Materializing X.509 for " + materialIdentifier);
                this.certificateMaterializer.materializeCertificatesLocalCustomDir(user.getUsername(), project.getName(), this.getProjectSecretsDirectory(user.getUsername()).toString());
                LOG.log(Level.FINE, "Materialized X.509 for " + materialIdentifier);
                this.airflowJWTs.add(airflowJWT);
            }
            catch (IOException ex) {
                LOG.log(Level.WARNING, "Could not materialize X.509 for " + materialIdentifier + " Invalidating JWT and deleting from FS. JWT and X.509 will not be available for Airflow DAGs.", ex);
                if (token != null) {
                    try {
                        LOG.log(Level.FINE, "Failed to materialize X.509 for " + materialIdentifier + " Invalidating JWT and deleting it from local FS.");
                        this.jwtController.invalidate(token);
                        FileUtils.deleteDirectory((File)this.getProjectSecretsDirectory(user.getUsername()).toFile());
                    }
                    catch (InvalidationException | IOException throwable) {
                        // empty catch block
                    }
                }
                failed2recover.add(material);
            }
        }
        for (MaterializedJWT failed : failed2recover) {
            this.materializedJWTFacade.delete(failed.getIdentifier());
        }
    }

    private String[] getUserRoles(Users p) {
        Collection<BbcGroup> groupList = p.getBbcGroupCollection();
        String[] roles = new String[groupList.size()];
        int idx = 0;
        for (BbcGroup g : groupList) {
            roles[idx] = g.getGroupName();
            ++idx;
        }
        return roles;
    }

    @Lock(value=LockType.WRITE)
    @AccessTimeout(value=5L, unit=TimeUnit.SECONDS)
    public void onProjectRemoval(Project project) throws IOException {
        FileUtils.deleteDirectory((File)this.getProjectDagDirectory(project.getId()).toFile());
    }

    @Lock(value=LockType.READ)
    @AccessTimeout(value=1L, unit=TimeUnit.SECONDS)
    public void prepareSecurityMaterial(Users user, Project project, String[] audience) throws AirflowException {
        MaterializedJWTID materialID = new MaterializedJWTID(project.getId(), user.getUid(), MaterializedJWTID.USAGE.AIRFLOW);
        if (!this.materializedJWTFacade.exists(materialID)) {
            LocalDateTime expirationDate = DateUtils.getNow().plus(this.settings.getJWTLifetimeMs(), ChronoUnit.MILLIS);
            AirflowJWT airflowJWT = new AirflowJWT(user.getUsername(), project.getId(), project.getName(), expirationDate, user.getUid());
            try {
                String[] roles = this.getUserRoles(user);
                MaterializedJWT airflowMaterial = new MaterializedJWT(new MaterializedJWTID(project.getId(), user.getUid(), MaterializedJWTID.USAGE.AIRFLOW));
                this.materializedJWTFacade.persist(airflowMaterial);
                HashMap<String, Object> claims = new HashMap<String, Object>(3);
                claims.put("renewable", false);
                claims.put("expLeeway", this.settings.getJWTExpLeewaySec());
                claims.put("roles", roles);
                String token = this.jwtController.createToken(this.settings.getJWTSigningKeyName(), false, this.settings.getJWTIssuer(), audience, DateUtils.localDateTime2Date(expirationDate), DateUtils.localDateTime2Date(DateUtils.getNow()), user.getUsername(), claims, SignatureAlgorithm.valueOf((String)this.settings.getJWTSignatureAlg()));
                String projectAirflowDir = this.getProjectSecretsDirectory(user.getUsername()).toString();
                airflowJWT.tokenFile = Paths.get(projectAirflowDir, this.getTokenFileName(project.getName(), user.getUsername()));
                airflowJWT.token = token;
                this.writeTokenToFile(airflowJWT);
                this.certificateMaterializer.materializeCertificatesLocalCustomDir(user.getUsername(), project.getName(), projectAirflowDir);
                this.airflowJWTs.add(airflowJWT);
            }
            catch (JWTException | GeneralSecurityException ex) {
                this.deleteAirflowMaterial(materialID);
                throw new AirflowException(RESTCodes.AirflowErrorCode.JWT_NOT_CREATED, Level.SEVERE, "Could not generate Airflow JWT for user " + user.getUsername(), ex.getMessage(), ex);
            }
            catch (IOException ex) {
                LOG.log(Level.WARNING, "Could not write Airflow JWT for user " + this.hdfsUsersController.getHdfsUserName(project, user), ex);
                this.deleteAirflowMaterial(materialID);
                try {
                    this.jwtController.invalidate(airflowJWT.token);
                }
                catch (InvalidationException invEx) {
                    LOG.log(Level.FINE, "Could not invalidate Airflow JWT. Skipping...", ex);
                }
                throw new AirflowException(RESTCodes.AirflowErrorCode.JWT_NOT_STORED, Level.SEVERE, "Could not store Airflow JWT for user " + this.hdfsUsersController.getHdfsUserName(project, user), ex.getMessage(), (Throwable)ex);
            }
        }
    }

    @Lock(value=LockType.WRITE)
    @AccessTimeout(value=500L)
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    @Timeout
    public void monitorSecurityMaterial(Timer timer) {
        AirflowJWT airflowJWT;
        LocalDateTime now = DateUtils.getNow();
        this.cleanStaleSecurityMaterial();
        HashSet<AirflowJWT> newTokens2Add = new HashSet<AirflowJWT>();
        Iterator<AirflowJWT> airflowJWTIt = this.airflowJWTs.iterator();
        while (airflowJWTIt.hasNext() && (airflowJWT = airflowJWTIt.next()).maybeRenew(now)) {
            try {
                LocalDateTime expirationDateTime = now.plus(this.settings.getJWTLifetimeMs(), ChronoUnit.MILLIS);
                Date expirationDate = DateUtils.localDateTime2Date(expirationDateTime);
                String token = this.jwtController.renewToken(airflowJWT.token, expirationDate, DateUtils.localDateTime2Date(DateUtils.getNow()), true, new HashMap(3));
                AirflowJWT renewedJWT = new AirflowJWT(airflowJWT.username, airflowJWT.projectId, airflowJWT.projectName, expirationDateTime, airflowJWT.uid);
                renewedJWT.tokenFile = airflowJWT.tokenFile;
                renewedJWT.token = token;
                airflowJWTIt.remove();
                this.writeTokenToFile(renewedJWT);
                newTokens2Add.add(renewedJWT);
            }
            catch (JWTException ex) {
                LOG.log(Level.WARNING, "Could not renew Airflow JWT for " + airflowJWT, ex);
            }
            catch (IOException ex) {
                LOG.log(Level.WARNING, "Could not write renewed Airflow JWT for " + airflowJWT, ex);
                try {
                    this.jwtController.invalidate(airflowJWT.token);
                }
                catch (InvalidationException iex) {
                    LOG.log(Level.FINE, "Could not invalidate Airflow JWT. SKipping...");
                }
            }
            catch (Exception ex) {
                LOG.log(Level.SEVERE, "Generic error while renewing Airflow JWTs", ex);
            }
        }
        this.airflowJWTs.addAll(newTokens2Add);
    }

    public Path getProjectDagDirectory(Integer projectID) {
        return Paths.get(this.settings.getAirflowDir(), "dags", this.generateProjectSecret(projectID));
    }

    public Path getProjectSecretsDirectory(String username) {
        return Paths.get(this.settings.getAirflowDir(), "secrets", this.generateOwnerSecret(username));
    }

    private String generateProjectSecret(Integer projectID) {
        return DigestUtils.sha256Hex((String)Integer.toString(projectID));
    }

    private String generateOwnerSecret(String username) {
        return DigestUtils.sha256Hex((String)username);
    }

    private void writeTokenToFile(AirflowJWT airflowJWT) throws IOException {
        Path parent = airflowJWT.tokenFile.getParent();
        if (!parent.toFile().exists()) {
            parent.toFile().mkdirs();
            Files.setPosixFilePermissions(parent, TOKEN_FILE_PERMISSIONS);
            Files.getFileAttributeView(parent, PosixFileAttributeView.class, LinkOption.NOFOLLOW_LINKS).setGroup(this.airflowGroup);
        }
        FileUtils.writeStringToFile((File)airflowJWT.tokenFile.toFile(), (String)airflowJWT.token);
        Files.setPosixFilePermissions(airflowJWT.tokenFile, TOKEN_FILE_PERMISSIONS);
        Files.getFileAttributeView(airflowJWT.tokenFile, PosixFileAttributeView.class, LinkOption.NOFOLLOW_LINKS).setGroup(this.airflowGroup);
    }

    private void deleteAirflowMaterial(MaterializedJWTID identifier) {
        this.materializedJWTFacade.delete(identifier);
    }

    private String getTokenFileName(String projectName, String username) {
        return projectName + "__" + username + TOKEN_FILE_SUFFIX;
    }

    private boolean deleteDirectoryIfEmpty(Path directory) throws IOException {
        File directoryFile = directory.toFile();
        File[] content = directoryFile.listFiles();
        if (content != null && content.length == 0) {
            FileUtils.deleteDirectory((File)directoryFile);
            return true;
        }
        return false;
    }

    private void cleanStaleSecurityMaterial() {
        Iterator<AirflowJWT> airflowJWTsIt = this.airflowJWTs.iterator();
        while (airflowJWTsIt.hasNext()) {
            AirflowJWT nextElement = airflowJWTsIt.next();
            try {
                MaterializedJWTID materialId = new MaterializedJWTID(nextElement.projectId, nextElement.uid, MaterializedJWTID.USAGE.AIRFLOW);
                MaterializedJWT airflowMaterial = this.materializedJWTFacade.findById(materialId);
                boolean shouldDelete = true;
                if (airflowMaterial != null) {
                    List<AirflowDag> ownedDags = this.airflowDagFacade.filterByOwner(nextElement.username);
                    for (AirflowDag dag : ownedDags) {
                        if (dag.getPaused().booleanValue()) continue;
                        shouldDelete = false;
                        break;
                    }
                }
                if (!shouldDelete) continue;
                this.certificateMaterializer.removeCertificatesLocalCustomDir(nextElement.username, nextElement.projectName, this.getProjectSecretsDirectory(nextElement.username).toString());
                FileUtils.deleteQuietly((File)nextElement.tokenFile.toFile());
                airflowJWTsIt.remove();
                if (airflowMaterial != null) {
                    this.deleteAirflowMaterial(materialId);
                }
                this.deleteDirectoryIfEmpty(nextElement.tokenFile.getParent());
            }
            catch (Exception ex) {
                LOG.log(Level.WARNING, "Could not determine if token " + nextElement + " is stale. It will be renewed!", ex);
            }
        }
    }

    static {
        TOKEN_FILE_PERMISSIONS.add(PosixFilePermission.OWNER_READ);
        TOKEN_FILE_PERMISSIONS.add(PosixFilePermission.OWNER_WRITE);
        TOKEN_FILE_PERMISSIONS.add(PosixFilePermission.OWNER_EXECUTE);
        TOKEN_FILE_PERMISSIONS.add(PosixFilePermission.GROUP_READ);
        TOKEN_FILE_PERMISSIONS.add(PosixFilePermission.GROUP_EXECUTE);
    }

    private class AirflowJWT {
        private final String username;
        private final Integer projectId;
        private final String projectName;
        private final LocalDateTime expiration;
        private final Integer uid;
        private String token;
        private Path tokenFile;

        private AirflowJWT(String username, Integer projectId, String projectName, LocalDateTime expiration, Integer uid) {
            this.username = username;
            this.projectId = projectId;
            this.projectName = projectName;
            this.expiration = expiration;
            this.uid = uid;
        }

        private boolean maybeRenew(LocalDateTime now) {
            return now.isAfter(this.expiration) || now.isEqual(this.expiration);
        }

        public int hashCode() {
            int result = 17;
            result = 31 * result + this.uid;
            result = 31 * result + this.projectId;
            return result;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof AirflowJWT) {
                AirflowJWT other = (AirflowJWT)o;
                return this.uid.equals(other.uid) && this.projectId.equals(other.projectId);
            }
            return false;
        }

        public String toString() {
            return "Airflow JWT - Project ID: " + this.projectId + " User ID: " + this.uid;
        }
    }
}

