/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dao.featurestore.app;

import io.hops.hopsworks.common.dao.featurestore.FeaturestoreDTO;
import io.hops.hopsworks.common.dao.featurestore.featuregroup.FeaturegroupDTO;
import io.hops.hopsworks.common.dao.featurestore.settings.FeaturestoreClientSettingsDTO;
import io.hops.hopsworks.common.dao.featurestore.storageconnector.FeaturestoreStorageConnectorDTO;
import io.hops.hopsworks.common.dao.featurestore.storageconnector.jdbc.FeaturestoreJdbcConnectorDTO;
import io.hops.hopsworks.common.dao.featurestore.trainingdataset.TrainingDatasetDTO;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement
@XmlType(propOrder={"featurestore", "featuregroups", "trainingDatasets", "settings", "storageConnectors", "onlineFeaturestoreConnector"})
public class FeaturestoreMetadataDTO {
    private FeaturestoreDTO featurestore;
    private List<FeaturegroupDTO> featuregroups;
    private List<TrainingDatasetDTO> trainingDatasets;
    private FeaturestoreClientSettingsDTO settings;
    private List<FeaturestoreStorageConnectorDTO> storageConnectors;
    private FeaturestoreJdbcConnectorDTO onlineFeaturestoreConnector;

    public FeaturestoreMetadataDTO() {
    }

    public FeaturestoreMetadataDTO(FeaturestoreDTO featurestore, List<FeaturegroupDTO> featuregroups, List<TrainingDatasetDTO> trainingDatasets, FeaturestoreClientSettingsDTO featurestoreClientSettingsDTO, List<FeaturestoreStorageConnectorDTO> storageConnectors, FeaturestoreJdbcConnectorDTO onlineFeaturestoreConnector) {
        this.featurestore = featurestore;
        this.featuregroups = featuregroups.stream().map(fg -> {
            fg.setClusterAnalysis(null);
            fg.setDescriptiveStatistics(null);
            fg.setFeaturesHistogram(null);
            fg.setFeatureCorrelationMatrix(null);
            return fg;
        }).collect(Collectors.toList());
        this.trainingDatasets = trainingDatasets.stream().map(td -> {
            td.setClusterAnalysis(null);
            td.setDescriptiveStatistics(null);
            td.setFeaturesHistogram(null);
            td.setFeatureCorrelationMatrix(null);
            return td;
        }).collect(Collectors.toList());
        this.settings = featurestoreClientSettingsDTO;
        this.storageConnectors = storageConnectors;
        this.onlineFeaturestoreConnector = onlineFeaturestoreConnector;
    }

    @XmlElement
    public List<FeaturegroupDTO> getFeaturegroups() {
        return this.featuregroups;
    }

    @XmlElement
    public List<TrainingDatasetDTO> getTrainingDatasets() {
        return this.trainingDatasets;
    }

    @XmlElement
    public FeaturestoreDTO getFeaturestore() {
        return this.featurestore;
    }

    @XmlElement
    public FeaturestoreClientSettingsDTO getSettings() {
        return this.settings;
    }

    @XmlElement
    public List<FeaturestoreStorageConnectorDTO> getStorageConnectors() {
        return this.storageConnectors;
    }

    @XmlElement
    public FeaturestoreJdbcConnectorDTO getOnlineFeaturestoreConnector() {
        return this.onlineFeaturestoreConnector;
    }

    public void setFeaturegroups(List<FeaturegroupDTO> featuregroups) {
        this.featuregroups = featuregroups;
    }

    public void setTrainingDatasets(List<TrainingDatasetDTO> trainingDatasets) {
        this.trainingDatasets = trainingDatasets;
    }

    public void setFeaturestore(FeaturestoreDTO featurestore) {
        this.featurestore = featurestore;
    }

    public void setSettings(FeaturestoreClientSettingsDTO settings) {
        this.settings = settings;
    }

    public void setStorageConnectors(List<FeaturestoreStorageConnectorDTO> storageConnectors) {
        this.storageConnectors = storageConnectors;
    }

    public void setOnlineFeaturestoreConnector(FeaturestoreJdbcConnectorDTO onlineFeaturestoreConnector) {
        this.onlineFeaturestoreConnector = onlineFeaturestoreConnector;
    }

    public String toString() {
        return "FeaturestoreMetadataDTO{featurestore=" + this.featurestore + ", featuregroups=" + this.featuregroups + ", trainingDatasets=" + this.trainingDatasets + ", settings=" + this.settings + ", storageConnectors=" + this.storageConnectors + ", onlineFeaturestoreConnector=" + this.onlineFeaturestoreConnector + '}';
    }
}

