/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dao.featurestore.featuregroup.on_demand_featuregroup;

import io.hops.hopsworks.common.dao.featurestore.feature.FeatureDTO;
import io.hops.hopsworks.common.dao.featurestore.featuregroup.Featuregroup;
import io.hops.hopsworks.common.dao.featurestore.featuregroup.FeaturegroupDTO;
import io.hops.hopsworks.common.dao.featurestore.storageconnector.jdbc.FeaturestoreJdbcConnector;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class OnDemandFeaturegroupDTO
extends FeaturegroupDTO {
    private Integer jdbcConnectorId;
    private String jdbcConnectorName;
    private String query;

    public OnDemandFeaturegroupDTO() {
    }

    public OnDemandFeaturegroupDTO(Featuregroup featuregroup) {
        super(featuregroup);
        if (featuregroup.getOnDemandFeaturegroup().getFeaturestoreJdbcConnector() != null) {
            FeaturestoreJdbcConnector featurestoreJdbcConnector = featuregroup.getOnDemandFeaturegroup().getFeaturestoreJdbcConnector();
            this.jdbcConnectorId = featurestoreJdbcConnector.getId();
            this.jdbcConnectorName = featurestoreJdbcConnector.getName();
        }
        this.setName(featuregroup.getOnDemandFeaturegroup().getName());
        this.setDescription(featuregroup.getOnDemandFeaturegroup().getDescription());
        this.query = featuregroup.getOnDemandFeaturegroup().getQuery();
        this.setFeatures(featuregroup.getOnDemandFeaturegroup().getFeatures().stream().map(fgFeature -> new FeatureDTO(fgFeature.getName(), fgFeature.getType(), fgFeature.getDescription(), fgFeature.getPrimary() == 1, false, null)).collect(Collectors.toList()));
    }

    @XmlElement
    public Integer getJdbcConnectorId() {
        return this.jdbcConnectorId;
    }

    public void setJdbcConnectorId(Integer jdbcConnectorId) {
        this.jdbcConnectorId = jdbcConnectorId;
    }

    @XmlElement
    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    @XmlElement
    public String getJdbcConnectorName() {
        return this.jdbcConnectorName;
    }

    public void setJdbcConnectorName(String jdbcConnectorName) {
        this.jdbcConnectorName = jdbcConnectorName;
    }

    @Override
    public String toString() {
        return "HopsfsTrainingDatasetDTO{jdbcConnectorId=" + this.jdbcConnectorId + ", jdbcConnectorName='" + this.jdbcConnectorName + '\'' + ", query='" + this.query + '\'' + '}';
    }
}

