/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dao.featurestore.storageconnector;

import io.hops.hopsworks.common.dao.featurestore.Featurestore;
import io.hops.hopsworks.common.dao.featurestore.storageconnector.FeaturestoreStorageConnectorDTO;
import io.hops.hopsworks.common.dao.featurestore.storageconnector.FeaturestoreStorageConnectorType;
import io.hops.hopsworks.common.dao.featurestore.storageconnector.hopsfs.FeaturestoreHopsfsConnectorController;
import io.hops.hopsworks.common.dao.featurestore.storageconnector.hopsfs.FeaturestoreHopsfsConnectorDTO;
import io.hops.hopsworks.common.dao.featurestore.storageconnector.jdbc.FeaturestoreJdbcConnectorController;
import io.hops.hopsworks.common.dao.featurestore.storageconnector.jdbc.FeaturestoreJdbcConnectorDTO;
import io.hops.hopsworks.common.dao.featurestore.storageconnector.s3.FeaturestoreS3ConnectorController;
import io.hops.hopsworks.common.dao.featurestore.storageconnector.s3.FeaturestoreS3ConnectorDTO;
import io.hops.hopsworks.common.dao.project.Project;
import io.hops.hopsworks.common.dao.user.Users;
import io.hops.hopsworks.common.security.secrets.SecretsController;
import io.hops.hopsworks.exceptions.FeaturestoreException;
import io.hops.hopsworks.exceptions.UserException;
import io.hops.hopsworks.restutils.RESTCodes;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;

@Stateless
public class FeaturestoreStorageConnectorController {
    @EJB
    private FeaturestoreHopsfsConnectorController featurestoreHopsfsConnectorController;
    @EJB
    private FeaturestoreJdbcConnectorController featurestoreJdbcConnectorController;
    @EJB
    private FeaturestoreS3ConnectorController featurestoreS3ConnectorController;
    @EJB
    private SecretsController secretsController;

    public List<FeaturestoreStorageConnectorDTO> getAllStorageConnectorsForFeaturestore(Featurestore featurestore) {
        ArrayList<FeaturestoreStorageConnectorDTO> featurestoreStorageConnectorDTOS = new ArrayList<FeaturestoreStorageConnectorDTO>();
        featurestoreStorageConnectorDTOS.addAll(this.featurestoreJdbcConnectorController.getJdbcConnectorsForFeaturestore(featurestore));
        featurestoreStorageConnectorDTOS.addAll(this.featurestoreS3ConnectorController.getS3ConnectorsForFeaturestore(featurestore));
        featurestoreStorageConnectorDTOS.addAll(this.featurestoreHopsfsConnectorController.getHopsfsConnectors(featurestore));
        return featurestoreStorageConnectorDTOS;
    }

    public List<FeaturestoreStorageConnectorDTO> getAllStorageConnectorsForFeaturestoreWithType(Featurestore featurestore, FeaturestoreStorageConnectorType featurestoreStorageConnectorType) {
        switch (featurestoreStorageConnectorType) {
            case S3: {
                return this.featurestoreS3ConnectorController.getS3ConnectorsForFeaturestore(featurestore);
            }
            case JDBC: {
                return this.featurestoreJdbcConnectorController.getJdbcConnectorsForFeaturestore(featurestore);
            }
            case HOPSFS: {
                return this.featurestoreHopsfsConnectorController.getHopsfsConnectors(featurestore);
            }
        }
        throw new IllegalArgumentException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_STORAGE_CONNECTOR_TYPE.getMessage() + ", Recognized storage connector types are: " + (Object)((Object)FeaturestoreStorageConnectorType.HOPSFS) + ", " + (Object)((Object)FeaturestoreStorageConnectorType.S3) + ", and " + (Object)((Object)FeaturestoreStorageConnectorType.JDBC) + ". The provided training dataset type was not recognized: " + (Object)((Object)featurestoreStorageConnectorType));
    }

    public FeaturestoreStorageConnectorDTO getStorageConnectorForFeaturestoreWithTypeAndId(Featurestore featurestore, FeaturestoreStorageConnectorType featurestoreStorageConnectorType, Integer storageConnectorId) throws FeaturestoreException {
        switch (featurestoreStorageConnectorType) {
            case S3: {
                return this.featurestoreS3ConnectorController.getS3ConnectorWithIdAndFeaturestore(featurestore, storageConnectorId);
            }
            case JDBC: {
                return this.featurestoreJdbcConnectorController.getJdbcConnectorWithIdAndFeaturestore(featurestore, storageConnectorId);
            }
            case HOPSFS: {
                return this.featurestoreHopsfsConnectorController.getHopsFsConnectorWithIdAndFeaturestore(featurestore, storageConnectorId);
            }
        }
        throw new IllegalArgumentException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_STORAGE_CONNECTOR_TYPE.getMessage() + ", Recognized storage connector types are: " + (Object)((Object)FeaturestoreStorageConnectorType.HOPSFS) + ", " + (Object)((Object)FeaturestoreStorageConnectorType.S3) + ", and " + (Object)((Object)FeaturestoreStorageConnectorType.JDBC) + ". The provided training dataset type was not recognized: " + (Object)((Object)featurestoreStorageConnectorType));
    }

    public FeaturestoreStorageConnectorDTO createStorageConnectorWithType(Featurestore featurestore, FeaturestoreStorageConnectorType featurestoreStorageConnectorType, FeaturestoreStorageConnectorDTO featurestoreStorageConnectorDTO) throws FeaturestoreException {
        switch (featurestoreStorageConnectorType) {
            case S3: {
                return this.featurestoreS3ConnectorController.createFeaturestoreS3Connector(featurestore, (FeaturestoreS3ConnectorDTO)featurestoreStorageConnectorDTO);
            }
            case JDBC: {
                return this.featurestoreJdbcConnectorController.createFeaturestoreJdbcConnector(featurestore, (FeaturestoreJdbcConnectorDTO)featurestoreStorageConnectorDTO);
            }
            case HOPSFS: {
                return this.featurestoreHopsfsConnectorController.createFeaturestoreHopsfsConnector(featurestore, (FeaturestoreHopsfsConnectorDTO)featurestoreStorageConnectorDTO);
            }
        }
        throw new IllegalArgumentException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_STORAGE_CONNECTOR_TYPE.getMessage() + ", Recognized storage connector types are: " + (Object)((Object)FeaturestoreStorageConnectorType.HOPSFS) + ", " + (Object)((Object)FeaturestoreStorageConnectorType.S3) + ", and " + (Object)((Object)FeaturestoreStorageConnectorType.JDBC) + ". The provided training dataset type was not recognized: " + (Object)((Object)featurestoreStorageConnectorType));
    }

    public FeaturestoreStorageConnectorDTO updateStorageConnectorWithType(Featurestore featurestore, FeaturestoreStorageConnectorType featurestoreStorageConnectorType, FeaturestoreStorageConnectorDTO featurestoreStorageConnectorDTO, Integer storageConnectorId) throws FeaturestoreException {
        switch (featurestoreStorageConnectorType) {
            case S3: {
                return this.featurestoreS3ConnectorController.updateFeaturestoreS3Connector(featurestore, (FeaturestoreS3ConnectorDTO)featurestoreStorageConnectorDTO, storageConnectorId);
            }
            case JDBC: {
                return this.featurestoreJdbcConnectorController.updateFeaturestoreJdbcConnector(featurestore, (FeaturestoreJdbcConnectorDTO)featurestoreStorageConnectorDTO, storageConnectorId);
            }
            case HOPSFS: {
                return this.featurestoreHopsfsConnectorController.updateFeaturestoreHopsfsConnector(featurestore, (FeaturestoreHopsfsConnectorDTO)featurestoreStorageConnectorDTO, storageConnectorId);
            }
        }
        throw new IllegalArgumentException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_STORAGE_CONNECTOR_TYPE.getMessage() + ", Recognized storage connector types are: " + (Object)((Object)FeaturestoreStorageConnectorType.HOPSFS) + ", " + (Object)((Object)FeaturestoreStorageConnectorType.S3) + ", and " + (Object)((Object)FeaturestoreStorageConnectorType.JDBC) + ". The provided training dataset type was not recognized: " + (Object)((Object)featurestoreStorageConnectorType));
    }

    public FeaturestoreStorageConnectorDTO deleteStorageConnectorWithTypeAndId(FeaturestoreStorageConnectorType featurestoreStorageConnectorType, Integer storageConnectorId) {
        switch (featurestoreStorageConnectorType) {
            case S3: {
                return this.featurestoreS3ConnectorController.removeFeaturestoreS3Connector(storageConnectorId);
            }
            case JDBC: {
                return this.featurestoreJdbcConnectorController.removeFeaturestoreJdbcConnector(storageConnectorId);
            }
            case HOPSFS: {
                return this.featurestoreHopsfsConnectorController.removeFeaturestoreHopsfsConnector(storageConnectorId);
            }
        }
        throw new IllegalArgumentException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_STORAGE_CONNECTOR_TYPE.getMessage() + ", Recognized storage connector types are: " + (Object)((Object)FeaturestoreStorageConnectorType.HOPSFS) + ", " + (Object)((Object)FeaturestoreStorageConnectorType.S3) + ", and " + (Object)((Object)FeaturestoreStorageConnectorType.JDBC) + ". The provided training dataset type was not recognized: " + (Object)((Object)featurestoreStorageConnectorType));
    }

    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public FeaturestoreJdbcConnectorDTO getOnlineFeaturestoreConnector(Users user, Project project, String dbUsername, Featurestore featurestore, String dbName) throws FeaturestoreException {
        FeaturestoreJdbcConnectorDTO featurestoreJdbcConnectorDTO = null;
        String onlineFeaturestoreConnectorName = dbUsername + "_onlinefeaturestore";
        List<FeaturestoreStorageConnectorDTO> jdbcConnectorDTOS = this.featurestoreJdbcConnectorController.getJdbcConnectorsForFeaturestore(featurestore);
        List matchingConnectors = jdbcConnectorDTOS.stream().filter(connector -> connector.getName().equalsIgnoreCase(onlineFeaturestoreConnectorName)).collect(Collectors.toList());
        featurestoreJdbcConnectorDTO = matchingConnectors.isEmpty() ? this.featurestoreJdbcConnectorController.createJdbcConnectorForOnlineFeaturestore(dbUsername, featurestore, dbName) : (FeaturestoreJdbcConnectorDTO)matchingConnectors.get(0);
        try {
            String password = this.secretsController.get(user, dbUsername).getPlaintext();
            featurestoreJdbcConnectorDTO.setArguments(featurestoreJdbcConnectorDTO.getArguments().replaceFirst("<SECRETPASSWORD>", password));
        }
        catch (UserException e) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.FEATURESTORE_ONLINE_SECRETS_ERROR, Level.SEVERE, "Problem getting secrets for the JDBC connection to the online FS");
        }
        return featurestoreJdbcConnectorDTO;
    }
}

