/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dao.featurestore.utils;

import io.hops.hopsworks.common.dao.project.Project;
import io.hops.hopsworks.common.dao.user.Users;
import io.hops.hopsworks.common.hdfs.DistributedFileSystemOps;
import io.hops.hopsworks.common.hdfs.DistributedFsService;
import io.hops.hopsworks.common.hdfs.HdfsUsersController;
import java.io.IOException;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;

@Stateless
public class FeaturestoreUtils {
    @EJB
    private HdfsUsersController hdfsUsersController;
    @EJB
    private DistributedFsService distributedFsService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToHDFS(Project project, Users user, Path filePath, String content) throws IOException {
        DistributedFileSystemOps udfso = null;
        try {
            String hdfsUsername = this.hdfsUsersController.getHdfsUserName(project, user);
            udfso = this.distributedFsService.getDfsOps(hdfsUsername);
            try (FSDataOutputStream outStream = udfso.create(filePath);){
                outStream.writeBytes(content);
                outStream.hflush();
            }
            if (udfso != null) {
                this.distributedFsService.closeDfsClient(udfso);
            }
        }
        catch (Throwable throwable) {
            if (udfso != null) {
                this.distributedFsService.closeDfsClient(udfso);
            }
            throw throwable;
        }
    }
}

