/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dao.hdfs.inode;

import io.hops.common.Pair;
import io.hops.hopsworks.common.dao.AbstractFacade;
import io.hops.hopsworks.common.dao.hdfs.inode.Inode;
import io.hops.hopsworks.common.dao.hdfs.inode.InodePK;
import io.hops.hopsworks.common.dao.hdfs.inode.NavigationPath;
import io.hops.hopsworks.common.dao.hdfsUser.HdfsUsers;
import io.hops.hopsworks.common.hdfs.Utils;
import io.hops.hopsworks.common.util.HopsUtils;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;

@Stateless
public class InodeFacade
extends AbstractFacade<Inode> {
    private static final Logger logger = Logger.getLogger(InodeFacade.class.getName());
    @PersistenceContext(unitName="kthfsPU")
    private EntityManager em;

    @Override
    protected EntityManager getEntityManager() {
        return this.em;
    }

    public InodeFacade() {
        super(Inode.class);
    }

    public List<Inode> findByParent(Inode parent) {
        TypedQuery query = this.em.createNamedQuery("Inode.findByParentId", Inode.class);
        query.setParameter("parentId", (Object)parent.getId());
        return query.getResultList();
    }

    public List<Inode> findByHdfsUser(HdfsUsers hdfsUser) {
        TypedQuery query = this.em.createNamedQuery("Inode.findByHdfsUser", Inode.class);
        query.setParameter("hdfsUser", (Object)hdfsUser);
        return query.getResultList();
    }

    public List<Inode> getChildren(Inode parent) {
        return this.findByParent(parent);
    }

    public void getAllChildren(Inode parent, List<Inode> children) {
        List<Inode> curr = this.findByParent(parent);
        children.addAll(curr);
        for (Inode inode : curr) {
            if (!inode.isDir()) continue;
            this.getAllChildren(inode, children);
        }
    }

    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public long getSize(Inode inode) {
        if (!inode.isDir()) {
            return inode.getSize();
        }
        long size = 0L;
        List<Inode> children = this.getChildren(inode);
        for (Inode i : children) {
            if (!i.isDir()) {
                size += i.getSize();
                continue;
            }
            size += this.getSize(i);
        }
        return size;
    }

    public List<String> getChildNames(String path) {
        Inode inode = this.getInodeAtPath(path);
        if (inode.isDir()) {
            List<Inode> inodekids = this.getChildren(inode);
            ArrayList<String> retList = new ArrayList<String>(inodekids.size());
            for (Inode i : inodekids) {
                if (i.isDir()) continue;
                retList.add(i.getInodePK().getName());
            }
            return retList;
        }
        return Collections.EMPTY_LIST;
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public Inode findParent(Inode i) {
        if (i == null) {
            throw new IllegalArgumentException("Inode must be provided.");
        }
        long id = i.getInodePK().getParentId();
        TypedQuery q = this.em.createNamedQuery("Inode.findById", Inode.class);
        q.setParameter("id", (Object)id);
        try {
            return (Inode)q.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public Inode findById(Long id) {
        TypedQuery q = this.em.createNamedQuery("Inode.findById", Inode.class);
        q.setParameter("id", (Object)id);
        try {
            return (Inode)q.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    private Inode getInode(String path) {
        String[] p = path.charAt(0) == '/' ? path.substring(1).split("/") : path.split("/");
        if (p.length < 1) {
            return null;
        }
        Inode curr = this.getRootNode(p[0]);
        if (curr == null) {
            logger.log(Level.WARNING, "Could not resolve root inode at path: {0}", path);
            return null;
        }
        for (int i = 1; i < p.length; ++i) {
            long partitionId = HopsUtils.calculatePartitionId(curr.getId(), p[i], i + 1);
            Inode next = this.findByInodePK(curr, p[i], partitionId);
            if (next == null) {
                logger.log(Level.WARNING, "Could not resolve inode at path: {0} and path-component " + i, path);
                return null;
            }
            curr = next;
        }
        return curr;
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    private Inode getRootNode(String name) {
        long partitionId = HopsUtils.calculatePartitionId(HopsUtils.ROOT_INODE_ID, name, 1);
        TypedQuery query = this.em.createNamedQuery("Inode.findRootByName", Inode.class);
        query.setParameter("name", (Object)name);
        query.setParameter("parentId", (Object)HopsUtils.ROOT_INODE_ID);
        query.setParameter("partitionId", (Object)partitionId);
        try {
            return (Inode)query.getSingleResult();
        }
        catch (NoResultException e) {
            logger.log(Level.WARNING, "Could not resolve root inode with name: {0} and partition_id" + partitionId, name);
            return null;
        }
    }

    public boolean existsPath(String path) {
        return this.getInode(path) != null;
    }

    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public Inode getInodeAtPath(String path) {
        return this.getInode(path);
    }

    public Inode getProjectRoot(String name) {
        return this.getInode(Utils.getProjectPath(name));
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public Inode findByInodePK(Inode parent, String name, long partitionId) {
        TypedQuery q = this.em.createNamedQuery("Inode.findByPrimaryKey", Inode.class);
        q.setParameter("inodePk", (Object)new InodePK(parent.getId(), name, partitionId));
        try {
            return (Inode)q.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public Inode getProjectRootForInode(Inode i) throws IllegalStateException {
        if (this.isProjectRoot(i)) {
            return i;
        }
        Inode parent = this.findParent(i);
        if (parent == null) {
            throw new IllegalStateException("Transversing the path from folder did not encounter project root folder.");
        }
        return this.getProjectRootForInode(parent);
    }

    public boolean isProjectRoot(Inode i) {
        Inode parent = this.findParent(i);
        if (!parent.getInodePK().getName().equals("Projects")) {
            return false;
        }
        return parent.getInodePK().getParentId() == 1L;
    }

    public String getProjectNameForInode(Inode i) throws IllegalStateException {
        Inode projectRoot = this.getProjectRootForInode(i);
        return projectRoot.getInodePK().getName();
    }

    public List<NavigationPath> getConstituentsPath(Inode i) {
        if (this.isProjectRoot(i)) {
            ArrayList<NavigationPath> p = new ArrayList<NavigationPath>();
            p.add(new NavigationPath(i.getInodePK().getName(), i.getInodePK().getName() + "/"));
            return p;
        }
        List<NavigationPath> p = this.getConstituentsPath(this.findParent(i));
        NavigationPath a = i.isDir() ? new NavigationPath(i.getInodePK().getName(), p.get(p.size() - 1).getPath() + i.getInodePK().getName() + "/") : new NavigationPath(i.getInodePK().getName(), p.get(p.size() - 1).getPath() + i.getInodePK().getName());
        p.add(a);
        return p;
    }

    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public String getPath(Inode i) {
        if (i == null) {
            throw new IllegalArgumentException("Inode was not provided.");
        }
        ArrayList<String> pathComponents = new ArrayList<String>();
        Inode parent = i;
        while (parent.getId() != 1L) {
            pathComponents.add(parent.getInodePK().getName());
            parent = this.findParent(parent);
        }
        StringBuilder path = new StringBuilder();
        for (int j = pathComponents.size() - 1; j >= 0; --j) {
            path.append("/").append((String)pathComponents.get(j));
        }
        return path.toString();
    }

    public List<Inode> getChildren(String path) throws FileNotFoundException {
        Inode parent = this.getInode(path);
        if (parent == null) {
            throw new FileNotFoundException("Path not found : " + path);
        }
        if (!parent.isDir()) {
            throw new FileNotFoundException("Path is not a directory.");
        }
        return this.getChildren(parent);
    }

    public Pair<Inode, Inode> getProjectAndDatasetRootForInode(Inode i) throws IllegalStateException {
        Inode project = i;
        Inode dataset = i;
        do {
            dataset = project;
            if ((project = this.findParent(project)) != null) continue;
            throw new IllegalStateException("Transversing the path from folder did not encounter project root folder.");
        } while (!this.isProjectRoot(project));
        return new Pair((Object)project, (Object)dataset);
    }

    public List<Inode> findHistoryFileByHdfsUser(HdfsUsers hdfsUser) {
        TypedQuery query = this.em.createNamedQuery("Inode.findHistoryFileByHdfsUser", Inode.class);
        query.setParameter("hdfsUser", (Object)hdfsUser);
        return query.getResultList();
    }
}

