/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dao.jobhistory;

import io.hops.hopsworks.common.dao.jobs.FilesToRemove;
import io.hops.hopsworks.common.dao.jobs.description.Jobs;
import io.hops.hopsworks.common.dao.user.Users;
import io.hops.hopsworks.common.jobs.jobhistory.JobFinalStatus;
import io.hops.hopsworks.common.jobs.jobhistory.JobState;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.XmlRootElement;

@Entity
@Table(name="hopsworks.executions")
@XmlRootElement
@NamedQueries(value={@NamedQuery(name="Execution.findAll", query="SELECT e FROM Execution e"), @NamedQuery(name="Execution.findById", query="SELECT e FROM Execution e WHERE e.id = :id"), @NamedQuery(name="Execution.findByJobAndId", query="SELECT e FROM Execution e WHERE e.id = :id AND e.job = :job"), @NamedQuery(name="Execution.findBySubmissionTime", query="SELECT e FROM Execution e WHERE e.submissionTime = :submissionTime"), @NamedQuery(name="Execution.findByJobIdAndSubmissionTime", query="SELECT e FROM Execution e WHERE e.job = :job AND e.submissionTime = :submissionTime"), @NamedQuery(name="Execution.findByState", query="SELECT e FROM Execution e WHERE e.state = :state"), @NamedQuery(name="Execution.findByStates", query="SELECT e FROM Execution e WHERE e.state in :states"), @NamedQuery(name="Execution.findByJobAndStates", query="SELECT e FROM Execution e WHERE e.job = :job AND e.state in :states ORDER BY e.submissionTime DESC"), @NamedQuery(name="Execution.findByStdoutPath", query="SELECT e FROM Execution e WHERE e.stdoutPath = :stdoutPath"), @NamedQuery(name="Execution.findByStderrPath", query="SELECT e FROM Execution e WHERE e.stderrPath = :stderrPath"), @NamedQuery(name="Execution.findByAppId", query="SELECT e FROM Execution e WHERE e.appId = :appId"), @NamedQuery(name="Execution.findByProjectAndType", query="SELECT e FROM Execution e WHERE e.job.type = :type AND e.job.project = :project ORDER BY e.submissionTime DESC"), @NamedQuery(name="Execution.findByJob", query="SELECT e FROM Execution e WHERE e.job = :job ORDER BY e.submissionTime DESC"), @NamedQuery(name="Execution.findByJobSortByIdOrderByASC", query="SELECT e FROM Execution e WHERE e.job = :job ORDER BY e.id ASC"), @NamedQuery(name="Execution.findByProjectAndJobId", query="SELECT e FROM Execution e WHERE e.job.id = :jobid AND e.job.project = :project ORDER BY e.submissionTime DESC"), @NamedQuery(name="Execution.findJobsForExecutionInState", query="SELECT DISTINCT e.job FROM Execution e WHERE e.job.project = :project AND e.state IN :stateCollection ORDER BY e.submissionTime DESC"), @NamedQuery(name="Execution.findUserJobsForExecutionInState", query="SELECT DISTINCT e.job FROM Execution e WHERE e.job.project = :project AND e.hdfsUser = :hdfsUser AND e.state IN :stateCollection ORDER BY e.submissionTime DESC"), @NamedQuery(name="Execution.findUserJobsIdsForExecutionInState", query="SELECT DISTINCT e.job FROM Execution e WHERE e.job.id IN :jobids AND e.job.project = :project AND e.hdfsUser = :hdfsUser AND e.state IN :stateCollection ORDER BY e.submissionTime DESC")})
public class Execution
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Basic(optional=false)
    @Column(name="id")
    private Integer id;
    @Basic(optional=false)
    @NotNull
    @Column(name="submission_time")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date submissionTime;
    @Basic(optional=false)
    @NotNull
    @Column(name="state")
    @Enumerated(value=EnumType.STRING)
    private JobState state;
    @Column(name="execution_start")
    private long executionStart;
    @Column(name="execution_stop")
    private long executionStop;
    @Size(max=255)
    @Column(name="stdout_path")
    private String stdoutPath;
    @Size(max=255)
    @Column(name="stderr_path")
    private String stderrPath;
    @Size(max=30)
    @Column(name="app_id")
    private String appId;
    @Size(max=255)
    @Column(name="hdfs_user")
    private String hdfsUser;
    @Basic(optional=false)
    @NotNull
    @Column(name="finalStatus")
    @Enumerated(value=EnumType.STRING)
    private JobFinalStatus finalStatus;
    @Basic(optional=false)
    @NotNull
    @Column(name="progress")
    private float progress;
    @JoinColumn(name="job_id", referencedColumnName="id")
    @ManyToOne(optional=false)
    private Jobs job;
    @JoinColumn(name="user", referencedColumnName="email")
    @ManyToOne(optional=false)
    private Users user;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="execution")
    private Collection<FilesToRemove> filesToRemove;

    public Execution() {
    }

    public Execution(JobState state, Jobs job, Users user, Date submissionTime, String stdoutPath, String stderrPath, JobFinalStatus finalStatus, float progress, String hdfsUser) {
        this.submissionTime = submissionTime;
        this.state = state;
        this.stdoutPath = stdoutPath;
        this.stderrPath = stderrPath;
        this.job = job;
        this.user = user;
        this.hdfsUser = hdfsUser;
        this.finalStatus = finalStatus;
        this.progress = progress;
        this.executionStart = -1L;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Date getSubmissionTime() {
        return this.submissionTime;
    }

    public void setSubmissionTime(Date submissionTime) {
        this.submissionTime = submissionTime;
    }

    public JobState getState() {
        return this.state;
    }

    public void setState(JobState state) {
        this.state = state;
    }

    public JobFinalStatus getFinalStatus() {
        return this.finalStatus;
    }

    public void setFinalStatus(JobFinalStatus finalStatus) {
        this.finalStatus = finalStatus;
    }

    public float getProgress() {
        return this.progress;
    }

    public void setProgress(float progress) {
        this.progress = progress;
    }

    public long getExecutionDuration() {
        if (this.executionStart == -1L) {
            return 0L;
        }
        if (this.executionStop > this.executionStart) {
            return this.executionStop - this.executionStart;
        }
        return System.currentTimeMillis() - this.executionStart;
    }

    public void setExecutionStart(long executionStart) {
        this.executionStart = executionStart;
    }

    public void setExecutionStop(long executionStop) {
        this.executionStop = executionStop;
    }

    public String getStdoutPath() {
        return this.stdoutPath;
    }

    public void setStdoutPath(String stdoutPath) {
        this.stdoutPath = stdoutPath;
    }

    public String getStderrPath() {
        return this.stderrPath;
    }

    public void setStderrPath(String stderrPath) {
        this.stderrPath = stderrPath;
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public Jobs getJob() {
        return this.job;
    }

    public void setJob(Jobs job) {
        this.job = job;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.id != null ? this.id.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Execution)) {
            return false;
        }
        Execution other = (Execution)object;
        return (this.id != null || other.id == null) && (this.id == null || this.id.equals(other.id));
    }

    public String toString() {
        return "Execution " + this.id + " of job " + this.job;
    }

    public Users getUser() {
        return this.user;
    }

    public void setUser(Users user) {
        this.user = user;
    }

    public String getHdfsUser() {
        return this.hdfsUser;
    }

    public void setHdfsUser(String hdfsUser) {
        this.hdfsUser = hdfsUser;
    }

    public void setFilesToRemove(List<String> filesToRemove) {
        ArrayList<FilesToRemove> toRemove = new ArrayList<FilesToRemove>();
        for (String fileToRemove : filesToRemove) {
            toRemove.add(new FilesToRemove(this.id.intValue(), fileToRemove));
        }
        this.filesToRemove = toRemove;
    }

    public List<String> getFilesToRemove() {
        ArrayList<String> toRemove = new ArrayList<String>();
        for (FilesToRemove fileToRemove : this.filesToRemove) {
            toRemove.add(fileToRemove.getFilesToRemovePK().getFilepath());
        }
        return toRemove;
    }
}

