/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dao.user.security.audit;

import io.hops.hopsworks.common.dao.AbstractFacade;
import io.hops.hopsworks.common.dao.user.Users;
import io.hops.hopsworks.common.dao.user.security.audit.AccountAudit;
import io.hops.hopsworks.common.dao.user.security.audit.RolesAudit;
import io.hops.hopsworks.common.dao.user.security.audit.Userlogins;
import io.hops.hopsworks.common.util.Settings;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;

@Stateless
public class AccountAuditFacade
extends AbstractFacade<AccountAudit> {
    @PersistenceContext(unitName="kthfsPU")
    private EntityManager em;
    @EJB
    private Settings settings;
    private Set<String> whitelistUserLogins;

    @Override
    protected EntityManager getEntityManager() {
        return this.em;
    }

    public AccountAuditFacade() {
        super(AccountAudit.class);
    }

    @PostConstruct
    private void init() {
        this.whitelistUserLogins = new HashSet<String>();
        String whitelist = this.settings.getWhitelistUsersLogin();
        String[] whitelistTokens = whitelist.split(",");
        Collections.addAll(this.whitelistUserLogins, whitelistTokens);
    }

    public Userlogins getLastUserLogin(Users user) {
        TypedQuery query = this.em.createNamedQuery("Userlogins.findUserLast", Userlogins.class).setParameter("user", (Object)user).setMaxResults(1);
        List logins = query.getResultList();
        if (!logins.isEmpty()) {
            return (Userlogins)logins.get(0);
        }
        return null;
    }

    public void registerLoginInfo(Users user, String action, String outcome, HttpServletRequest req) {
        if (!this.whitelistUserLogins.contains(user.getEmail())) {
            Userlogins userlogin = new Userlogins(req.getRemoteHost(), this.extractUserAgent(req), user, action, outcome, new Date());
            this.em.persist((Object)userlogin);
        }
    }

    public void registerRoleChange(Users user, String action, String outcome, String message, Users targetUser, HttpServletRequest req) {
        RolesAudit rolesAudit = new RolesAudit(action, new Date(), message, this.extractUserAgent(req), req.getRemoteHost(), outcome, targetUser, user);
        this.em.persist((Object)rolesAudit);
    }

    public void registerAccountChange(Users init, String action, String outcome, String message, Users target, HttpServletRequest req) {
        AccountAudit accountAudit = new AccountAudit(action, new Date(), message, outcome, req.getRemoteHost(), this.extractUserAgent(req), target, init);
        this.em.persist((Object)accountAudit);
    }

    public List<AccountAudit> findByInitiator(Users user) {
        TypedQuery query = this.em.createNamedQuery("AccountAudit.findByInitiator", AccountAudit.class);
        query.setParameter("initiator", (Object)user);
        return query.getResultList();
    }

    public List<AccountAudit> findByTarget(Users user) {
        TypedQuery query = this.em.createNamedQuery("AccountAudit.findByTarget", AccountAudit.class);
        query.setParameter("target", (Object)user);
        return query.getResultList();
    }

    private String extractUserAgent(HttpServletRequest httpServletRequest) {
        String userAgent = httpServletRequest.getHeader("User-Agent");
        if (userAgent == null || userAgent.isEmpty()) {
            return "Unknown User-Agent";
        }
        return StringUtils.left((String)userAgent, (int)255);
    }
}

