/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dao.user.security.ua;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlType;

@XmlType(name="SecurityQuestion")
@XmlEnum
public enum SecurityQuestion {
    MAIDEN_NAME("Mother's maiden name?"),
    PET("Name of your first pet?"),
    LOVE("Name of your first love?"),
    NICK_NAME("What was your childhood nickname?"),
    CHILDHOOD_FRIEND("What is the name of your favorite childhood friend?"),
    STREET("What street did you live on in third grade?"),
    SIBLING_MAIDEN_NAME("What is your oldest sibling's middle name?"),
    SCHOOL("What school did you attend for sixth grade?"),
    COUSIN_MAIDEN_NAME("What is your oldest cousin's first and last name?"),
    STUFFED_ANIMAL("What was the name of your first stuffed animal?"),
    SIBLING_LIVE("In what city does your nearest sibling live?"),
    FIRST_JOB_TOWN("In what city or town was your first job?");

    private final String value;
    private static final List<SecurityQuestion> VALUES;
    private static final int SIZE;
    private static final Random RANDOM;

    private SecurityQuestion(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public static SecurityQuestion getQuestion(String text) {
        if (text != null) {
            for (SecurityQuestion b : SecurityQuestion.values()) {
                if (!text.equalsIgnoreCase(b.value)) continue;
                return b;
            }
        }
        return null;
    }

    public String toString() {
        return this.value;
    }

    public static SecurityQuestion randomQuestion() {
        return VALUES.get(RANDOM.nextInt(SIZE));
    }

    static {
        VALUES = Collections.unmodifiableList(Arrays.asList(SecurityQuestion.values()));
        SIZE = VALUES.size();
        RANDOM = new Random();
    }
}

