/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dao.user.security.ua;

import io.hops.hopsworks.common.dao.user.security.apiKey.ApiScope;
import java.util.Date;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class UserAccountsEmailMessages {
    public static final String ACCOUNT_REQUEST_SUBJECT = "Your Hopsworks account needs verification";
    public static final String CLUSTER_REQUEST_SUBJECT = "Your Hopsworks cluster needs verification";
    public static final String ACCOUNT_CONFIRMATION_SUBJECT = "Welcome to Hopsworks!";
    public static final String DEVICE_LOST_SUBJECT = "Login issue";
    public static final String ACCOUNT_BLOCKED__SUBJECT = "Your account is locked";
    public static String HOPSWORKS_SUPPORT_EMAIL = "support@hops.io";
    public static final String ACCOUNT_PROFILE_UPDATE = "Your profile has been updated";
    public static final String ACCOUNT_PASSWORD_RECOVERY_SUBJECT = "You have requested to recover your password";
    public static final String ACCOUNT_MOBILE_RECOVERY_SUBJECT = "You have requested to recover a lost device";
    public static final String ACCOUNT_PASSWORD_RESET = "Your password has been reset";
    public static final String ACCOUNT_QR_RESET = "Your QR code has been reset";
    public static final String ACCOUNT_REJECT = "Your Hopsworks account request has been rejected";
    public static final int ACCOUNT_ACTIVATION_PERIOD = 48;
    public static final String GREETINGS_HEADER = "Hello";
    public static final String ACCOUNT_DEACTIVATED = "Your Hopsworks account has expired";
    public static final String API_KEY_CREATED_SUBJECT = "Api key created";
    public static final String API_KEY_DELETED_SUBJECT = "Api key deleted";

    @Deprecated
    public static String buildMobileRequestMessage(String path, String key) {
        String l1 = "Hello,\n\nWe received an account request for HopsWorks on your behalf.\n\n";
        String l2 = "Please click on the following link to verify your email address. We will activate your account within 48 hours after validating your email address.\n\n\n";
        String url = path + "/hopsworks-admin/security/validate_account.xhtml?key=" + key;
        String l3 = "To confirm your email click " + url + " \n\n";
        String l4 = "If you have any questions please contact " + HOPSWORKS_SUPPORT_EMAIL;
        String message = l1 + l2 + l3 + l4;
        return message;
    }

    public static String buildMobileRequestMessageRest(String path, String key, long validFor) {
        String l1 = "Hello,\n\nWe received an account request for Hopsworks on your behalf.\n\n";
        String l2 = "Please click on the following link to verify your email address. We will activate your account within 48 hours after validating your email address.\n\n\n";
        String url = path + "?key=" + key;
        String l3 = "To confirm your email click " + url + " \n\n";
        String l4 = "If you did not request an account, please ignore this email. This link is only valid for" + UserAccountsEmailMessages.formatTime(validFor) + ". \n\n";
        String l5 = "If you have any questions please contact " + HOPSWORKS_SUPPORT_EMAIL;
        String message = l1 + l2 + l3 + l4 + l5;
        return message;
    }

    public static String buildPasswordRecoveryMessage(String path, String key, long validFor) {
        String l1 = "Hello,\n\n We received a password recovery request for Hopsworks on your behalf.\n\n";
        String l2 = "Please click on the following link to recover your password: \n";
        String url = path + "/hopsworks/#!/passwordRecovery?key=" + key;
        String l3 = url + " \n\n";
        String l4 = "If you did not request a password reset, please ignore this email. This password reset link is only valid for " + UserAccountsEmailMessages.formatTime(validFor) + ". \n\n";
        String l5 = "If you have any questions please contact " + HOPSWORKS_SUPPORT_EMAIL;
        String message = l1 + l2 + l3 + l4 + l5;
        return message;
    }

    public static String buildQRRecoveryMessage(String path, String key, long validFor) {
        String l1 = "Hello,\n\n We received a lost mobile recovery request for Hopsworks on your behalf.\n\n";
        String l2 = "Please click on the following link to recover your QR code: \n";
        String url = path + "/hopsworks/#!/qrRecovery?key=" + key;
        String l3 = url + " \n\n";
        String l4 = "If you did not request a QR code reset, please ignore this email. This QR code reset link is only valid for " + UserAccountsEmailMessages.formatTime(validFor) + ". \n\n";
        String l5 = "If you have any questions please contact " + HOPSWORKS_SUPPORT_EMAIL;
        String message = l1 + l2 + l3 + l4 + l5;
        return message;
    }

    public static String formatTime(long validForMs) {
        long hh = TimeUnit.MILLISECONDS.toHours(validForMs);
        long mm = TimeUnit.MILLISECONDS.toMinutes(validForMs) % 60L;
        StringBuilder validFor = new StringBuilder();
        if (hh > 0L) {
            validFor.append(hh).append(hh == 1L ? " hour" : " hours");
        }
        if (hh > 0L && mm > 0L) {
            validFor.append(" and ").append(mm).append(mm == 1L ? " minute" : " minutes");
        } else if (mm > 0L) {
            validFor.append(mm).append(mm == 1L ? " minute" : " minutes");
        }
        return validFor.toString();
    }

    public static String accountBlockedMessage() {
        String l1 = "Hello,\n\nYour Hopsworks account has been blocked.\n\n";
        String l2 = "If you have any questions please visit www.hops.io or contact support@hops.io";
        String l3 = "If you have any questions please contact " + HOPSWORKS_SUPPORT_EMAIL;
        String message = l1 + l2 + l3;
        return message;
    }

    public static String buildPasswordResetMessage(String random_password) {
        String l1 = "Hello,\n\nA password reset has been requested on your behalf.\n\nPlease use the temporary password below. You will be required to change your passsword when you login first time.\n\n";
        String tmp_pass = "Password:" + random_password + "\n\n\n";
        String l3 = "If you have any questions please contact " + HOPSWORKS_SUPPORT_EMAIL;
        String message = l1 + tmp_pass + l3;
        return message;
    }

    public static String buildDeactivatedMessage() {
        String l1 = "Hello,\n\nA password reset has been requested on your behalf.\n\n After too many fail at answering the security question, your account has been deactivated\n\n";
        String l3 = "To reactivate you account please contact " + HOPSWORKS_SUPPORT_EMAIL;
        String message = l1 + l3;
        return message;
    }

    public static String buildWrongAnswerMessage() {
        String l1 = "Hello,\n\nA password reset has been requested on your behalf.\n\n You have provided the wrong answer to the security question. Please, try again.\n\n";
        String l3 = "If you have any questions please contact " + HOPSWORKS_SUPPORT_EMAIL;
        String message = l1 + l3;
        return message;
    }

    public static String buildSecResetMessage() {
        String l1 = "Hello,\n\nA security question change has been requested on your behalf.\n\n";
        String l2 = "Your security question has been changed successfully.\n\n\n";
        String l3 = "If you have any questions please contact " + HOPSWORKS_SUPPORT_EMAIL;
        String message = l1 + l2 + l3;
        return message;
    }

    public static String buildDeactMessage() {
        String l1 = "Hello,\n\nWe received an account deactivation request and your Hopsworks account has been deactivated.\n\n";
        String l2 = "If you have any questions please contact " + HOPSWORKS_SUPPORT_EMAIL;
        String message = l1 + l2;
        return message;
    }

    public static String buildResetMessage() {
        String l1 = "Hello,\n\nA password reset has been requested on your behalf.\n\n";
        String l2 = "Your password has been changed successfully.\n\n\n";
        String l3 = "If you have any questions please contact " + HOPSWORKS_SUPPORT_EMAIL;
        String message = l1 + l2 + l3;
        return message;
    }

    public static String buildQRResetMessage() {
        String l1 = "Hello,\n\n A lost device has been reported on Hopsworks.\n\n";
        String l2 = "Your QR code has been changed successfully.\n\n\n";
        String l3 = "If you have any questions please contact " + HOPSWORKS_SUPPORT_EMAIL;
        String message = l1 + l2 + l3;
        return message;
    }

    public static String accountActivatedMessage(String username) {
        String l1 = "Hello,\n\nYour account request to access Hopsworks has been approved.\n\n";
        String l2 = "You can login with your username: " + username + " and other credentials you setup.\n\n\n";
        String l3 = "If you have any questions please contact " + HOPSWORKS_SUPPORT_EMAIL;
        String message = l1 + l2 + l3;
        return message;
    }

    public static String accountRejectedMessage() {
        String l1 = "Hello,\n\nYour Hopsworks account request has been rejected.\n\n";
        String l2 = "If you have any questions please contact " + HOPSWORKS_SUPPORT_EMAIL;
        String message = l1 + l2;
        return message;
    }

    public static String buildTempResetMessage(String random_password) {
        String l1 = "Hello,\n\nA mobile device reset has been requested on your behalf.\n\nPlease use the temporary password below.You need to validate the code to get a new setup.\n\n";
        String tmp_pass = "Code:" + random_password + "\n\n\n";
        String l2 = "If you have any questions please contact " + HOPSWORKS_SUPPORT_EMAIL;
        String message = l1 + tmp_pass + l2;
        return message;
    }

    public static String buildClusterRegisterRequestMessage(String path, String key) {
        String l1 = "Hello,\n\nWe received an account request for Hopsworks on your behalf.\n\n";
        String l2 = "Please click on the following link to verify your email address. Within48 hours of getting this email.\n\n\n";
        String url = path + "/hopsworks-cluster/api/cluster/register/confirm/" + key;
        String l3 = "To confirm your email click " + url + " \n\n";
        String l4 = "If you have any questions please contact " + HOPSWORKS_SUPPORT_EMAIL;
        String message = l1 + l2 + l3 + l4;
        return message;
    }

    public static String buildClusterUnregisterRequestMessage(String path, String key) {
        String l1 = "Hello,\n\nWe received a cluster remove request for Hops.site on your behalf.\n\n";
        String l2 = "Please click on the link below to verify your email address. Within48 hours of getting this email.\n\n\n";
        String url = path + "/hopsworks-cluster/api/cluster/unregister/confirm/" + key;
        String l3 = "To confirm this request click " + url + " \n\n";
        String l4 = "If you have any questions please contact " + HOPSWORKS_SUPPORT_EMAIL;
        String message = l1 + l2 + l3 + l4;
        return message;
    }

    public static String buildApiKeyCreatedMessage(String keyName, Date createdOn, String email, Set<ApiScope> scopes) {
        String l1 = "Hello,\n\nYou have successfully created an api key for your Hopsworks Account " + email + " named \"" + keyName + "\" on " + createdOn + ".\nThis api key will allow you to access your Hopsworks account from a device or application that can not login with a username and password. Attaching this api key on a request authentication header will allow you to access any hopsworks service in the scope: " + scopes + ".\n";
        String l2 = "Don't recognize this activity? please contact " + HOPSWORKS_SUPPORT_EMAIL;
        String message = l1 + l2;
        return message;
    }

    public static String buildApiKeyDeletedMessage(String keyName, Date deletedOn, String email) {
        String l1 = "Hello,\n\nYou have deleted an api key created for your Hopsworks Account " + email + " named \"" + keyName + "\" on " + deletedOn + ".\n";
        String l2 = "Don't recognize this activity? please contact " + HOPSWORKS_SUPPORT_EMAIL;
        String message = l1 + l2;
        return message;
    }

    public static String buildApiKeyDeletedAllMessage(Date deletedOn, String email) {
        String l1 = "Hello,\n\nYou have deleted all api keys created for your Hopsworks Account " + email + " on " + deletedOn + ".\n";
        String l2 = "Don't recognize this activity? please contact " + HOPSWORKS_SUPPORT_EMAIL;
        String message = l1 + l2;
        return message;
    }
}

