/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dataset;

import io.hops.common.Pair;
import io.hops.hopsworks.common.dao.dataset.Dataset;
import io.hops.hopsworks.common.dao.dataset.DatasetFacade;
import io.hops.hopsworks.common.dao.hdfs.inode.Inode;
import io.hops.hopsworks.common.dao.hdfs.inode.InodeFacade;
import io.hops.hopsworks.common.dao.log.operation.OperationType;
import io.hops.hopsworks.common.dao.log.operation.OperationsLog;
import io.hops.hopsworks.common.dao.log.operation.OperationsLogFacade;
import io.hops.hopsworks.common.dao.metadata.InodeBasicMetadata;
import io.hops.hopsworks.common.dao.metadata.Template;
import io.hops.hopsworks.common.dao.metadata.db.InodeBasicMetadataFacade;
import io.hops.hopsworks.common.dao.metadata.db.TemplateFacade;
import io.hops.hopsworks.common.dao.project.Project;
import io.hops.hopsworks.common.dao.project.ProjectFacade;
import io.hops.hopsworks.common.dao.project.team.ProjectTeamFacade;
import io.hops.hopsworks.common.dao.user.Users;
import io.hops.hopsworks.common.dao.user.activity.ActivityFacade;
import io.hops.hopsworks.common.dao.user.activity.ActivityFlag;
import io.hops.hopsworks.common.dataset.FilePreviewDTO;
import io.hops.hopsworks.common.dataset.FolderNameValidator;
import io.hops.hopsworks.common.hdfs.DistributedFileSystemOps;
import io.hops.hopsworks.common.hdfs.DistributedFsService;
import io.hops.hopsworks.common.hdfs.HdfsUsersController;
import io.hops.hopsworks.common.hdfs.Utils;
import io.hops.hopsworks.common.util.HopsUtils;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.exceptions.DatasetException;
import io.hops.hopsworks.exceptions.HopsSecurityException;
import io.hops.hopsworks.restutils.RESTCodes;
import java.io.DataInputStream;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.security.AccessControlException;

@Stateless
public class DatasetController {
    private static final Logger LOGGER = Logger.getLogger(DatasetController.class.getName());
    @EJB
    private InodeFacade inodes;
    @EJB
    private TemplateFacade templates;
    @EJB
    private DatasetFacade datasetFacade;
    @EJB
    private ProjectFacade projectFacade;
    @EJB
    private ActivityFacade activityFacade;
    @EJB
    private InodeBasicMetadataFacade inodeBasicMetaFacade;
    @EJB
    private HdfsUsersController hdfsUsersBean;
    @EJB
    private OperationsLogFacade operationsLogFacade;
    @EJB
    private ProjectTeamFacade projectTeamFacade;
    @EJB
    private DistributedFsService dfs;
    @EJB
    private Settings settings;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public void createDataset(Users user, Project project, String dataSetName, String datasetDescription, int templateId, boolean searchable, boolean stickyBit, boolean defaultDataset, DistributedFileSystemOps dfso) throws DatasetException, HopsSecurityException {
        FsAction global;
        if (user == null || project == null || dataSetName == null) {
            throw new IllegalArgumentException("User, project or dataset were not provided");
        }
        FolderNameValidator.isValidName(dataSetName, false);
        String dsPath = Utils.getProjectPath(project.getName()) + dataSetName;
        Inode parent = this.inodes.getProjectRoot(project.getName());
        Inode ds = this.inodes.findByInodePK(parent, dataSetName, HopsUtils.dataSetPartitionId(parent, dataSetName));
        if (ds != null) {
            throw new DatasetException(RESTCodes.DatasetErrorCode.DESTINATION_EXISTS, Level.FINE, "Dataset name: " + dataSetName);
        }
        FsAction group = defaultDataset ? FsAction.ALL : FsAction.READ_EXECUTE;
        FsPermission fsPermission = new FsPermission(FsAction.ALL, group, global = FsAction.NONE, stickyBit);
        boolean success = this.createFolder(dsPath, templateId, fsPermission, dfso);
        if (!success) throw new DatasetException(RESTCodes.DatasetErrorCode.DATASET_OPERATION_ERROR, Level.INFO, "Could not create dataset: " + dataSetName);
        try {
            ds = this.inodes.findByInodePK(parent, dataSetName, HopsUtils.dataSetPartitionId(parent, dataSetName));
            Dataset newDS = new Dataset(ds, project);
            newDS.setSearchable(searchable);
            if (datasetDescription != null) {
                newDS.setDescription(datasetDescription);
            }
            this.datasetFacade.persistDataset(newDS);
            this.activityFacade.persistActivity(" added a new dataset named " + dataSetName, project, user, ActivityFlag.DATASET);
            this.hdfsUsersBean.addDatasetUsersGroups(user, project, newDS, dfso);
            if (!searchable) return;
            dfso.setMetaEnabled(dsPath);
            Dataset logDs = this.getByProjectAndDsName(project, null, dataSetName);
            this.logDataset(logDs, OperationType.Add);
            return;
        }
        catch (Exception e) {
            try {
                dfso.rm(new Path(dsPath), true);
                throw new DatasetException(RESTCodes.DatasetErrorCode.DATASET_OPERATION_ERROR, Level.SEVERE, "Could not create dataset: " + dataSetName, e.getMessage(), (Throwable)e);
            }
            catch (IOException ex) {
                LOGGER.log(Level.SEVERE, "Could not cleanup dataset dir after exception: " + dsPath, ex);
            }
            throw new DatasetException(RESTCodes.DatasetErrorCode.DATASET_OPERATION_ERROR, Level.SEVERE, "Could not create dataset: " + dataSetName, e.getMessage(), (Throwable)e);
        }
    }

    public void createSubDirectory(Project project, Path dirPath, int templateId, String description, boolean searchable, DistributedFileSystemOps udfso) throws DatasetException, HopsSecurityException {
        if (project == null) {
            throw new NullPointerException("Cannot create a directory under a null project.");
        }
        if (dirPath == null) {
            throw new NullPointerException("Cannot create a directory for an empty path.");
        }
        String folderName = dirPath.getName();
        String parentPath = dirPath.getParent().toString();
        FolderNameValidator.isValidName(folderName, true);
        if (this.inodes.existsPath(dirPath.toString())) {
            throw new DatasetException(RESTCodes.DatasetErrorCode.DATASET_SUBDIR_ALREADY_EXISTS, Level.FINE, "The given path: " + dirPath.toString() + " already exists");
        }
        Inode parent = this.inodes.getInodeAtPath(parentPath);
        if (parent == null) {
            throw new IllegalArgumentException("Path for parent folder does not exist: " + parentPath + " under " + project.getName());
        }
        boolean success = this.createFolder(dirPath.toString(), templateId, null, udfso);
        if (success) {
            long partitionId = HopsUtils.calculatePartitionId(parent.getId(), folderName, dirPath.depth());
            Inode folder = this.inodes.findByInodePK(parent, folderName, partitionId);
            InodeBasicMetadata basicMeta = new InodeBasicMetadata(folder, description, searchable);
            this.inodeBasicMetaFacade.addBasicMetadata(basicMeta);
        }
    }

    public boolean deleteDatasetDir(Dataset dataset, Path location, DistributedFileSystemOps udfso) throws IOException {
        OperationsLog log = new OperationsLog(dataset, OperationType.Delete);
        udfso.unsetMetaEnabled(location);
        boolean success = udfso.rm(location, true);
        if (success) {
            this.operationsLogFacade.persist(log);
        }
        return success;
    }

    public void changePermissions(Dataset orgDs) {
        for (Dataset ds : this.datasetFacade.findByInode(orgDs.getInode())) {
            ds.setEditable(orgDs.getEditable());
            this.datasetFacade.merge(ds);
        }
    }

    public void recChangeOwnershipAndPermission(Path path, FsPermission permission, String username, String group, DistributedFileSystemOps dfso, DistributedFileSystemOps udfso) throws IOException {
        if (username != null && group != null && dfso != null) {
            dfso.setOwner(path, username, group);
        }
        udfso.setPermission(path, permission);
        Inode rootInode = this.inodes.getInodeAtPath(path.toString());
        Stack<Pair> dirs = new Stack<Pair>();
        if (rootInode.isDir()) {
            dirs.push(new Pair((Object)rootInode, (Object)path));
        }
        while (!dirs.isEmpty()) {
            Pair dirInode = (Pair)dirs.pop();
            for (Inode child : this.inodes.getChildren((Inode)dirInode.getL())) {
                Path childPath = new Path((Path)dirInode.getR(), child.getInodePK().getName());
                if (username != null && group != null && dfso != null) {
                    dfso.setOwner(childPath, username, group);
                }
                udfso.setPermission(childPath, permission);
                if (!child.isDir()) continue;
                dirs.push(new Pair((Object)child, (Object)childPath));
            }
        }
    }

    private boolean createFolder(String path, int template, FsPermission fsPermission, DistributedFileSystemOps dfso) throws HopsSecurityException {
        boolean success;
        Path location = new Path(path);
        try {
            if (fsPermission == null) {
                fsPermission = dfso.getParentPermission(location);
            }
            if (success = dfso.mkdir(location, fsPermission)) {
                dfso.setPermission(location, fsPermission);
            }
            if (success && template != 0 && template != -1) {
                Inode created = this.inodes.getInodeAtPath(path);
                Template templ = this.templates.findByTemplateId(template);
                if (templ != null) {
                    templ.getInodes().add(created);
                    this.templates.updateTemplatesInodesMxN(templ);
                }
            }
        }
        catch (IOException ex) {
            throw new HopsSecurityException(RESTCodes.SecurityErrorCode.HDFS_ACCESS_CONTROL, Level.WARNING, "path: " + path, ex.getMessage(), (Throwable)ex);
        }
        return success;
    }

    public void generateReadme(DistributedFileSystemOps udfso, String dsName, String description, String project) {
        if (udfso != null) {
            String readmeFile = String.format("*This is an auto-generated README.md file for your Dataset!*\nTo replace it, go into your DataSet and edit the README.md file.\n\n*%s* DataSet\n===\n\n## %s", dsName, description);
            StringBuilder readmeSb = new StringBuilder();
            readmeSb.append(Utils.getProjectPath(project)).append(dsName).append(File.separator).append("README.md");
            String readMeFilePath = readmeSb.toString();
            try (FSDataOutputStream fsOut = udfso.create(readMeFilePath);){
                fsOut.writeBytes(readmeFile);
                fsOut.flush();
                udfso.setPermission(new Path(readMeFilePath), new FsPermission(FsAction.ALL, FsAction.READ_EXECUTE, FsAction.NONE));
            }
            catch (IOException ex) {
                LOGGER.log(Level.WARNING, "README.md could not be generated for project {0} and dataset {1}.", new Object[]{project, dsName});
            }
        } else {
            LOGGER.log(Level.WARNING, "README.md could not be generated for project {0} and dataset {1}. DFS client was null", new Object[]{project, dsName});
        }
    }

    public FilePreviewDTO getReadme(String path, DistributedFileSystemOps dfso) throws IOException {
        if (path == null || dfso == null) {
            throw new IllegalArgumentException("One or more arguments are not set.");
        }
        if (!path.endsWith("README.md")) {
            throw new IllegalArgumentException("Path does not contain readme file.");
        }
        FilePreviewDTO filePreviewDTO = null;
        try (FilterInputStream dis = null;){
            if (!dfso.exists(path) || dfso.isDir(path)) {
                throw new IOException("The file does not exist");
            }
            dis = new DataInputStream((InputStream)dfso.open(path));
            long fileSize = dfso.getFileStatus(new Path(path)).getLen();
            if (fileSize > 393216L) {
                throw new IllegalArgumentException("README.md must be smaller than393216 to be previewd");
            }
            byte[] headContent = new byte[(int)fileSize];
            ((DataInputStream)dis).readFully(headContent, 0, (int)fileSize);
            filePreviewDTO = new FilePreviewDTO("text", "md", new String(headContent));
        }
        return filePreviewDTO;
    }

    public void logDataset(Dataset dataset, OperationType type) {
        if (dataset.isShared() || !dataset.isSearchable()) {
            return;
        }
        this.operationsLogFacade.persist(new OperationsLog(dataset, type));
    }

    public Path getDatasetPath(Dataset ds) {
        Path path = null;
        switch (ds.getType()) {
            case DATASET: {
                Project owningProject = this.getOwningProject(ds);
                path = new Path(Utils.getProjectPath(owningProject.getName()), ds.getInode().getInodePK().getName());
                break;
            }
            case FEATURESTORE: 
            case HIVEDB: {
                path = new Path(this.settings.getHiveWarehouse(), ds.getInode().getInodePK().getName());
            }
        }
        return path;
    }

    public Project getOwningProject(Dataset ds) {
        if (!ds.isShared()) {
            return ds.getProject();
        }
        switch (ds.getType()) {
            case DATASET: {
                Inode projectInode = this.inodes.findParent(ds.getInode());
                return this.projectFacade.findByName(projectInode.getInodePK().getName());
            }
            case HIVEDB: {
                String dbName = ds.getInode().getInodePK().getName();
                return this.projectFacade.findByNameCaseInsensitive(dbName.substring(0, dbName.lastIndexOf(46)));
            }
            case FEATURESTORE: {
                String dbName = ds.getInode().getInodePK().getName();
                return this.projectFacade.findByNameCaseInsensitive(dbName.substring(0, dbName.lastIndexOf(95)));
            }
        }
        return null;
    }

    public Project getOwningProject(Inode ds) {
        String datasetName;
        Inode parent = this.inodes.findParent(ds);
        Project proj = this.projectFacade.findByName(parent.getInodePK().getName());
        if (proj == null && (datasetName = ds.getInodePK().getName()).endsWith(".db")) {
            String projectName = datasetName.endsWith("_featurestore.db") ? datasetName.substring(0, datasetName.lastIndexOf("_")) : datasetName.substring(0, datasetName.lastIndexOf("."));
            proj = this.projectFacade.findByNameCaseInsensitive(projectName);
        }
        return proj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDownloadAllowed(Project project, Users user, String path) {
        String role = this.projectTeamFacade.findCurrentRole(project, user);
        if (role.equals("Data owner")) {
            return true;
        }
        if (role.equals("Data scientist")) {
            DistributedFileSystemOps udfso = null;
            try {
                String username = this.hdfsUsersBean.getHdfsUserName(project, user);
                udfso = this.dfs.getDfsOps(username);
                String owner = udfso.getFileStatus(new Path(path)).getOwner();
                String projectUser = this.hdfsUsersBean.getHdfsUserName(project, user);
                if (owner.equals(projectUser)) {
                    boolean bl = true;
                    if (udfso != null) {
                        this.dfs.closeDfsClient(udfso);
                    }
                    return bl;
                }
                if (udfso != null) {
                    this.dfs.closeDfsClient(udfso);
                }
            }
            catch (IOException ex) {
                try {
                    LOGGER.log(Level.SEVERE, "Could not get owner of file: " + path, ex);
                    if (udfso != null) {
                        this.dfs.closeDfsClient(udfso);
                    }
                }
                catch (Throwable throwable) {
                    if (udfso != null) {
                        this.dfs.closeDfsClient(udfso);
                    }
                    throw throwable;
                }
            }
        }
        return false;
    }

    public void unsetMetaEnabledForAllDatasets(DistributedFileSystemOps dfso, Project project) throws IOException {
        Collection<Dataset> datasets = project.getDatasetCollection();
        for (Dataset dataset : datasets) {
            if (!dataset.isSearchable() || dataset.isShared()) continue;
            Path dspath = this.getDatasetPath(dataset);
            dfso.unsetMetaEnabled(dspath);
        }
    }

    public Dataset getByProjectAndDsName(Project currentProject, String inodeParentPath, String dsName) {
        Inode parentInode = this.inodes.getInodeAtPath(inodeParentPath == null ? Utils.getProjectPath(currentProject.getName()) : inodeParentPath);
        Inode dsInode = this.inodes.findByInodePK(parentInode, dsName, HopsUtils.calculatePartitionId(parentInode.getId(), dsName, 3));
        if (dsInode == null && dsName.endsWith(".db")) {
            parentInode = this.inodes.getInodeAtPath(this.settings.getHiveWarehouse());
            dsInode = this.inodes.findByInodePK(parentInode, dsName, HopsUtils.calculatePartitionId(parentInode.getId(), dsName, 3));
        }
        if (currentProject == null || dsInode == null) {
            return null;
        }
        return this.datasetFacade.findByProjectAndInode(currentProject, dsInode);
    }

    public void checkFileExists(Path filePath, String username) throws DatasetException {
        boolean exist;
        DistributedFileSystemOps udfso = null;
        try {
            udfso = this.dfs.getDfsOps(username);
            exist = udfso.exists(filePath);
        }
        catch (AccessControlException ae) {
            throw new DatasetException(RESTCodes.DatasetErrorCode.DATASET_ACCESS_PERMISSION_DENIED, Level.FINE, "path: " + filePath.toString(), ae.getMessage(), (Throwable)ae);
        }
        catch (IOException ex) {
            throw new DatasetException(RESTCodes.DatasetErrorCode.INODE_NOT_FOUND, Level.FINE, "path: " + filePath.toString(), ex.getMessage(), (Throwable)ex);
        }
        finally {
            if (udfso != null) {
                this.dfs.closeDfsClient(udfso);
            }
        }
        if (!exist) {
            throw new DatasetException(RESTCodes.DatasetErrorCode.INODE_NOT_FOUND, Level.FINE, "path: " + filePath.toString());
        }
    }
}

