/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.hdfs;

import io.hops.hopsworks.common.dao.dataset.Dataset;
import io.hops.hopsworks.common.dao.dataset.DatasetFacade;
import io.hops.hopsworks.common.dao.hdfs.inode.InodeFacade;
import io.hops.hopsworks.common.dao.hdfsUser.HdfsGroups;
import io.hops.hopsworks.common.dao.hdfsUser.HdfsGroupsFacade;
import io.hops.hopsworks.common.dao.hdfsUser.HdfsUsers;
import io.hops.hopsworks.common.dao.hdfsUser.HdfsUsersFacade;
import io.hops.hopsworks.common.dao.project.Project;
import io.hops.hopsworks.common.dao.project.team.ProjectTeam;
import io.hops.hopsworks.common.dao.project.team.ProjectTeamFacade;
import io.hops.hopsworks.common.dao.user.UserFacade;
import io.hops.hopsworks.common.dao.user.Users;
import io.hops.hopsworks.common.dataset.DatasetController;
import io.hops.hopsworks.common.hdfs.DistributedFileSystemOps;
import io.hops.hopsworks.common.hdfs.DistributedFsService;
import io.hops.hopsworks.common.hdfs.Utils;
import io.hops.hopsworks.exceptions.DatasetException;
import io.hops.hopsworks.exceptions.ProjectException;
import io.hops.hopsworks.exceptions.UserException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;

@Stateless
public class HdfsUsersController {
    public static final String USER_NAME_DELIMITER = "__";
    @EJB
    private HdfsUsersFacade hdfsUsersFacade;
    @EJB
    private HdfsGroupsFacade hdfsGroupsFacade;
    @EJB
    private DistributedFsService dfsService;
    @EJB
    private InodeFacade inodes;
    @EJB
    private UserFacade userFacade;
    @EJB
    private DatasetFacade datasetFacade;
    @EJB
    private DatasetController datasetController;
    @EJB
    private ProjectTeamFacade projectTeamFacade;

    public void addProjectFolderOwner(Project project, DistributedFileSystemOps dfso) throws IOException {
        String owner = this.getHdfsUserName(project, project.getOwner());
        Path location = new Path(Utils.getProjectPath(project.getName()));
        FsPermission fsPermission = new FsPermission(FsAction.READ_EXECUTE, FsAction.READ_EXECUTE, FsAction.READ_EXECUTE);
        dfso.setOwner(location, owner, project.getName());
        dfso.setPermission(location, fsPermission);
        HdfsGroups projectGroup = this.hdfsGroupsFacade.findByName(project.getName());
        if (projectGroup == null) {
            throw new IllegalArgumentException("No group found for project in HDFS.");
        }
        this.addUserToGroup(dfso, owner, projectGroup);
    }

    public void addNewProjectMember(Project project, ProjectTeam member) throws UserException {
        try (DistributedFileSystemOps dfso = null;){
            dfso = this.dfsService.getDfsOps();
            this.addDataOwnerToProject(dfso, project, member, true);
        }
    }

    public void addUserToProjectGroup(Project project, ProjectTeam member) throws UserException {
        try (DistributedFileSystemOps dfso = null;){
            dfso = this.dfsService.getDfsOps();
            this.addDataOwnerToProject(dfso, project, member, false);
        }
    }

    public void addDatasetUsersGroups(Users owner, Project project, Dataset dataset, DistributedFileSystemOps dfso) throws IOException {
        if (owner == null || project == null || project.getProjectTeamCollection() == null || dataset == null) {
            throw new IllegalArgumentException("One or more arguments are null.");
        }
        String datasetGroup = this.getHdfsGroupName(project, dataset);
        String dsOwner = this.getHdfsUserName(project, owner);
        String dsPath = this.inodes.getPath(dataset.getInode());
        Path location = new Path(dsPath);
        dfso.setOwner(location, dsOwner, datasetGroup);
        HdfsGroups hdfsGroup = this.hdfsGroupsFacade.findByName(datasetGroup);
        if (hdfsGroup == null) {
            throw new IllegalArgumentException("Could not create dataset group in HDFS.");
        }
        Set projectUsers = project.getProjectTeamCollection().stream().map(ProjectTeam::getUser).collect(Collectors.toSet());
        projectUsers.add(owner);
        for (Users member : projectUsers) {
            String hdfsUsername = this.getHdfsUserName(project, member);
            this.addUserToGroup(dfso, hdfsUsername, hdfsGroup);
        }
    }

    public void removeProjectMember(Users user, Project project) throws ProjectException {
        if (user == null || project == null) {
            throw new IllegalArgumentException("One or more arguments are null.");
        }
        try (DistributedFileSystemOps dfso = null;){
            String userName = this.getHdfsUserName(project, user);
            this.dfsService.removeDfsOps(userName);
            dfso = this.dfsService.getDfsOps();
            dfso.removeUser(userName);
        }
    }

    public void modifyProjectMembership(Users user, Project project) throws ProjectException {
        if (user == null || project == null || project.getProjectTeamCollection() == null) {
            throw new IllegalArgumentException("One or more arguments are null.");
        }
        String userName = this.getHdfsUserName(project, user);
        HdfsGroups hdfsGroup = this.hdfsGroupsFacade.findByName(project.getName());
        HdfsUsers hdfsUser = this.hdfsUsersFacade.findByName(userName);
        if (hdfsUser == null || hdfsGroup == null) {
            throw new IllegalArgumentException("Hdfs user not found or not in project group.");
        }
        try (DistributedFileSystemOps dfso = null;){
            dfso = this.dfsService.getDfsOps();
            dfso.removeUserFromGroup(userName, hdfsGroup.getName());
        }
    }

    public void shareDataset(Project project, Dataset dataset) throws DatasetException {
        if (project == null || dataset == null) {
            throw new IllegalArgumentException("One or more arguments are null.");
        }
        String datasetGroup = this.getHdfsGroupName(dataset);
        HdfsGroups hdfsGroup = this.hdfsGroupsFacade.findByName(datasetGroup);
        if (hdfsGroup == null) {
            throw new IllegalArgumentException("Dataset group not found");
        }
        try (DistributedFileSystemOps dfso = null;){
            dfso = this.dfsService.getDfsOps();
            List<ProjectTeam> projectTeam = this.projectTeamFacade.findMembersByProject(project);
            for (ProjectTeam member : projectTeam) {
                String hdfsUsername = this.getHdfsUserName(project, member.getUser());
                this.addUserToGroup(dfso, hdfsUsername, hdfsGroup);
            }
        }
    }

    public void unshareDataset(Project project, Dataset dataset) throws DatasetException {
        if (project == null || dataset == null) {
            throw new IllegalArgumentException("One or more arguments are null.");
        }
        String datasetGroup = this.getHdfsGroupName(dataset);
        HdfsGroups hdfsGroup = this.hdfsGroupsFacade.findByName(datasetGroup);
        if (hdfsGroup == null) {
            throw new IllegalArgumentException("Dataset group not found");
        }
        try (DistributedFileSystemOps dfso = null;){
            dfso = this.dfsService.getDfsOps();
            this.removeUserFromGroup(dfso, project.getName(), hdfsGroup);
            List<ProjectTeam> projectTeam = this.projectTeamFacade.findMembersByProject(project);
            for (ProjectTeam member : projectTeam) {
                String hdfsUsername = this.getHdfsUserName(project, member.getUser());
                this.removeUserFromGroup(dfso, hdfsUsername, hdfsGroup);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteGroups(List<HdfsGroups> hdfsDsGroups) throws IOException {
        try (DistributedFileSystemOps dfso = null;){
            dfso = this.dfsService.getDfsOps();
            for (HdfsGroups hdfsDsGroup : hdfsDsGroups) {
                dfso.removeGroup(hdfsDsGroup.getName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteUsers(Collection<HdfsUsers> users) throws IOException {
        try (DistributedFileSystemOps dfso = null;){
            dfso = this.dfsService.getDfsOps();
            for (HdfsUsers user : users) {
                dfso.removeUser(user.getName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteDatasetGroup(Dataset dataset) throws IOException {
        if (dataset == null) {
            throw new IllegalArgumentException("One or more arguments are null.");
        }
        String datasetGroup = this.getHdfsGroupName(dataset);
        try (DistributedFileSystemOps dfso = null;){
            dfso = this.dfsService.getDfsOps();
            dfso.removeGroup(datasetGroup);
        }
    }

    public void unShareDataset(Project project, Dataset dataset) throws DatasetException {
        if (project == null || dataset == null) {
            throw new IllegalArgumentException("One or more arguments are null.");
        }
        String datasetGroup = this.getHdfsGroupName(dataset);
        HdfsGroups hdfsGroup = this.hdfsGroupsFacade.findByName(datasetGroup);
        if (hdfsGroup == null) {
            throw new IllegalArgumentException("Dataset group not found");
        }
        if (hdfsGroup.getHdfsUsersCollection() == null) {
            throw new IllegalArgumentException("The dataset group have no members.");
        }
        try (DistributedFileSystemOps dfso = null;){
            dfso = this.dfsService.getDfsOps();
            this.removeUserFromGroup(dfso, project.getName() + "__PROJECTGENERICUSER", hdfsGroup);
            List<ProjectTeam> projectTeam = this.projectTeamFacade.findMembersByProject(project);
            for (ProjectTeam member : projectTeam) {
                String hdfsUsername = this.getHdfsUserName(project, member.getUser());
                this.removeUserFromGroup(dfso, hdfsUsername, hdfsGroup);
            }
        }
    }

    public List<HdfsUsers> getAllProjectHdfsUsers(String projectName) {
        return this.hdfsUsersFacade.findProjectUsers(projectName);
    }

    public List<HdfsGroups> getAllProjectHdfsGroups(String projectName) {
        return this.hdfsGroupsFacade.findProjectGroups(projectName);
    }

    public List<HdfsGroups> listProjectGroups(Project project, List<Dataset> dsInProject) {
        if (project == null) {
            throw new IllegalArgumentException("One or more arguments are null.");
        }
        ArrayList<HdfsGroups> projectGroups = new ArrayList<HdfsGroups>();
        projectGroups.add(this.hdfsGroupsFacade.findByName(project.getName()));
        for (Dataset ds : dsInProject) {
            String dsGroups = this.getHdfsGroupName(project, ds);
            projectGroups.add(this.hdfsGroupsFacade.findByName(dsGroups));
        }
        return projectGroups;
    }

    public String getHdfsUserName(Project project, Users user) {
        if (project == null || user == null) {
            throw new IllegalArgumentException("project or user were not provided");
        }
        return project.getName() + USER_NAME_DELIMITER + user.getUsername();
    }

    public String getUserName(String hdfsUser) {
        return hdfsUser.split(USER_NAME_DELIMITER)[1];
    }

    public String getProjectName(String hdfsUser) {
        return hdfsUser.split(USER_NAME_DELIMITER)[0];
    }

    public String getHdfsGroupName(Project project, Dataset ds) {
        if (project == null || ds == null) {
            return null;
        }
        return project.getName() + USER_NAME_DELIMITER + ds.getInode().getInodePK().getName();
    }

    public String getHdfsGroupName(Project project, String dataSetName) {
        if (project == null || dataSetName == null) {
            return null;
        }
        return project.getName() + USER_NAME_DELIMITER + dataSetName;
    }

    public String getHdfsGroupName(Dataset dataset) {
        if (dataset == null) {
            return null;
        }
        Project owningProject = this.datasetController.getOwningProject(dataset);
        return owningProject.getName() + USER_NAME_DELIMITER + dataset.getInode().getInodePK().getName();
    }

    private void addDataOwnerToProject(DistributedFileSystemOps dfso, Project project, ProjectTeam member, boolean addToAllDatasetGroups) throws IOException {
        HdfsGroups hdfsGroup = this.hdfsGroupsFacade.findByName(project.getName());
        if (hdfsGroup == null) {
            throw new IllegalArgumentException("No group found for project in HDFS.");
        }
        Users newMember = this.userFacade.findByEmail(member.getProjectTeamPK().getTeamMember());
        String hdfsUsername = this.getHdfsUserName(project, newMember);
        HdfsUsers memberHdfsUser = this.hdfsUsersFacade.findByName(hdfsUsername);
        if (memberHdfsUser == null) {
            dfso.addUser(hdfsUsername);
            memberHdfsUser = this.hdfsUsersFacade.findByName(hdfsUsername);
        }
        if (member.getTeamRole().equals("Data owner") && !memberHdfsUser.inGroup(hdfsGroup)) {
            dfso.addUserToGroup(hdfsUsername, hdfsGroup.getName());
        }
        if (addToAllDatasetGroups) {
            List<Dataset> dsInProject = this.datasetFacade.findByProject(project);
            for (Dataset ds : dsInProject) {
                String dsGroups = this.getHdfsGroupName(ds);
                HdfsGroups hdfsDsGroup = this.hdfsGroupsFacade.findByName(dsGroups);
                if (hdfsDsGroup == null || memberHdfsUser.inGroup(hdfsDsGroup)) continue;
                dfso.addUserToGroup(hdfsUsername, dsGroups);
            }
        }
    }

    private void addUserToGroup(DistributedFileSystemOps dfso, String hdfsUserName, HdfsGroups hdfsGroup) throws IOException {
        HdfsUsers hdfsUser = this.hdfsUsersFacade.findByName(hdfsUserName);
        if (hdfsUser == null) {
            dfso.addUser(hdfsUserName);
            hdfsUser = this.hdfsUsersFacade.findByName(hdfsUserName);
        }
        if (!hdfsGroup.hasUser(hdfsUser)) {
            dfso.addUserToGroup(hdfsUserName, hdfsGroup.getName());
        }
    }

    private void removeUserFromGroup(DistributedFileSystemOps dfso, String hdfsUserName, HdfsGroups hdfsGroup) throws IOException {
        HdfsUsers hdfsUser = this.hdfsUsersFacade.findByName(hdfsUserName);
        if (hdfsGroup.hasUser(hdfsUser)) {
            dfso.removeUserFromGroup(hdfsUserName, hdfsGroup.getName());
        }
    }
}

