/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.hive;

import io.hops.hopsworks.common.dao.dataset.Dataset;
import io.hops.hopsworks.common.dao.dataset.DatasetFacade;
import io.hops.hopsworks.common.dao.dataset.DatasetType;
import io.hops.hopsworks.common.dao.featurestore.Featurestore;
import io.hops.hopsworks.common.dao.hdfs.inode.Inode;
import io.hops.hopsworks.common.dao.hdfs.inode.InodeFacade;
import io.hops.hopsworks.common.dao.hdfsUser.HdfsUsers;
import io.hops.hopsworks.common.dao.log.operation.OperationType;
import io.hops.hopsworks.common.dao.project.Project;
import io.hops.hopsworks.common.dao.project.ProjectFacade;
import io.hops.hopsworks.common.dao.user.Users;
import io.hops.hopsworks.common.dao.user.activity.ActivityFacade;
import io.hops.hopsworks.common.dao.user.activity.ActivityFlag;
import io.hops.hopsworks.common.dataset.DatasetController;
import io.hops.hopsworks.common.hdfs.DistributedFileSystemOps;
import io.hops.hopsworks.common.hdfs.HdfsUsersController;
import io.hops.hopsworks.common.security.BaseHadoopClientsService;
import io.hops.hopsworks.common.util.Settings;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;

@Stateless(name="HiveController")
public class HiveController {
    @EJB
    private Settings settings;
    @EJB
    private HdfsUsersController hdfsUsersBean;
    @EJB
    private InodeFacade inodeFacade;
    @EJB
    private DatasetFacade datasetFacade;
    @EJB
    private BaseHadoopClientsService bhcs;
    @EJB
    private ProjectFacade projectFacade;
    @EJB
    private DatasetController datasetController;
    @EJB
    private ActivityFacade activityFacade;
    private static final String driver = "org.apache.hive.jdbc.HiveDriver";
    private static final Logger logger = Logger.getLogger(HiveController.class.getName());
    private Connection conn;
    private String jdbcString = null;

    @PostConstruct
    public void init() {
        try {
            Class.forName(driver);
        }
        catch (ClassNotFoundException e) {
            logger.log(Level.SEVERE, "Could not load the Hive driver: org.apache.hive.jdbc.HiveDriver", e);
        }
    }

    private void initConnection() throws SQLException {
        String hiveEndpoint = this.settings.getHiveServerHostName(false);
        this.jdbcString = "jdbc:hive2://" + hiveEndpoint + "/default;auth=noSasl;ssl=true;twoWay=true;sslTrustStore=" + this.bhcs.getSuperTrustStorePath() + ";trustStorePassword=" + this.bhcs.getSuperTrustStorePassword() + ";sslKeyStore=" + this.bhcs.getSuperKeystorePath() + ";keyStorePassword=" + this.bhcs.getSuperKeystorePassword();
        this.conn = DriverManager.getConnection(this.jdbcString);
    }

    @PreDestroy
    public void close() {
        try {
            if (this.conn != null && !this.conn.isClosed()) {
                this.conn.close();
            }
        }
        catch (SQLException e) {
            logger.log(Level.WARNING, "Error closing Hive JDBC connection: " + e);
        }
    }

    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public void createDatasetDb(Project project, Users user, DistributedFileSystemOps dfso, String dbName) throws IOException {
        this.createDatasetDb(project, user, dfso, dbName, DatasetType.HIVEDB, null);
    }

    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public void createDatasetDb(Project project, Users user, DistributedFileSystemOps dfso, String dbName, DatasetType datasetType, Featurestore featurestore) throws IOException {
        if (datasetType != DatasetType.HIVEDB && datasetType != DatasetType.FEATURESTORE) {
            throw new IllegalArgumentException("Invalid dataset type for hive database");
        }
        Path dbPath = this.getDbPath(dbName);
        Inode dbInode = this.inodeFacade.getInodeAtPath(dbPath.toString());
        Dataset dbDataset = new Dataset(dbInode, project);
        dbDataset.setType(datasetType);
        dbDataset.setSearchable(true);
        dbDataset.setFeaturestore(featurestore);
        this.datasetFacade.persistDataset(dbDataset);
        dfso.setMetaEnabled(dbPath);
        this.datasetController.logDataset(dbDataset, OperationType.Add);
        this.activityFacade.persistActivity(" added a new dataset named " + dbDataset.getName(), project, user, ActivityFlag.DATASET);
        try {
            this.hdfsUsersBean.addDatasetUsersGroups(user, project, dbDataset, dfso);
            FsPermission fsPermission = new FsPermission(FsAction.ALL, FsAction.ALL, FsAction.NONE, true);
            dfso.setPermission(dbPath, fsPermission);
            switch (datasetType) {
                case HIVEDB: {
                    dfso.setHdfsSpaceQuotaInMBs(dbPath, this.settings.getHiveDbDefaultQuota());
                    break;
                }
                case FEATURESTORE: {
                    dfso.setHdfsSpaceQuotaInMBs(dbPath, this.settings.getFeaturestoreDbDefaultQuota());
                }
            }
            this.projectFacade.setTimestampQuotaUpdate(project, new Date());
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Cannot assign Hive database directory " + dbPath.toString() + " to correct user/group. Trace: " + e);
            try {
                dfso.rm(dbPath, true);
            }
            catch (IOException rmEx) {
                logger.log(Level.SEVERE, "Cannot delete Hive database directory: " + dbPath.toString() + " Trace: " + rmEx);
            }
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public void createDatabase(String dbName, String dbComment) throws SQLException {
        if (this.conn == null || this.conn.isClosed()) {
            this.initConnection();
        }
        try (Statement stmt = null;){
            stmt = this.conn.createStatement();
            stmt.executeUpdate("create database " + dbName + " COMMENT '" + dbComment + "'");
        }
    }

    public void dropDatabases(Project project, DistributedFileSystemOps dfso, boolean forceCleanup) throws IOException {
        Dataset projectDs = this.datasetController.getByProjectAndDsName(project, this.settings.getHiveWarehouse(), project.getName().toLowerCase() + ".db");
        Dataset featurestoreDs = this.datasetController.getByProjectAndDsName(project, this.settings.getHiveWarehouse(), project.getName().toLowerCase() + "_featurestore" + ".db");
        if (projectDs != null && projectDs.getType() == DatasetType.HIVEDB || forceCleanup) {
            this.dropDatabase(project, dfso, project.getName());
        }
        if (featurestoreDs != null && featurestoreDs.getType() == DatasetType.FEATURESTORE || forceCleanup) {
            this.dropDatabase(project, dfso, project.getName() + "_featurestore");
        }
    }

    private void dropDatabase(Project project, DistributedFileSystemOps dfso, String dbName) throws IOException {
        dfso.rm(this.getDbPath(dbName), true);
        for (HdfsUsers u : this.hdfsUsersBean.getAllProjectHdfsUsers(project.getName())) {
            dfso.rm(new Path(this.settings.getHiveScratchdir(), u.getName()), true);
        }
    }

    public Path getDbPath(String dbName) {
        return new Path(this.settings.getHiveWarehouse(), dbName.toLowerCase() + ".db");
    }
}

