/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.jobs.flink;

import io.hops.hopsworks.common.dao.hdfs.inode.Inode;
import io.hops.hopsworks.common.dao.hdfs.inode.InodeFacade;
import io.hops.hopsworks.common.hdfs.DistributedFileSystemOps;
import io.hops.hopsworks.common.hdfs.DistributedFsService;
import io.hops.hopsworks.common.jobs.flink.FlinkController;
import io.hops.hopsworks.common.util.Settings;
import java.io.File;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.ejb.Schedule;
import javax.ejb.Singleton;
import javax.ejb.Timer;
import org.apache.hadoop.fs.Path;

@Singleton
public class FlinkCleaner {
    private static final Logger LOGGER = Logger.getLogger(FlinkCleaner.class.getName());
    @EJB
    private FlinkController flinkController;
    @EJB
    private Settings settings;
    @EJB
    private InodeFacade inodeFacade;
    @EJB
    private DistributedFsService dfs;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Schedule(persistent=false, minute="0", hour="1")
    public void deleteOrphanJobs(Timer timer) {
        LOGGER.log(Level.INFO, "Running FlinkCleaner.");
        DistributedFileSystemOps dfso = null;
        try {
            String archiveDir = this.flinkController.getArchiveDir();
            dfso = this.dfs.getDfsOps();
            List<Inode> jobs = this.inodeFacade.getChildren(archiveDir);
            for (Inode job : jobs) {
                if (job.getHdfsUser() != null) continue;
                dfso.rm(new Path(archiveDir + File.separator + job.getInodePK().getName()), false);
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, "Could not access " + this.settings.getFlinkConfFile(), ex);
        }
        finally {
            if (dfso != null) {
                this.dfs.closeDfsClient(dfso);
            }
        }
    }
}

