/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.livy;

import io.hops.hopsworks.common.dao.jobhistory.YarnApplicationstate;
import io.hops.hopsworks.common.dao.jobhistory.YarnApplicationstateFacade;
import io.hops.hopsworks.common.dao.project.Project;
import io.hops.hopsworks.common.dao.project.ProjectFacade;
import io.hops.hopsworks.common.dao.project.team.ProjectTeam;
import io.hops.hopsworks.common.dao.project.team.ProjectTeamFacade;
import io.hops.hopsworks.common.dao.user.UserFacade;
import io.hops.hopsworks.common.dao.user.Users;
import io.hops.hopsworks.common.hdfs.HdfsUsersController;
import io.hops.hopsworks.common.livy.LivyMsg;
import io.hops.hopsworks.common.util.Settings;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;

@Stateless
public class LivyController {
    private static final Logger LOGGER = Logger.getLogger(LivyController.class.getName());
    @EJB
    private Settings settings;
    @EJB
    private ProjectTeamFacade teambean;
    @EJB
    private UserFacade userFacade;
    @EJB
    private ProjectFacade projectFacade;
    @EJB
    private HdfsUsersController hdfsUserBean;
    @EJB
    private HdfsUsersController hdfsUsersController;
    @EJB
    private YarnApplicationstateFacade appStateBean;

    public List<LivyMsg.Session> getLivySessions(Project project) {
        ArrayList<LivyMsg.Session> sessions = new ArrayList<LivyMsg.Session>();
        LivyMsg sessionList = this.getLivySessions();
        if (sessionList == null || sessionList.getSessions() == null || sessionList.getSessions().length == 0) {
            return sessions;
        }
        List<ProjectTeam> projectTeam = this.teambean.findMembersByProject(project);
        for (ProjectTeam member : projectTeam) {
            String hdfsUsername = this.hdfsUserBean.getHdfsUserName(project, member.getUser());
            for (LivyMsg.Session s : sessionList.getSessions()) {
                YarnApplicationstate appStates;
                if (!hdfsUsername.equals(s.getProxyUser()) || (appStates = this.appStateBean.findByAppId(s.getAppId())) == null) continue;
                s.setOwner(member.getUser().getEmail());
                sessions.add(s);
            }
        }
        return sessions;
    }

    public void deleteAllLivySessionsForProject(Project project) {
        List<ProjectTeam> projectTeam = this.teambean.findMembersByProject(project);
        for (ProjectTeam member : projectTeam) {
            String hdfsUsername = this.hdfsUserBean.getHdfsUserName(project, member.getUser());
            this.deleteAllLivySessions(hdfsUsername);
        }
    }

    public List<LivyMsg.Session> getLivySessionsForProjectUser(Project project, Users user) {
        ArrayList<LivyMsg.Session> sessions = new ArrayList<LivyMsg.Session>();
        LivyMsg sessionList = this.getLivySessions();
        if (sessionList == null || sessionList.getSessions() == null || sessionList.getSessions().length == 0) {
            return sessions;
        }
        String hdfsUsername = this.hdfsUserBean.getHdfsUserName(project, user);
        for (LivyMsg.Session s : sessionList.getSessions()) {
            YarnApplicationstate appStates;
            if (!hdfsUsername.equals(s.getProxyUser()) || (appStates = this.appStateBean.findByAppId(s.getAppId())) == null) continue;
            s.setOwner(user.getEmail());
            sessions.add(s);
        }
        return sessions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LivyMsg.Session getLivySession(int sessionId) {
        String livyUrl = this.settings.getLivyUrl();
        Client client = ClientBuilder.newClient();
        WebTarget target = client.target(livyUrl).path("/sessions/" + sessionId);
        LivyMsg.Session session = null;
        try {
            session = (LivyMsg.Session)target.request().get(LivyMsg.Session.class);
        }
        catch (NotFoundException e) {
            LOGGER.log(Level.WARNING, null, e);
            LivyMsg.Session session2 = null;
            return session2;
        }
        finally {
            client.close();
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LivyMsg getLivySessions() {
        String livyUrl = this.settings.getLivyUrl();
        Client client = ClientBuilder.newClient();
        WebTarget target = client.target(livyUrl).path("/sessions");
        LivyMsg livySession = null;
        try {
            livySession = (LivyMsg)target.request().get(LivyMsg.class);
        }
        finally {
            client.close();
        }
        return livySession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int deleteLivySession(int sessionId) {
        Response res;
        String livyUrl = this.settings.getLivyUrl();
        Client client = ClientBuilder.newClient();
        WebTarget target = client.target(livyUrl).path("/sessions/" + sessionId);
        try {
            res = target.request().delete();
        }
        catch (NotFoundException e) {
            int n = Response.Status.NOT_FOUND.getStatusCode();
            return n;
        }
        finally {
            client.close();
        }
        return res.getStatus();
    }

    public void deleteAllLivySessions(String hdfsUser) {
        String username = this.hdfsUsersController.getUserName(hdfsUser);
        String projectname = this.hdfsUsersController.getProjectName(hdfsUser);
        Users user = this.userFacade.findByUsername(username);
        Project project = this.projectFacade.findByName(projectname);
        List<LivyMsg.Session> sessions = this.getLivySessionsForProjectUser(project, user);
        for (LivyMsg.Session session : sessions) {
            this.deleteLivySession(session.getId());
        }
    }

    public boolean isLivySessionAlive(int sessionId) {
        LivyMsg.Session session = this.getLivySession(sessionId);
        return session != null;
    }
}

