/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.user;

import io.hops.hopsworks.common.dao.certificates.CertsFacade;
import io.hops.hopsworks.common.dao.certificates.UserCerts;
import io.hops.hopsworks.common.dao.project.Project;
import io.hops.hopsworks.common.dao.project.ProjectFacade;
import io.hops.hopsworks.common.dao.user.BbcGroup;
import io.hops.hopsworks.common.dao.user.BbcGroupFacade;
import io.hops.hopsworks.common.dao.user.UserFacade;
import io.hops.hopsworks.common.dao.user.Users;
import io.hops.hopsworks.common.dao.user.security.audit.AccountAuditFacade;
import io.hops.hopsworks.common.dao.user.security.audit.AccountsAuditActions;
import io.hops.hopsworks.common.dao.user.security.audit.RolesAuditAction;
import io.hops.hopsworks.common.dao.user.security.audit.UserAuditActions;
import io.hops.hopsworks.common.dao.user.security.ua.SecurityQuestion;
import io.hops.hopsworks.common.dao.user.security.ua.UserAccountStatus;
import io.hops.hopsworks.common.dao.user.security.ua.UserAccountType;
import io.hops.hopsworks.common.dao.user.security.ua.UserAccountsEmailMessages;
import io.hops.hopsworks.common.security.CertificatesMgmService;
import io.hops.hopsworks.common.security.utils.Secret;
import io.hops.hopsworks.common.security.utils.SecurityUtils;
import io.hops.hopsworks.common.user.UserStatusValidator;
import io.hops.hopsworks.common.user.ValidationKeyType;
import io.hops.hopsworks.common.util.EmailBean;
import io.hops.hopsworks.common.util.FormatUtils;
import io.hops.hopsworks.common.util.HopsUtils;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.exceptions.UserException;
import io.hops.hopsworks.restutils.RESTCodes;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.ejb.EJBException;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.servlet.http.HttpServletRequest;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class AuthController {
    private static final Logger LOGGER = Logger.getLogger(AuthController.class.getName());
    @EJB
    private UserFacade userFacade;
    @EJB
    private BbcGroupFacade bbcGroupFacade;
    @EJB
    private UserStatusValidator userStatusValidator;
    @EJB
    private Settings settings;
    @EJB
    private AccountAuditFacade accountAuditFacade;
    @EJB
    private EmailBean emailBean;
    @EJB
    private CertsFacade userCertsFacade;
    @EJB
    private ProjectFacade projectFacade;
    @EJB
    private CertificatesMgmService certificatesMgmService;
    @EJB
    private SecurityUtils securityUtils;

    private void validateUser(Users user) {
        if (user == null) {
            throw new IllegalArgumentException("User not set.");
        }
        if (!user.getMode().equals((Object)UserAccountType.M_ACCOUNT_TYPE)) {
            throw new IllegalArgumentException("Can not login user with account type: " + user.getMode().toString());
        }
    }

    public String preCustomRealmLoginCheck(Users user, String password, String otp, HttpServletRequest req) throws UserException {
        this.validateUser(user);
        if (this.isTwoFactorEnabled(user) && (otp == null || otp.isEmpty()) && user.getMode().equals((Object)UserAccountType.M_ACCOUNT_TYPE) && this.checkPasswordAndStatus(user, password, req)) {
            throw new IllegalStateException("Second factor required.");
        }
        if (otp == null || otp.isEmpty() && user.getMode().equals((Object)UserAccountType.M_ACCOUNT_TYPE)) {
            otp = "@@@@@@";
        }
        String newPassword = this.getPasswordPlusSalt(password, user.getSalt());
        if (otp.length() != "@@@@@@".length() || !user.getMode().equals((Object)UserAccountType.M_ACCOUNT_TYPE)) {
            throw new IllegalArgumentException("Could not recognize the account type. Report a bug.");
        }
        newPassword = newPassword + otp;
        return newPassword;
    }

    public boolean validatePassword(Users user, String password, HttpServletRequest req) {
        this.validateUser(user);
        String userPwdHash = user.getPassword();
        Secret secret = new Secret(password, user.getSalt());
        if (!userPwdHash.equals(secret.getSha256HexDigest())) {
            this.registerFalseLogin(user, req);
            LOGGER.log(Level.FINEST, "False login attempt by user: {0}", user.getEmail());
            return false;
        }
        this.resetFalseLogin(user);
        return true;
    }

    public boolean validateSecurityQA(Users user, String securityQ, String securityAnswer, HttpServletRequest req) {
        this.validateUser(user);
        if (securityQ == null || securityQ.isEmpty() || securityAnswer == null || securityAnswer.isEmpty()) {
            return false;
        }
        if (!user.getSecurityQuestion().getValue().equalsIgnoreCase(securityQ) || !user.getSecurityAnswer().equals(this.securityUtils.getHash(securityAnswer.toLowerCase()))) {
            this.registerFalseLogin(user, req);
            LOGGER.log(Level.FINEST, "False Security Question attempt by user: {0}", user.getEmail());
            return false;
        }
        return true;
    }

    public boolean checkPasswordAndStatus(Users user, String password, HttpServletRequest req) throws UserException {
        if (user == null) {
            throw new IllegalArgumentException("User not set.");
        }
        this.userStatusValidator.checkStatus(user.getStatus());
        return this.validatePassword(user, password, req);
    }

    public boolean checkUserPasswordAndStatus(Users user, String password, HttpServletRequest req) throws UserException {
        this.checkUserStatus(user, false);
        return this.validatePassword(user, password, req);
    }

    public boolean validateSecurityQAndStatus(Users user, String securityQ, String securityAnswer, HttpServletRequest req) throws UserException {
        this.checkUserStatus(user, false);
        return this.validateSecurityQA(user, securityQ, securityAnswer, req);
    }

    private Users getUserFromKey(String key) {
        if (key == null) {
            throw new IllegalArgumentException("Validation key not supplied.");
        }
        if (key.length() <= 8) {
            throw new IllegalArgumentException("Unrecognized validation key.");
        }
        String userName = key.substring(0, 8);
        return this.userFacade.findByUsername(userName);
    }

    private void validate(Users user, String key, HttpServletRequest req) throws UserException {
        String secret = key.substring(8);
        if (!secret.equals(user.getValidationKey())) {
            this.registerFalseKeyValidation(user, req);
            throw new UserException(RESTCodes.UserErrorCode.INCORRECT_VALIDATION_KEY, Level.FINE);
        }
        if (this.diffMillis(user.getValidationKeyUpdated()) < TimeUnit.SECONDS.toMillis(5L)) {
            this.resetValidationKey(user);
            throw new UserException(RESTCodes.UserErrorCode.INCORRECT_VALIDATION_KEY, Level.FINE);
        }
        this.resetFalseLogin(user);
    }

    public void validateEmail(String key, HttpServletRequest req) throws UserException {
        Users user = this.getUserFromKey(key);
        this.checkUserStatusAndKey(user, ValidationKeyType.EMAIL, true);
        this.validate(user, key, req);
        user.setStatus(UserAccountStatus.VERIFIED_ACCOUNT);
        user.setActivated(new Timestamp(new Date().getTime()));
        this.resetValidationKey(user);
        this.accountAuditFacade.registerRoleChange(user, UserAccountStatus.VERIFIED_ACCOUNT.name(), RolesAuditAction.SUCCESS.name(), "Account verification", user, req);
    }

    public void checkRecoveryKey(String key, HttpServletRequest req) throws UserException {
        Users user = this.getUserFromKey(key);
        this.checkUserStatusAndKey(user, ValidationKeyType.PASSWORD, false);
        this.validate(user, key, req);
        user.setValidationKeyType(ValidationKeyType.PASSWORD_RESET);
        this.userFacade.update(user);
    }

    public Users validateRecoveryKey(String key, ValidationKeyType type, HttpServletRequest req) throws UserException {
        Users user = this.getUserFromKey(key);
        this.checkUserStatusAndKey(user, type, false);
        this.validate(user, key, req);
        return user;
    }

    public void resetValidationKey(Users user) {
        user.setValidationKey(null);
        user.setValidationKeyUpdated(null);
        user.setValidationKeyType(null);
        this.userFacade.update(user);
    }

    public void setValidationKey(Users user, String resetToken, ValidationKeyType type) {
        user.setValidationKey(resetToken);
        user.setValidationKeyUpdated(new Timestamp(new Date().getTime()));
        user.setValidationKeyType(type);
        this.userFacade.update(user);
    }

    private void checkUserStatusAndKey(Users user, ValidationKeyType type, boolean newUser) throws UserException {
        this.checkUserStatus(user, newUser);
        if (user.getValidationKeyType() == null || !type.equals((Object)user.getValidationKeyType())) {
            throw new UserException(RESTCodes.UserErrorCode.INCORRECT_VALIDATION_KEY, Level.FINE);
        }
    }

    private void checkUserStatus(Users user, boolean newUser) throws UserException {
        if (user == null) {
            throw new UserException(RESTCodes.UserErrorCode.USER_WAS_NOT_FOUND, Level.FINE);
        }
        if (newUser) {
            this.userStatusValidator.checkNewUserStatus(user.getStatus());
        } else {
            try {
                this.userStatusValidator.checkStatus(user.getStatus());
            }
            catch (UserException e) {
                throw new UserException(RESTCodes.UserErrorCode.ACCOUNT_NOT_ACTIVE, Level.FINE, e.getErrorCode().getMessage());
            }
        }
    }

    public void sendNewRecoveryValidationKey(Users user, String url, boolean isPassword, HttpServletRequest req) throws MessagingException, UserException {
        String resetToken;
        if (user == null) {
            throw new IllegalArgumentException("User not set.");
        }
        if (UserAccountType.REMOTE_ACCOUNT_TYPE.equals((Object)user.getMode())) {
            throw new UserException(RESTCodes.UserErrorCode.USER_WAS_NOT_FOUND, Level.FINE);
        }
        long validForHour = TimeUnit.HOURS.toMillis(24L);
        if (user.getValidationKey() != null && user.getValidationKeyType().equals((Object)(isPassword ? ValidationKeyType.PASSWORD : ValidationKeyType.QR_RESET)) && this.diffMillis(user.getValidationKeyUpdated()) > TimeUnit.MINUTES.toMillis(5L)) {
            resetToken = user.getValidationKey();
            validForHour = this.diffMillis(user.getValidationKeyUpdated());
        } else {
            resetToken = this.securityUtils.generateSecureRandomString();
            this.setValidationKey(user, resetToken, isPassword ? ValidationKeyType.PASSWORD : ValidationKeyType.QR_RESET);
        }
        this.sendRecoveryValidationKey(user, url, this.securityUtils.urlEncode(resetToken), isPassword, validForHour, req);
    }

    private long diffMillis(Date date) {
        if (date == null) {
            return -1L;
        }
        Date now = new Date();
        long validForMs = TimeUnit.HOURS.toMillis(24L);
        long diff = now.getTime() - date.getTime();
        long diffMs = validForMs - diff;
        return diffMs;
    }

    private void sendRecoveryValidationKey(Users user, String url, String resetToken, boolean isPassword, long validFor, HttpServletRequest req) throws MessagingException {
        String subject = "You have requested to recover a lost device";
        String msg = UserAccountsEmailMessages.buildQRRecoveryMessage(url, user.getUsername() + resetToken, validFor);
        if (isPassword) {
            subject = "You have requested to recover your password";
            msg = UserAccountsEmailMessages.buildPasswordRecoveryMessage(url, user.getUsername() + resetToken, validFor);
        }
        this.emailBean.sendEmail(user.getEmail(), Message.RecipientType.TO, subject, msg);
        this.accountAuditFacade.registerAccountChange(user, AccountsAuditActions.RECOVERY.name(), AccountsAuditActions.SUCCESS.name(), "New " + (isPassword ? "password " : "QR ") + "recovery key", user, req);
    }

    public void sendNewValidationKey(Users user, HttpServletRequest req) throws MessagingException {
        if (user == null) {
            throw new IllegalArgumentException("User not set.");
        }
        String activationKey = this.securityUtils.generateSecureRandomString();
        this.sendEmailValidationKey(user, activationKey, req);
        this.accountAuditFacade.registerAccountChange(user, AccountsAuditActions.REGISTRATION.name(), AccountsAuditActions.SUCCESS.name(), "New validation key", user, req);
        this.accountAuditFacade.registerAccountChange(user, AccountsAuditActions.QRCODE.name(), AccountsAuditActions.SUCCESS.name(), "", user, req);
        this.setValidationKey(user, activationKey, ValidationKeyType.EMAIL);
    }

    public void sendEmailValidationKey(Users user, String activationKey, HttpServletRequest req) throws MessagingException {
        long validForHour = this.diffMillis(user.getValidationKeyUpdated());
        String path = FormatUtils.getUserURL(req) + this.settings.getEmailVerificationEndpoint();
        String subject = "Your Hopsworks account needs verification";
        String msg = UserAccountsEmailMessages.buildMobileRequestMessageRest(path, user.getUsername() + this.securityUtils.urlEncode(activationKey), validForHour);
        this.emailBean.sendEmail(user.getEmail(), Message.RecipientType.TO, subject, msg);
    }

    public boolean isTwoFactorEnabled(Users user) {
        String[] groups;
        String twoFactorAuth = this.settings.getTwoFactorAuth();
        String twoFactorExclude = this.settings.getTwoFactorExclude();
        String twoFactorMode = twoFactorAuth != null ? twoFactorAuth : "";
        String excludes = twoFactorExclude != null ? twoFactorExclude : null;
        for (String group : groups = excludes != null && !excludes.isEmpty() ? excludes.split(";") : new String[]{}) {
            if (!this.isUserInRole(user, group)) continue;
            return false;
        }
        if (twoFactorMode.equals(Settings.TwoFactorMode.MANDATORY.getName())) {
            return true;
        }
        return twoFactorMode.equals(Settings.TwoFactorMode.OPTIONAL.getName()) && user.getTwoFactor();
    }

    public boolean isTwoFactorEnabled() {
        String twoFactorAuth = this.settings.getTwoFactorAuth();
        String twoFactorMode = twoFactorAuth != null ? twoFactorAuth : "";
        return twoFactorMode.equals(Settings.TwoFactorMode.MANDATORY.getName()) || twoFactorMode.equals(Settings.TwoFactorMode.OPTIONAL.getName());
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    public void changePassword(Users user, Secret secret, HttpServletRequest req) {
        String oldPassword = user.getPassword();
        user.setPassword(secret.getSha256HexDigest());
        user.setSalt(secret.getSalt());
        user.setPasswordChanged(new Timestamp(new Date().getTime()));
        this.userFacade.update(user);
        this.resetProjectCertPassword(user, oldPassword);
        this.accountAuditFacade.registerAccountChange(user, AccountsAuditActions.PASSWORDCHANGE.name(), AccountsAuditActions.SUCCESS.name(), "Changed password.", user, req);
    }

    public void changeSecQA(Users user, String securityQuestion, String securityAnswer, HttpServletRequest req) {
        user.setSecurityQuestion(SecurityQuestion.getQuestion(securityQuestion));
        user.setSecurityAnswer(this.securityUtils.getHash(securityAnswer.toLowerCase()));
        this.userFacade.update(user);
        this.accountAuditFacade.registerAccountChange(user, AccountsAuditActions.SECQUESTION.name(), AccountsAuditActions.SUCCESS.name(), "Changed Security Question.", user, req);
    }

    public String getPasswordPlusSalt(String password, String salt) {
        return password + salt;
    }

    private void resetProjectCertPassword(Users p, String oldPass) {
        List<Project> projects = this.projectFacade.findAllMemberStudies(p);
        try {
            for (Project project : projects) {
                UserCerts userCert = this.userCertsFacade.findUserCert(project.getName(), p.getUsername());
                String masterEncryptionPassword = this.certificatesMgmService.getMasterEncryptionPassword();
                String certPassword = HopsUtils.decrypt(oldPass, userCert.getUserKeyPwd(), masterEncryptionPassword);
                String newSecret = HopsUtils.encrypt(p.getPassword(), certPassword, masterEncryptionPassword);
                userCert.setUserKeyPwd(newSecret);
                this.userCertsFacade.update(userCert);
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, null, ex);
            throw new EJBException(ex);
        }
    }

    public void registerFalseLogin(Users user, HttpServletRequest req) {
        if (user != null) {
            int allowedFalseLogins;
            int count = user.getFalseLogin() + 1;
            user.setFalseLogin(count);
            int n = allowedFalseLogins = this.isUserAgent(user) ? 20 : 5;
            if (count > allowedFalseLogins) {
                user.setStatus(UserAccountStatus.BLOCKED_ACCOUNT);
                try {
                    this.emailBean.sendEmail(user.getEmail(), Message.RecipientType.TO, "Your account is locked", UserAccountsEmailMessages.accountBlockedMessage());
                }
                catch (MessagingException ex) {
                    LOGGER.log(Level.SEVERE, "Failed to send email. ", ex);
                }
                this.accountAuditFacade.registerRoleChange(user, UserAccountStatus.SPAM_ACCOUNT.name(), RolesAuditAction.SUCCESS.name(), "False login retries:" + Integer.toString(count), user, req);
            }
            this.userFacade.update(user);
        }
    }

    private boolean isUserAgent(Users user) {
        return this.isUserInRole(user, "AGENT");
    }

    public void registerFalseKeyValidation(Users user, HttpServletRequest req) {
        if (user != null) {
            int count = user.getFalseLogin() + 1;
            user.setFalseLogin(count);
            if (count > 5) {
                user.setStatus(UserAccountStatus.SPAM_ACCOUNT);
            }
            this.userFacade.update(user);
            this.accountAuditFacade.registerRoleChange(user, UserAccountStatus.SPAM_ACCOUNT.name(), RolesAuditAction.SUCCESS.name(), "Wrong validation key retries: " + Integer.toString(count), user, req);
        }
    }

    public void registerLogin(Users user, HttpServletRequest req) {
        this.resetFalseLogin(user);
        this.setUserOnlineStatus(user, 1);
        this.accountAuditFacade.registerLoginInfo(user, UserAuditActions.LOGIN.name(), UserAuditActions.SUCCESS.name(), req);
        LOGGER.log(Level.FINEST, "Logged in user: {0}. ", user.getEmail());
    }

    public void registerLogout(Users user, HttpServletRequest req) {
        this.setUserOnlineStatus(user, 0);
        this.accountAuditFacade.registerLoginInfo(user, UserAuditActions.LOGOUT.name(), UserAuditActions.SUCCESS.name(), req);
        LOGGER.log(Level.FINEST, "Logged out user: {0}. ", user.getEmail());
    }

    public void registerAuthenticationFailure(Users user, HttpServletRequest req) {
        this.registerFalseLogin(user, req);
        this.accountAuditFacade.registerLoginInfo(user, UserAuditActions.LOGIN.name(), UserAuditActions.FAILED.name(), req);
        LOGGER.log(Level.FINEST, "Authentication failure user: {0}. ", user.getEmail());
    }

    public void resetFalseLogin(Users user) {
        if (user != null) {
            user.setFalseLogin(0);
            this.userFacade.update(user);
        }
    }

    private void setUserOnlineStatus(Users user, int status) {
        if (user != null) {
            user.setIsonline(status);
            this.userFacade.update(user);
        }
    }

    private boolean isUserInRole(Users user, String groupName) {
        if (user == null || groupName == null) {
            return false;
        }
        BbcGroup group = this.bbcGroupFacade.findByGroupName(groupName);
        if (group == null) {
            return false;
        }
        return user.getBbcGroupCollection().contains(group);
    }
}

