/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.user;

import com.google.zxing.WriterException;
import io.hops.hopsworks.common.dao.user.BbcGroup;
import io.hops.hopsworks.common.dao.user.BbcGroupFacade;
import io.hops.hopsworks.common.dao.user.UserDTO;
import io.hops.hopsworks.common.dao.user.UserFacade;
import io.hops.hopsworks.common.dao.user.Users;
import io.hops.hopsworks.common.dao.user.security.Address;
import io.hops.hopsworks.common.dao.user.security.Organization;
import io.hops.hopsworks.common.dao.user.security.audit.AccountAudit;
import io.hops.hopsworks.common.dao.user.security.audit.AccountAuditFacade;
import io.hops.hopsworks.common.dao.user.security.audit.AccountsAuditActions;
import io.hops.hopsworks.common.dao.user.security.audit.RolesAudit;
import io.hops.hopsworks.common.dao.user.security.audit.RolesAuditAction;
import io.hops.hopsworks.common.dao.user.security.audit.RolesAuditFacade;
import io.hops.hopsworks.common.dao.user.security.audit.UserAuditActions;
import io.hops.hopsworks.common.dao.user.security.ua.SecurityQuestion;
import io.hops.hopsworks.common.dao.user.security.ua.UserAccountStatus;
import io.hops.hopsworks.common.dao.user.security.ua.UserAccountType;
import io.hops.hopsworks.common.dao.user.security.ua.UserAccountsEmailMessages;
import io.hops.hopsworks.common.dao.user.sshkey.SshKeyDTO;
import io.hops.hopsworks.common.dao.user.sshkey.SshKeys;
import io.hops.hopsworks.common.dao.user.sshkey.SshKeysPK;
import io.hops.hopsworks.common.dao.user.sshkey.SshkeysFacade;
import io.hops.hopsworks.common.security.utils.Secret;
import io.hops.hopsworks.common.security.utils.SecurityUtils;
import io.hops.hopsworks.common.user.AuthController;
import io.hops.hopsworks.common.user.UserValidator;
import io.hops.hopsworks.common.user.ValidationKeyType;
import io.hops.hopsworks.common.util.EmailBean;
import io.hops.hopsworks.common.util.FormatUtils;
import io.hops.hopsworks.common.util.QRCodeGenerator;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.exceptions.UserException;
import io.hops.hopsworks.restutils.RESTCodes;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class UsersController {
    private static final Logger LOGGER = Logger.getLogger(UsersController.class.getName());
    @EJB
    private UserFacade userFacade;
    @EJB
    private AccountAuditFacade accountAuditFacade;
    @EJB
    private RolesAuditFacade rolesAuditFacade;
    @EJB
    private BbcGroupFacade bbcGroupFacade;
    @EJB
    private SshkeysFacade sshKeysBean;
    @EJB
    private UserValidator userValidator;
    @EJB
    private EmailBean emailBean;
    @EJB
    private Settings settings;
    @EJB
    private AuthController authController;
    @EJB
    private AccountAuditFacade auditManager;
    @EJB
    private SecurityUtils securityUtils;
    private byte[] qrCode;

    public byte[] registerUser(UserDTO newUser, HttpServletRequest req) throws UserException {
        this.userValidator.isValidNewUser(newUser);
        Users user = this.createNewUser(newUser, UserAccountStatus.NEW_MOBILE_ACCOUNT, UserAccountType.M_ACCOUNT_TYPE);
        this.addAddress(user);
        this.addOrg(user);
        try {
            if (!newUser.isTestUser()) {
                this.authController.sendEmailValidationKey(user, user.getValidationKey(), req);
            }
            this.userFacade.persist(user);
            this.qrCode = QRCodeGenerator.getQRCodeBytes(newUser.getEmail(), "hops.io", user.getSecret());
            this.accountAuditFacade.registerAccountChange(user, AccountsAuditActions.REGISTRATION.name(), AccountsAuditActions.SUCCESS.name(), "New validation key", user, req);
            this.accountAuditFacade.registerAccountChange(user, AccountsAuditActions.QRCODE.name(), AccountsAuditActions.SUCCESS.name(), "", user, req);
        }
        catch (WriterException | IOException | MessagingException ex) {
            this.accountAuditFacade.registerAccountChange(user, AccountsAuditActions.REGISTRATION.name(), AccountsAuditActions.FAILED.name(), "", user, req);
            this.accountAuditFacade.registerAccountChange(user, AccountsAuditActions.QRCODE.name(), AccountsAuditActions.FAILED.name(), "", user, req);
            throw new UserException(RESTCodes.UserErrorCode.ACCOUNT_REGISTRATION_ERROR, Level.SEVERE, "user: " + newUser.getUsername(), ex.getMessage(), ex);
        }
        return this.qrCode;
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public String activateUser(String role, Users user1, Users loggedInUser, HttpServletRequest httpServletRequest) {
        BbcGroup bbcGroup = this.bbcGroupFacade.findByGroupName(role);
        if (bbcGroup == null) {
            this.auditManager.registerAccountChange(loggedInUser, UserAccountStatus.ACTIVATED_ACCOUNT.name(), RolesAuditAction.FAILED.name(), "Role could not be granted.", user1, httpServletRequest);
            return "Role could not be granted.";
        }
        this.registerGroup(user1, bbcGroup.getGid());
        this.auditManager.registerRoleChange(loggedInUser, RolesAuditAction.ROLE_ADDED.name(), RolesAuditAction.SUCCESS.name(), bbcGroup.getGroupName(), user1, httpServletRequest);
        try {
            this.updateStatus(user1, UserAccountStatus.ACTIVATED_ACCOUNT);
            this.auditManager.registerAccountChange(loggedInUser, UserAccountStatus.ACTIVATED_ACCOUNT.name(), UserAuditActions.SUCCESS.name(), "", user1, httpServletRequest);
        }
        catch (IllegalArgumentException ex) {
            this.auditManager.registerAccountChange(loggedInUser, UserAccountStatus.ACTIVATED_ACCOUNT.name(), RolesAuditAction.FAILED.name(), "User could not be activated.", user1, httpServletRequest);
            return "User could not be activated.";
        }
        return null;
    }

    public Users createNewUser(UserDTO newUser, UserAccountStatus accountStatus, UserAccountType accountType) {
        String otpSecret = this.securityUtils.calculateSecretKey();
        String activationKey = this.securityUtils.generateSecureRandomString();
        String uname = this.generateUsername(newUser.getEmail());
        ArrayList<BbcGroup> groups = new ArrayList<BbcGroup>();
        Secret secret = this.securityUtils.generateSecret(newUser.getChosenPassword());
        Timestamp now = new Timestamp(new Date().getTime());
        SecurityQuestion secQuestion = SecurityQuestion.getQuestion(newUser.getSecurityQuestion());
        String secAnswer = this.securityUtils.getHash(newUser.getSecurityAnswer().toLowerCase());
        Users user = new Users(uname, secret.getSha256HexDigest(), newUser.getEmail(), newUser.getFirstName(), newUser.getLastName(), now, "-", "-", accountStatus, otpSecret, activationKey, now, ValidationKeyType.EMAIL, secQuestion, secAnswer, accountType, now, newUser.getTelephoneNum(), this.settings.getMaxNumProjPerUser(), newUser.isTwoFactor(), secret.getSalt(), newUser.getToursState());
        user.setBbcGroupCollection(groups);
        return user;
    }

    public Users createNewAgent(String email, String fname, String lname, String pwd, String title) {
        String uname = this.generateUsername(email);
        ArrayList<BbcGroup> groups = new ArrayList<BbcGroup>();
        Secret secret = this.securityUtils.generateSecret(pwd);
        Users user = new Users(uname, secret.getSha256HexDigest(), email, fname, lname, new Timestamp(new Date().getTime()), title, "-", UserAccountStatus.NEW_MOBILE_ACCOUNT, UserAccountType.M_ACCOUNT_TYPE, new Timestamp(new Date().getTime()), 0, secret.getSalt());
        user.setBbcGroupCollection(groups);
        return user;
    }

    public Users createNewRemoteUser(String email, String fname, String lname, String pwd, UserAccountStatus accStatus) {
        String uname = this.generateUsername(email);
        ArrayList<BbcGroup> groups = new ArrayList<BbcGroup>();
        Secret secret = this.securityUtils.generateSecret(pwd);
        Users user = new Users(uname, secret.getSha256HexDigest(), email, fname, lname, new Timestamp(new Date().getTime()), "-", "-", accStatus, UserAccountType.REMOTE_ACCOUNT_TYPE, new Timestamp(new Date().getTime()), this.settings.getMaxNumProjPerUser(), secret.getSalt());
        user.setBbcGroupCollection(groups);
        this.addAddress(user);
        this.addOrg(user);
        return user;
    }

    public void addAddress(Users user) {
        Address a = new Address();
        a.setUid(user);
        a.setAddress1("-");
        a.setAddress2("-");
        a.setAddress3("-");
        a.setCity("Stockholm");
        a.setCountry("SE");
        a.setPostalcode("-");
        a.setState("-");
        user.setAddress(a);
    }

    public void addOrg(Users user) {
        Organization org = new Organization();
        org.setUid(user);
        org.setContactEmail("-");
        org.setContactPerson("-");
        org.setDepartment("-");
        org.setFax("-");
        org.setOrgName("-");
        org.setWebsite("-");
        org.setPhone("-");
        user.setOrganization(org);
    }

    public void sendQRRecoveryEmail(String email, String password, HttpServletRequest req) throws UserException, MessagingException {
        Users user = this.userFacade.findByEmail(email);
        String path = FormatUtils.getUserURL(req);
        if (!this.authController.checkUserPasswordAndStatus(user, password, req)) {
            throw new UserException(RESTCodes.UserErrorCode.INCORRECT_CREDENTIALS, Level.FINE);
        }
        if (!user.getTwoFactor()) {
            throw new UserException(RESTCodes.UserErrorCode.TWO_FA_DISABLED, Level.FINE);
        }
        this.authController.sendNewRecoveryValidationKey(user, path, false, req);
    }

    public void sendPasswordRecoveryEmail(String email, String securityQuestion, String securityAnswer, HttpServletRequest req) throws UserException, MessagingException {
        Users user = this.userFacade.findByEmail(email);
        String path = FormatUtils.getUserURL(req);
        if (!this.authController.validateSecurityQAndStatus(user, securityQuestion, securityAnswer, req)) {
            throw new UserException(RESTCodes.UserErrorCode.SEC_QA_INCORRECT, Level.FINE);
        }
        this.authController.sendNewRecoveryValidationKey(user, path, true, req);
    }

    public String recoverQRCode(String key, HttpServletRequest req) throws UserException, MessagingException {
        return new String(this.recoverQRCodeByte(key, req));
    }

    public byte[] recoverQRCodeByte(String key, HttpServletRequest req) throws UserException, MessagingException {
        Users user = this.authController.validateRecoveryKey(key, ValidationKeyType.QR_RESET, req);
        byte[] qrCode = this.recoverQRCode(user, req);
        if (qrCode == null) {
            throw new UserException(RESTCodes.UserErrorCode.TWO_FA_DISABLED, Level.FINE);
        }
        this.authController.resetValidationKey(user);
        String subject = "Your QR code has been reset";
        String msg = UserAccountsEmailMessages.buildQRResetMessage();
        this.emailBean.sendEmail(user.getEmail(), Message.RecipientType.TO, subject, msg);
        return Base64.encodeBase64((byte[])qrCode);
    }

    private byte[] recoverQRCode(Users user, HttpServletRequest req) {
        String random = this.securityUtils.calculateSecretKey();
        this.updateSecret(user, random);
        this.auditManager.registerAccountChange(user, AccountsAuditActions.RECOVERY.name(), AccountsAuditActions.SUCCESS.name(), "Reset QR code.", user, req);
        return this.getQrCode(user);
    }

    public void changePassword(Users user, String oldPassword, String newPassword, String confirmedPassword, HttpServletRequest req) throws UserException {
        if (!this.authController.validatePassword(user, oldPassword, req)) {
            throw new UserException(RESTCodes.UserErrorCode.PASSWORD_INCORRECT, Level.FINE);
        }
        this.changePassword(user, newPassword, confirmedPassword, req);
    }

    public void checkRecoveryKey(String key, HttpServletRequest req) throws UserException {
        this.authController.checkRecoveryKey(key, req);
    }

    public void validateKey(String key, HttpServletRequest req) throws UserException {
        this.authController.validateEmail(key, req);
    }

    public void changePassword(String key, String newPassword, String confirmedPassword, HttpServletRequest req) throws UserException, MessagingException {
        this.userValidator.isValidPassword(newPassword, confirmedPassword);
        Users user = this.authController.validateRecoveryKey(key, ValidationKeyType.PASSWORD_RESET, req);
        this.changePassword(user, newPassword, confirmedPassword, req);
        this.authController.resetValidationKey(user);
        String subject = "Your password has been reset";
        String msg = UserAccountsEmailMessages.buildResetMessage();
        this.emailBean.sendEmail(user.getEmail(), Message.RecipientType.TO, subject, msg);
    }

    private void changePassword(Users user, String newPassword, String confirmedPassword, HttpServletRequest req) throws UserException {
        if (this.userValidator.isValidPassword(newPassword, confirmedPassword)) {
            try {
                Secret secret = this.securityUtils.generateSecret(newPassword);
                this.authController.changePassword(user, secret, req);
            }
            catch (Exception ex) {
                throw new UserException(RESTCodes.UserErrorCode.PASSWORD_RESET_UNSUCCESSFUL, Level.SEVERE, null, ex.getMessage(), (Throwable)ex);
            }
        }
    }

    public void changeSecQA(Users user, String oldPassword, String securityQuestion, String securityAnswer, HttpServletRequest req) throws UserException {
        if (!this.authController.validatePassword(user, oldPassword, req)) {
            throw new UserException(RESTCodes.UserErrorCode.PASSWORD_INCORRECT, Level.FINE);
        }
        if (this.userValidator.isValidsecurityQA(securityQuestion, securityAnswer)) {
            this.authController.changeSecQA(user, securityQuestion, securityAnswer, req);
        }
    }

    public Users updateProfile(Users user, String firstName, String lastName, String telephoneNum, Integer toursState, HttpServletRequest req) throws UserException {
        if (user == null) {
            throw new UserException(RESTCodes.UserErrorCode.USER_WAS_NOT_FOUND, Level.FINE);
        }
        if (firstName != null) {
            user.setFname(firstName);
        }
        if (lastName != null) {
            user.setLname(lastName);
        }
        if (telephoneNum != null) {
            user.setMobile(telephoneNum);
        }
        if (toursState != null) {
            user.setToursState(toursState);
        }
        this.accountAuditFacade.registerAccountChange(user, AccountsAuditActions.PROFILE.name(), AccountsAuditActions.SUCCESS.name(), "Update Profile Info", user, req);
        this.userFacade.update(user);
        return user;
    }

    public SshKeyDTO addSshKey(int id, String name, String sshKey) {
        SshKeys key = new SshKeys();
        key.setSshKeysPK(new SshKeysPK(id, name));
        key.setPublicKey(sshKey);
        this.sshKeysBean.persist(key);
        return new SshKeyDTO(key);
    }

    public void removeSshKey(int id, String name) {
        this.sshKeysBean.removeByIdName(id, name);
    }

    public List<SshKeyDTO> getSshKeys(int id) {
        List<SshKeys> keys = this.sshKeysBean.findAllById(id);
        ArrayList<SshKeyDTO> dtos = new ArrayList<SshKeyDTO>();
        for (SshKeys sshKey : keys) {
            dtos.add(new SshKeyDTO(sshKey));
        }
        return dtos;
    }

    public String generateUsername(String email) {
        int count;
        if (email == null) {
            throw new IllegalArgumentException("Email is null");
        }
        String emailUsername = email.substring(0, email.lastIndexOf("@")).toLowerCase();
        String baseUsername = emailUsername.replaceAll("[^a-z0-9]", "");
        baseUsername = baseUsername.length() <= 8 ? baseUsername + StringUtils.repeat((String)"0", (int)(8 - baseUsername.length())) : baseUsername.substring(0, 8);
        Users user = this.userFacade.findByUsername(baseUsername);
        if (user == null) {
            return baseUsername;
        }
        String testUname = "";
        String suffix = "";
        for (count = 1; user != null && count < 1000; ++count) {
            suffix = String.valueOf(count);
            testUname = baseUsername.substring(0, 8 - suffix.length());
            user = this.userFacade.findByUsername(testUname + suffix);
        }
        if (count == 1000) {
            throw new IllegalStateException("You cannot register with this email address. Pick another.");
        }
        return testUname + suffix;
    }

    public byte[] changeTwoFactor(Users user, String password, HttpServletRequest req) throws UserException {
        if (user == null) {
            throw new IllegalArgumentException("User was not provided.");
        }
        if (!this.authController.validatePassword(user, password, req)) {
            this.accountAuditFacade.registerAccountChange(user, AccountsAuditActions.TWO_FACTOR.name(), AccountsAuditActions.FAILED.name(), "Incorrect password", user, req);
            throw new UserException(RESTCodes.UserErrorCode.PASSWORD_INCORRECT, Level.FINE);
        }
        byte[] qr_code = null;
        if (user.getTwoFactor()) {
            user.setTwoFactor(false);
            this.userFacade.update(user);
            this.accountAuditFacade.registerAccountChange(user, AccountsAuditActions.TWO_FACTOR.name(), AccountsAuditActions.SUCCESS.name(), "Disabled 2-factor", user, req);
        } else {
            try {
                user.setTwoFactor(true);
                this.userFacade.update(user);
                qr_code = QRCodeGenerator.getQRCodeBytes(user.getEmail(), "hops.io", user.getSecret());
                this.accountAuditFacade.registerAccountChange(user, AccountsAuditActions.TWO_FACTOR.name(), AccountsAuditActions.SUCCESS.name(), "Enabled 2-factor", user, req);
                this.accountAuditFacade.registerAccountChange(user, AccountsAuditActions.QRCODE.name(), AccountsAuditActions.SUCCESS.name(), "Enabled 2-factor", user, req);
            }
            catch (WriterException | IOException ex) {
                LOGGER.log(Level.SEVERE, null, ex);
                this.accountAuditFacade.registerAccountChange(user, AccountsAuditActions.TWO_FACTOR.name(), AccountsAuditActions.FAILED.name(), "Enabled 2-factor", user, req);
                this.accountAuditFacade.registerAccountChange(user, AccountsAuditActions.QRCODE.name(), AccountsAuditActions.FAILED.name(), "Enabled 2-factor", user, req);
                throw new UserException(RESTCodes.UserErrorCode.TWO_FA_ENABLE_ERROR, Level.SEVERE, "user: " + user.getUsername(), ex.getMessage(), ex);
            }
        }
        return qr_code;
    }

    public byte[] getQRCode(Users user, String password, HttpServletRequest req) throws UserException {
        if (user == null) {
            throw new IllegalArgumentException("User was not provided");
        }
        if (!this.authController.validatePassword(user, password, req)) {
            throw new UserException(RESTCodes.UserErrorCode.PASSWORD_INCORRECT, Level.FINE);
        }
        return this.getQrCode(user);
    }

    public byte[] getQrCode(Users user) {
        byte[] qr_code = null;
        if (user.getTwoFactor()) {
            try {
                qr_code = QRCodeGenerator.getQRCodeBytes(user.getEmail(), "hops.io", user.getSecret());
            }
            catch (WriterException | IOException ex) {
                LOGGER.log(Level.SEVERE, null, ex);
            }
        }
        return qr_code;
    }

    public void registerGroup(Users uid, int gidNumber) {
        BbcGroup bbcGroup = (BbcGroup)this.bbcGroupFacade.find(gidNumber);
        uid.getBbcGroupCollection().add(bbcGroup);
        this.userFacade.update(uid);
    }

    public void registerAddress(Users user) {
        Address add = new Address();
        add.setAddress1("-");
        add.setAddress2("-");
        add.setAddress3("-");
        add.setState("-");
        add.setCity("-");
        add.setCountry("-");
        add.setPostalcode("-");
        user.setAddress(add);
        this.userFacade.persist(user);
    }

    public void increaseLockNum(int id, int val) {
        Users p = (Users)this.userFacade.find(id);
        if (p != null) {
            p.setFalseLogin(val);
            this.userFacade.update(p);
        }
    }

    public void setOnline(int id, int val) {
        Users p = (Users)this.userFacade.find(id);
        p.setIsonline(val);
        this.userFacade.update(p);
    }

    public void resetLock(int id) {
        Users p = (Users)this.userFacade.find(id);
        p.setFalseLogin(0);
        this.userFacade.update(p);
    }

    public void changeAccountStatus(int id, String note, UserAccountStatus status) {
        Users p = (Users)this.userFacade.find(id);
        if (p != null) {
            p.setNotes(note);
            p.setStatus(status);
            this.userFacade.update(p);
        }
    }

    public void updateStatus(Users id, UserAccountStatus stat) {
        id.setStatus(stat);
        this.userFacade.update(id);
    }

    public void updateSecret(Users user, String sec) {
        user.setSecret(sec);
        this.userFacade.update(user);
    }

    public void increaseNumCreatedProjects(int id) {
        Users u = (Users)this.userFacade.find(id);
        u.setNumCreatedProjects(u.getNumCreatedProjects() + 1);
        u.setNumActiveProjects(u.getNumActiveProjects() + 1);
        this.userFacade.update(u);
    }

    public void decrementNumProjectsCreated(int id) {
        Users u = (Users)this.userFacade.find(id);
        int n = u.getNumCreatedProjects();
        if (n > 0) {
            u.setNumCreatedProjects(n - 1);
            this.userFacade.update(u);
        }
    }

    public void decrementNumActiveProjects(int id) {
        Users u = (Users)this.userFacade.find(id);
        int n = u.getNumActiveProjects();
        if (n > 0) {
            u.setNumActiveProjects(n - 1);
            this.userFacade.update(u);
        }
    }

    public boolean isUsernameTaken(String username) {
        return this.userFacade.findByEmail(username) != null;
    }

    public boolean isUserInRole(Users user, String groupName) {
        if (user == null || groupName == null) {
            return false;
        }
        BbcGroup group = this.bbcGroupFacade.findByGroupName(groupName);
        if (group == null) {
            return false;
        }
        return user.getBbcGroupCollection().contains(group);
    }

    public List<String> getUserRoles(Users p) {
        Collection<BbcGroup> groupList = p.getBbcGroupCollection();
        ArrayList<String> list = new ArrayList<String>();
        for (BbcGroup g : groupList) {
            list.add(g.getGroupName());
        }
        return list;
    }

    public void updateMaxNumProjs(Users id, int maxNumProjs) {
        id.setMaxNumProjects(maxNumProjs);
        this.userFacade.update(id);
    }

    public void deleteUser(Users u) {
        if (u != null) {
            List<RolesAudit> results1 = this.rolesAuditFacade.findByInitiator(u);
            List<RolesAudit> results2 = this.rolesAuditFacade.findByTarget(u);
            results1.addAll(results2);
            for (RolesAudit next : results1) {
                this.rolesAuditFacade.remove(next);
            }
            List<AccountAudit> resultsAA1 = this.accountAuditFacade.findByInitiator(u);
            List<AccountAudit> resultsAA2 = this.accountAuditFacade.findByTarget(u);
            resultsAA1.addAll(resultsAA2);
            for (AccountAudit next : resultsAA1) {
                this.accountAuditFacade.remove(next);
            }
            this.userFacade.removeByEmail(u.getEmail());
        }
    }
}

