/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.util;

import io.hops.hopsworks.common.util.IoUtils;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;

public class ConfigFileGenerator {
    public static final String TEMPLATE_ROOT = File.separator + "io" + File.separator + "hops";
    public static final String JUPYTER_NOTEBOOK_CONFIG_TEMPLATE = TEMPLATE_ROOT + File.separator + "jupyter" + File.separator + "jupyter_notebook_config_template.py";
    public static final String JUPYTER_CUSTOM_TEMPLATE = TEMPLATE_ROOT + File.separator + "jupyter" + File.separator + "custom_template.js";
    public static final String JUPYTER_CUSTOM_KERNEL = TEMPLATE_ROOT + File.separator + "jupyter" + File.separator + "kernel_template.json";
    public static final String SPARKMAGIC_CONFIG_TEMPLATE = TEMPLATE_ROOT + File.separator + "jupyter" + File.separator + "config_template.json";

    public static StringBuilder instantiateFromTemplate(String filePath, String ... pairs) throws IOException {
        if (pairs.length % 2 != 0) {
            throw new IOException("Odd number of parameters when instantiating a template. Are you missing a parameter?");
        }
        StringBuilder sb = new StringBuilder();
        String script = IoUtils.readContentFromClasspath(filePath);
        if (pairs.length > 0) {
            for (int i = 0; i < pairs.length; i += 2) {
                String key = pairs[i];
                String val = pairs[i + 1];
                script = script.replaceAll("%%" + key + "%%", val);
            }
        }
        return sb.append(script);
    }

    public static StringBuilder instantiateFromTemplate(String filePath, Map<String, String> params) throws IOException {
        StringBuilder sb = new StringBuilder();
        String script = IoUtils.readContentFromClasspath(filePath);
        if (params.size() > 0) {
            for (Map.Entry<String, String> env : params.entrySet()) {
                if (env.getValue() == null) continue;
                script = script.replaceAll("%%" + env.getKey() + "%%", env.getValue());
            }
        }
        return sb.append(script);
    }

    public static boolean mkdirs(String path) {
        File cbDir = new File(path);
        return cbDir.mkdirs();
    }

    public static boolean createConfigFile(File path, String contents) throws IOException {
        if (!path.exists() && !path.createNewFile()) {
            throw new IOException("Problem creating file: " + path);
        }
        PrintWriter out = new PrintWriter(path);
        out.println(contents);
        out.flush();
        out.close();
        return true;
    }
}

