/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.util;

import io.hops.hopsworks.common.dao.metadata.EntityIntf;
import io.hops.hopsworks.common.dao.metadata.InodeTableComposite;
import io.hops.hopsworks.common.dao.metadata.Metadata;
import io.hops.hopsworks.common.dao.metadata.RawData;
import java.io.Reader;
import java.io.StringReader;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonValue;

public class JsonUtil {
    private static final Logger logger = Logger.getLogger(JsonUtil.class.getName());

    public static InodeTableComposite parseSchemaHeader(String message) {
        JsonObject obj = Json.createReader((Reader)new StringReader(message)).readObject();
        InodeTableComposite itc = null;
        try {
            int inodePid = obj.getInt("inodepid");
            String inodeName = obj.getString("inodename");
            int tableid = obj.getInt("tableid");
            itc = new InodeTableComposite(tableid, inodePid, inodeName);
        }
        catch (NullPointerException e) {
            logger.log(Level.SEVERE, "Inodepid or inodename or tableid not present in the message");
        }
        return itc;
    }

    public static List<EntityIntf> parseSchemaPayload(String message) {
        JsonObject obj = Json.createReader((Reader)new StringReader(message)).readObject();
        JsonObject meta = obj.getJsonObject("metadata");
        LinkedList<EntityIntf> data = new LinkedList<EntityIntf>();
        Set set = meta.entrySet();
        for (Map.Entry entry : set) {
            if (!JsonUtil.isNumeric((String)entry.getKey())) continue;
            RawData raw = new RawData();
            LinkedList<Metadata> metalist = new LinkedList<Metadata>();
            int fieldid = Integer.parseInt((String)entry.getKey());
            raw.getRawdataPK().setFieldid(fieldid);
            if (((JsonValue)entry.getValue()).getValueType() == JsonValue.ValueType.STRING) {
                Metadata metadata = new Metadata();
                metadata.getMetadataPK().setFieldid(fieldid);
                metadata.setData(((JsonValue)entry.getValue()).toString().replaceAll("\"", ""));
                metalist.add(metadata);
                raw.setMetadata(metalist);
            } else if (((JsonValue)entry.getValue()).getValueType() == JsonValue.ValueType.ARRAY) {
                JsonArray array = Json.createReader((Reader)new StringReader(((JsonValue)entry.getValue()).toString())).readArray();
                if (array.size() == 0) continue;
                for (JsonValue value : array) {
                    JsonObject object = Json.createReader((Reader)new StringReader(value.toString())).readObject();
                    Metadata metadata = new Metadata();
                    metadata.getMetadataPK().setFieldid(fieldid);
                    metadata.setData(object.getString("value").replaceAll("\"", ""));
                    metalist.add(metadata);
                }
                raw.setMetadata(metalist);
            }
            data.add(raw);
        }
        return data;
    }

    private static boolean isNumeric(String value) {
        try {
            Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }
}

