/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dao.kafka;

import io.hops.hopsworks.common.dao.AbstractFacade;
import io.hops.hopsworks.common.dao.kafka.SchemaTopics;
import io.hops.hopsworks.common.dao.kafka.SchemaTopicsPK;
import java.util.Optional;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;

@Stateless
public class SchemaTopicsFacade
extends AbstractFacade<SchemaTopics> {
    @PersistenceContext(unitName="kthfsPU")
    private EntityManager em;

    @Override
    protected EntityManager getEntityManager() {
        return this.em;
    }

    public SchemaTopicsFacade() {
        super(SchemaTopics.class);
    }

    public Optional<SchemaTopics> findSchemaByNameAndVersion(String schemaName, Integer schemaVersion) {
        try {
            return Optional.of(this.find(new SchemaTopicsPK(schemaName, schemaVersion)));
        }
        catch (NullPointerException e) {
            return Optional.empty();
        }
    }

    @Deprecated
    public Optional<SchemaTopics> getSchemaByNameAndVersion(String schemaName, Integer schemaVersion) {
        try {
            return Optional.of(this.em.createNamedQuery("SchemaTopics.findByNameAndVersion", SchemaTopics.class).setParameter("name", (Object)schemaName).setParameter("version", (Object)schemaVersion).getSingleResult());
        }
        catch (NoResultException e) {
            return Optional.empty();
        }
    }
}

