/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.jobs.flink;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.hops.hopsworks.common.jobs.beam.BeamFlinkJobConfiguration;
import io.hops.hopsworks.common.jobs.configuration.JobType;
import io.hops.hopsworks.common.jobs.yarn.YarnJobConfiguration;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlSeeAlso(value={BeamFlinkJobConfiguration.class})
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY)
@JsonSubTypes(value={@JsonSubTypes.Type(value=BeamFlinkJobConfiguration.class, name="BeamFlinkJobConfiguration")})
public class FlinkJobConfiguration
extends YarnJobConfiguration {
    @XmlElement(name="jobmanager.heap.size")
    private int jobManagerMemory = 1024;
    @XmlElement
    private int numberOfTaskManagers = 1;
    @XmlElement(name="taskmanager.numberOfTaskSlots")
    private int numberOfTaskSlots = 1;
    @XmlElement(name="taskmanager.heap.size")
    private int taskManagerMemory = 1024;
    @XmlElement
    private String properties;

    public int getJobManagerMemory() {
        return this.jobManagerMemory;
    }

    public void setJobManagerMemory(int jobManagerMemory) {
        this.jobManagerMemory = jobManagerMemory;
    }

    public int getNumberOfTaskManagers() {
        return this.numberOfTaskManagers;
    }

    public void setNumberOfTaskManagers(int numberOfTaskManagers) throws IllegalArgumentException {
        if (numberOfTaskManagers < 1) {
            throw new IllegalArgumentException("Number of task managers has to be greater than or equal to 1.");
        }
        this.numberOfTaskManagers = numberOfTaskManagers;
    }

    public int getNumberOfTaskSlots() {
        return this.numberOfTaskSlots;
    }

    public void setNumberOfTaskSlots(int numberOfTaskSlots) throws IllegalArgumentException {
        if (numberOfTaskSlots < 1) {
            throw new IllegalArgumentException("Number of task manager slots has to be greater than or equal to 1.");
        }
        this.numberOfTaskSlots = numberOfTaskSlots;
    }

    public int getTaskManagerMemory() {
        return this.taskManagerMemory;
    }

    public void setTaskManagerMemory(int taskManagerMemory) throws IllegalArgumentException {
        if (taskManagerMemory < 1) {
            throw new IllegalArgumentException("TaskManager memory must be greater than 512MB.");
        }
        this.taskManagerMemory = taskManagerMemory;
    }

    @Override
    @XmlElement(name="jobType")
    public JobType getJobType() {
        return JobType.FLINK;
    }

    @Override
    @XmlElement(name="jobTypeName")
    public String getJobTypeName() {
        return JobType.FLINK.getName();
    }

    public String getProperties() {
        return this.properties;
    }

    public void setProperties(String properties) {
        this.properties = properties;
    }
}

