/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.jobs.yarn;

import io.hops.hopsworks.common.hdfs.DistributedFileSystemOps;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.input.BoundedInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.file.tfile.TFile;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.logaggregation.AggregatedLogFormat;

public class LogReader {
    private static final Log LOG = LogFactory.getLog(LogReader.class);
    private final FSDataInputStream fsDataIStream;
    private final TFile.Reader.Scanner scanner;
    private final TFile.Reader reader;
    private static final Map<String, AggregatedLogFormat.LogKey> RESERVED_KEYS;
    private static final AggregatedLogFormat.LogKey APPLICATION_ACL_KEY;
    private static final AggregatedLogFormat.LogKey APPLICATION_OWNER_KEY;
    private static final AggregatedLogFormat.LogKey VERSION_KEY;
    private boolean atBeginning = true;

    public LogReader(Configuration conf, DistributedFileSystemOps dfs, Path remoteAppLogFile) throws IOException {
        this.fsDataIStream = dfs.open(remoteAppLogFile);
        this.reader = new TFile.Reader(this.fsDataIStream, dfs.getFileStatus(remoteAppLogFile).getLen(), conf);
        this.scanner = this.reader.createScanner();
    }

    public DataInputStream next(AggregatedLogFormat.LogKey key) throws IOException {
        if (!this.atBeginning) {
            this.scanner.advance();
        } else {
            this.atBeginning = false;
        }
        if (this.scanner.atEnd()) {
            return null;
        }
        TFile.Reader.Scanner.Entry entry = this.scanner.entry();
        key.readFields((DataInput)entry.getKeyStream());
        if (RESERVED_KEYS.containsKey(key.toString())) {
            return this.next(key);
        }
        DataInputStream valueStream = entry.getValueStream();
        return valueStream;
    }

    public AggregatedLogFormat.ContainerLogsReader getContainerLogsReader(ContainerId containerId) throws IOException {
        AggregatedLogFormat.ContainerLogsReader logReader = null;
        AggregatedLogFormat.LogKey containerKey = new AggregatedLogFormat.LogKey(containerId);
        AggregatedLogFormat.LogKey key = new AggregatedLogFormat.LogKey();
        DataInputStream valueStream = this.next(key);
        while (valueStream != null && !key.equals((Object)containerKey)) {
            valueStream = this.next(key);
        }
        if (valueStream != null) {
            logReader = new AggregatedLogFormat.ContainerLogsReader(valueStream);
        }
        return logReader;
    }

    public static void readAcontainerLogs(DataInputStream valueStream, Writer writer) throws IOException {
        int bufferSize = 65536;
        char[] cbuf = new char[bufferSize];
        block2: while (true) {
            String fileType;
            try {
                fileType = valueStream.readUTF();
            }
            catch (EOFException e) {
                return;
            }
            String fileLengthStr = valueStream.readUTF();
            long fileLength = Long.parseLong(fileLengthStr);
            writer.write("\n\nLogType:");
            writer.write(fileType);
            writer.write("\nLogLength:");
            writer.write(fileLengthStr);
            writer.write("\nLog Contents:\n");
            BoundedInputStream bis = new BoundedInputStream((InputStream)valueStream, fileLength);
            InputStreamReader reader = new InputStreamReader((InputStream)bis);
            int currentRead = 0;
            int totalRead = 0;
            while (true) {
                if ((currentRead = reader.read(cbuf, 0, bufferSize)) == -1) continue block2;
                writer.write(cbuf, 0, currentRead);
                totalRead += currentRead;
            }
            break;
        }
    }

    public static void readAContainerLogsForALogType(DataInputStream valueStream, PrintStream out) throws IOException {
        byte[] buf = new byte[65535];
        String fileType = valueStream.readUTF();
        String fileLengthStr = valueStream.readUTF();
        long fileLength = Long.parseLong(fileLengthStr);
        out.print("LogType: ");
        out.println(fileType);
        out.print("LogLength: ");
        out.println(fileLengthStr);
        out.println("Log Contents:");
        long curRead = 0L;
        long pendingRead = fileLength - curRead;
        int toRead = pendingRead > (long)buf.length ? buf.length : (int)pendingRead;
        int len = valueStream.read(buf, 0, toRead);
        while (len != -1 && curRead < fileLength) {
            out.write(buf, 0, len);
            pendingRead = fileLength - (curRead += (long)len);
            toRead = pendingRead > (long)buf.length ? buf.length : (int)pendingRead;
            len = valueStream.read(buf, 0, toRead);
        }
        out.println("");
    }

    public void close() {
        IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{this.scanner, this.reader, this.fsDataIStream});
    }

    static {
        APPLICATION_ACL_KEY = new AggregatedLogFormat.LogKey("APPLICATION_ACL");
        APPLICATION_OWNER_KEY = new AggregatedLogFormat.LogKey("APPLICATION_OWNER");
        VERSION_KEY = new AggregatedLogFormat.LogKey("VERSION");
        RESERVED_KEYS = new HashMap<String, AggregatedLogFormat.LogKey>();
        RESERVED_KEYS.put(APPLICATION_ACL_KEY.toString(), APPLICATION_ACL_KEY);
        RESERVED_KEYS.put(APPLICATION_OWNER_KEY.toString(), APPLICATION_OWNER_KEY);
        RESERVED_KEYS.put(VERSION_KEY.toString(), VERSION_KEY);
    }
}

