/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dao.metadata.db;

import io.hops.hopsworks.common.dao.AbstractFacade;
import io.hops.hopsworks.common.dao.metadata.RawData;
import io.hops.hopsworks.common.dao.metadata.RawDataPK;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.TypedQuery;

@Stateless
public class RawDataFacade
extends AbstractFacade<RawData> {
    private static final Logger LOGGER = Logger.getLogger(RawDataFacade.class.getName());
    @PersistenceContext(unitName="kthfsPU")
    private EntityManager em;

    @Override
    protected EntityManager getEntityManager() {
        return this.em;
    }

    public RawDataFacade() {
        super(RawData.class);
    }

    public RawData getRawData(RawDataPK rawdataPK) {
        TypedQuery q = this.em.createNamedQuery("RawData.findByPrimaryKey", RawData.class);
        q.setParameter("rawdataPK", (Object)rawdataPK);
        try {
            return (RawData)q.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public void addRawData(RawData raw) {
        try {
            RawData r;
            RawData rawData = r = this.contains(raw) ? raw : this.getRawData(raw.getRawdataPK());
            if (r != null && r.getRawdataPK().getTupleid() != -1 && r.getRawdataPK().getFieldid() != -1) {
                r.copy(raw);
                this.em.merge((Object)r);
            } else {
                r = raw;
                this.em.persist((Object)r);
            }
            this.em.flush();
            this.em.clear();
        }
        catch (IllegalStateException | SecurityException ex) {
            LOGGER.log(Level.SEVERE, "Could not add raw data " + raw, ex);
            throw ex;
        }
    }

    public int getLastInsertedTupleId() {
        String queryString = "RawData.lastInsertedTupleId";
        Query query = this.em.createNamedQuery(queryString);
        List list = query.getResultList();
        return !list.isEmpty() ? ((RawData)list.get(0)).getId() : 0;
    }

    public boolean contains(RawData rawdata) {
        return this.em.contains((Object)rawdata);
    }
}

