/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.trainingdatasets.external;

import com.google.common.base.Strings;
import io.hops.hopsworks.common.dao.featurestore.storageconnector.s3.FeaturestoreS3Connector;
import io.hops.hopsworks.common.dao.featurestore.trainingdataset.TrainingDataset;
import io.hops.hopsworks.common.dao.featurestore.trainingdataset.external.ExternalTrainingDataset;
import io.hops.hopsworks.common.featurestore.storageconnectors.s3.FeaturestoreS3ConnectorFacade;
import io.hops.hopsworks.common.featurestore.trainingdatasets.external.ExternalTrainingDatasetDTO;
import io.hops.hopsworks.common.featurestore.trainingdatasets.external.ExternalTrainingDatasetFacade;
import io.hops.hopsworks.exceptions.FeaturestoreException;
import io.hops.hopsworks.restutils.RESTCodes;
import java.util.logging.Level;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;

@Stateless
public class ExternalTrainingDatasetController {
    @EJB
    private ExternalTrainingDatasetFacade externalTrainingDatasetFacade;
    @EJB
    private FeaturestoreS3ConnectorFacade featurestoreS3ConnectorFacade;

    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public ExternalTrainingDataset createExternalTrainingDataset(ExternalTrainingDatasetDTO externalTrainingDatasetDTO) throws FeaturestoreException {
        this.verifyExternalTrainingDatasetInput(externalTrainingDatasetDTO);
        FeaturestoreS3Connector featurestoreS3Connector = (FeaturestoreS3Connector)this.featurestoreS3ConnectorFacade.find(externalTrainingDatasetDTO.getS3ConnectorId());
        if (featurestoreS3Connector == null) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.S3_CONNECTOR_NOT_FOUND, Level.FINE, "hopsfsConnector: " + externalTrainingDatasetDTO.getS3ConnectorId());
        }
        ExternalTrainingDataset externalTrainingDataset = new ExternalTrainingDataset();
        externalTrainingDataset.setName(externalTrainingDatasetDTO.getName());
        externalTrainingDataset.setFeaturestoreS3Connector(featurestoreS3Connector);
        this.externalTrainingDatasetFacade.persist(externalTrainingDataset);
        return externalTrainingDataset;
    }

    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public void removeExternalTrainingDataset(ExternalTrainingDataset externalTrainingDataset) {
        this.externalTrainingDatasetFacade.remove(externalTrainingDataset);
    }

    private void verifyExternalTrainingDatasetName(String name) throws FeaturestoreException {
        if (Strings.isNullOrEmpty((String)name)) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_TRAINING_DATASET_NAME, Level.FINE, ", the name of an external training dataset should not be empty ");
        }
        if (name.length() > 256) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_TRAINING_DATASET_NAME, Level.FINE, ", the name of an external training dataset should be less than 256 characters");
        }
    }

    private FeaturestoreS3Connector verifyExternalTrainingDatasetS3ConnectorId(Integer s3ConnectorId) throws FeaturestoreException {
        if (s3ConnectorId == null) {
            throw new IllegalArgumentException(RESTCodes.FeaturestoreErrorCode.S3_CONNECTOR_ID_NOT_PROVIDED.getMessage());
        }
        FeaturestoreS3Connector featurestoreS3Connector = (FeaturestoreS3Connector)this.featurestoreS3ConnectorFacade.find(s3ConnectorId);
        if (featurestoreS3Connector == null) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.S3_CONNECTOR_NOT_FOUND, Level.FINE, "S3 connector with id: " + s3ConnectorId + " was not found");
        }
        return featurestoreS3Connector;
    }

    public ExternalTrainingDatasetDTO convertExternalTrainingDatasetToDTO(TrainingDataset trainingDataset) {
        ExternalTrainingDatasetDTO externalTrainingDatasetDTO = new ExternalTrainingDatasetDTO(trainingDataset);
        externalTrainingDatasetDTO.setName(trainingDataset.getExternalTrainingDataset().getName());
        externalTrainingDatasetDTO.setLocation("s3a://" + trainingDataset.getExternalTrainingDataset().getFeaturestoreS3Connector().getBucket() + "/" + "TRAINING_DATASETS" + "/" + trainingDataset.getExternalTrainingDataset().getName() + "_" + trainingDataset.getVersion());
        return externalTrainingDatasetDTO;
    }

    private void verifyExternalTrainingDatasetInput(ExternalTrainingDatasetDTO externalTrainingDatasetDTO) throws FeaturestoreException {
        this.verifyExternalTrainingDatasetName(externalTrainingDatasetDTO.getName());
        this.verifyExternalTrainingDatasetS3ConnectorId(externalTrainingDatasetDTO.getS3ConnectorId());
    }

    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public void updateExternalTrainingDatasetMetadata(ExternalTrainingDataset externalTrainingDataset, ExternalTrainingDatasetDTO externalTrainingDatasetDTO) throws FeaturestoreException {
        if (!Strings.isNullOrEmpty((String)externalTrainingDatasetDTO.getName())) {
            this.verifyExternalTrainingDatasetName(externalTrainingDatasetDTO.getName());
            externalTrainingDataset.setName(externalTrainingDatasetDTO.getName());
        }
        if (externalTrainingDatasetDTO.getS3ConnectorId() != null) {
            FeaturestoreS3Connector featurestoreS3Connector = this.verifyExternalTrainingDatasetS3ConnectorId(externalTrainingDatasetDTO.getS3ConnectorId());
            externalTrainingDataset.setFeaturestoreS3Connector(featurestoreS3Connector);
        }
        this.externalTrainingDatasetFacade.updateExternalTrainingDatasetMetadata(externalTrainingDataset);
    }
}

