/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.trainingdatasets.hopsfs;

import io.hops.hopsworks.common.dao.featurestore.storageconnector.hopsfs.FeaturestoreHopsfsConnector;
import io.hops.hopsworks.common.dao.featurestore.trainingdataset.TrainingDataset;
import io.hops.hopsworks.common.dao.featurestore.trainingdataset.hopsfs.HopsfsTrainingDataset;
import io.hops.hopsworks.common.dao.hdfs.inode.Inode;
import io.hops.hopsworks.common.dao.hdfs.inode.InodeFacade;
import io.hops.hopsworks.common.featurestore.storageconnectors.hopsfs.FeaturestoreHopsfsConnectorFacade;
import io.hops.hopsworks.common.featurestore.trainingdatasets.hopsfs.HopsfsTrainingDatasetDTO;
import io.hops.hopsworks.common.featurestore.trainingdatasets.hopsfs.HopsfsTrainingDatasetFacade;
import io.hops.hopsworks.common.hdfs.inode.InodeController;
import io.hops.hopsworks.exceptions.FeaturestoreException;
import io.hops.hopsworks.restutils.RESTCodes;
import java.util.logging.Level;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;

@Stateless
public class HopsfsTrainingDatasetController {
    @EJB
    private HopsfsTrainingDatasetFacade hopsfsTrainingDatasetFacade;
    @EJB
    private FeaturestoreHopsfsConnectorFacade featurestoreHopsfsConnectorFacade;
    @EJB
    private InodeFacade inodeFacade;
    @EJB
    private InodeController inodeController;

    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public HopsfsTrainingDataset createHopsfsTrainingDataset(HopsfsTrainingDatasetDTO hopsfsTrainingDatasetDTO) throws FeaturestoreException {
        this.verifyHopsfsTrainingDatasetInput(hopsfsTrainingDatasetDTO);
        Inode inode = this.inodeFacade.findById(hopsfsTrainingDatasetDTO.getInodeId());
        FeaturestoreHopsfsConnector featurestoreHopsfsConnector = (FeaturestoreHopsfsConnector)this.featurestoreHopsfsConnectorFacade.find(hopsfsTrainingDatasetDTO.getHopsfsConnectorId());
        HopsfsTrainingDataset hopsfsTrainingDataset = new HopsfsTrainingDataset();
        hopsfsTrainingDataset.setInode(inode);
        hopsfsTrainingDataset.setFeaturestoreHopsfsConnector(featurestoreHopsfsConnector);
        this.hopsfsTrainingDatasetFacade.persist(hopsfsTrainingDataset);
        return hopsfsTrainingDataset;
    }

    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public void removeHopsfsTrainingDataset(HopsfsTrainingDataset hopsfsTrainingDataset) {
        this.hopsfsTrainingDatasetFacade.remove(hopsfsTrainingDataset);
    }

    private void verifyHopsfsTrainingDatasetConnectorId(Integer hopsfsConnectorId) throws FeaturestoreException {
        if (hopsfsConnectorId == null) {
            throw new IllegalArgumentException(RESTCodes.FeaturestoreErrorCode.HOPSFS_CONNECTOR_ID_NOT_PROVIDED.getMessage());
        }
        FeaturestoreHopsfsConnector featurestoreHopsfsConnector = (FeaturestoreHopsfsConnector)this.featurestoreHopsfsConnectorFacade.find(hopsfsConnectorId);
        if (featurestoreHopsfsConnector == null) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.HOPSFS_CONNECTOR_NOT_FOUND, Level.FINE, "HOPSFS connector with id: " + hopsfsConnectorId + " was not found");
        }
    }

    private void verifyHopsfsTrainingDatasetName(String hopsfsTrainingDatasetName) throws FeaturestoreException {
        if (hopsfsTrainingDatasetName.length() > 256) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_TRAINING_DATASET_NAME, Level.FINE, ", the name of a hopsfs training dataset should be less than 256 characters");
        }
    }

    private void verifyHopsfsTrainingDatasetInput(HopsfsTrainingDatasetDTO hopsfsTrainingDatasetDTO) throws FeaturestoreException {
        this.verifyHopsfsTrainingDatasetName(hopsfsTrainingDatasetDTO.getName());
        this.verifyHopsfsTrainingDatasetConnectorId(hopsfsTrainingDatasetDTO.getHopsfsConnectorId());
    }

    public HopsfsTrainingDatasetDTO convertHopsfsTrainingDatasetToDTO(TrainingDataset trainingDataset) {
        HopsfsTrainingDatasetDTO hopsfsTrainingDatasetDTO = new HopsfsTrainingDatasetDTO(trainingDataset);
        int versionLength = trainingDataset.getVersion().toString().length();
        String trainingDatasetNameWithVersion = trainingDataset.getHopsfsTrainingDataset().getInode().getInodePK().getName();
        String trainingDatasetName = trainingDatasetNameWithVersion.substring(0, trainingDatasetNameWithVersion.length() - (1 + versionLength));
        hopsfsTrainingDatasetDTO.setName(trainingDatasetName);
        hopsfsTrainingDatasetDTO.setHdfsStorePath(this.inodeController.getPath(trainingDataset.getHopsfsTrainingDataset().getInode()));
        hopsfsTrainingDatasetDTO.setLocation(hopsfsTrainingDatasetDTO.getHdfsStorePath());
        return hopsfsTrainingDatasetDTO;
    }

    public void updateHopsfsTrainingDatasetMetadata(HopsfsTrainingDataset hopsfsTrainingDataset, HopsfsTrainingDatasetDTO hopsfsTrainingDatasetDTO) {
    }
}

