/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dao.dataset;

import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlType;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;

@XmlType
@XmlEnum
public enum DatasetPermissions {
    GROUP_WRITABLE_SB("GROUP_WRITABLE_SB", "rwxrwx--T", "1770"),
    GROUP_WRITABLE("GROUP_WRITABLE", "rwxrwx---", "770"),
    OWNER_ONLY("OWNER_ONLY", "rwxr-x---", "750");

    @XmlEnumValue(value="displayName")
    private final String displayName;
    @XmlEnumValue(value="permissionStr")
    private final String permissionStr;
    @XmlEnumValue(value="permission")
    private final String permission;

    private DatasetPermissions(String displayName, String permissionStr, String permission) {
        this.displayName = displayName;
        this.permissionStr = permissionStr;
        this.permission = permission;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getPermissionStr() {
        return this.permissionStr;
    }

    public String getPermission() {
        return this.permission;
    }

    public static DatasetPermissions fromPermissionString(String permissionStr) {
        switch (permissionStr) {
            case "rwxrwx--T": {
                return GROUP_WRITABLE_SB;
            }
            case "rwxrwx---": {
                return GROUP_WRITABLE;
            }
            case "rwxr-x---": {
                return OWNER_ONLY;
            }
        }
        throw new IllegalArgumentException("Dataset permission has no value with the specified permission string.");
    }

    public static DatasetPermissions fromPermission(String permission) {
        switch (permission) {
            case "1770": {
                return GROUP_WRITABLE_SB;
            }
            case "770": {
                return GROUP_WRITABLE;
            }
            case "750": {
                return OWNER_ONLY;
            }
        }
        throw new IllegalArgumentException("Dataset permission has no value with the specified permission.");
    }

    public static DatasetPermissions fromString(String displayName) {
        return DatasetPermissions.valueOf(displayName.toUpperCase());
    }

    public static DatasetPermissions fromFilePermissions(FsPermission fsPermission) {
        if (fsPermission.equals((Object)new FsPermission(FsAction.ALL, FsAction.READ_EXECUTE, FsAction.NONE, false))) {
            return OWNER_ONLY;
        }
        if (fsPermission.equals((Object)new FsPermission(FsAction.ALL, FsAction.ALL, FsAction.NONE, true))) {
            return GROUP_WRITABLE_SB;
        }
        if (fsPermission.equals((Object)new FsPermission(FsAction.ALL, FsAction.ALL, FsAction.NONE, false))) {
            return GROUP_WRITABLE;
        }
        throw new IllegalArgumentException("Dataset permission has no value with the specified FsPermission.");
    }

    public FsPermission toFsPermission() {
        return new FsPermission(this.permission);
    }
}

