/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dao.kafka;

import io.hops.hopsworks.common.dao.kafka.ProjectTopics;
import io.hops.hopsworks.common.dao.kafka.SchemaCompatiblityCheck;
import io.hops.hopsworks.common.dao.kafka.SchemaDTO;
import io.hops.hopsworks.common.dao.kafka.SchemaTopics;
import io.hops.hopsworks.common.dao.kafka.SchemaTopicsPK;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.exceptions.KafkaException;
import io.hops.hopsworks.restutils.RESTCodes;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import org.apache.avro.Schema;
import org.apache.avro.SchemaCompatibility;
import org.apache.avro.SchemaParseException;

@Stateless
public class KafkaFacade {
    private static final Logger LOGGER = Logger.getLogger(KafkaFacade.class.getName());
    @PersistenceContext(unitName="kthfsPU")
    private EntityManager em;

    protected EntityManager getEntityManager() {
        return this.em;
    }

    public void validateSchema(SchemaDTO schemaDTO) throws KafkaException {
        if (schemaDTO == null) {
            throw new IllegalArgumentException("No schema provided");
        }
        this.validateSchemaNameAgainstBlacklist(schemaDTO.getName(), RESTCodes.KafkaErrorCode.CREATE_SCHEMA_RESERVED_NAME);
    }

    public void validateSchemaNameAgainstBlacklist(String schemaName, RESTCodes.KafkaErrorCode restCode) throws KafkaException {
        if (Settings.KAFKA_SCHEMA_BLACKLIST.contains(schemaName)) {
            throw new KafkaException(restCode, Level.FINE);
        }
    }

    public SchemaCompatiblityCheck schemaBackwardCompatibility(SchemaDTO schemaDto) {
        String schemaContent = schemaDto.getContents();
        TypedQuery query = this.em.createNamedQuery("SchemaTopics.findByName", SchemaTopics.class);
        query.setParameter("name", (Object)schemaDto.getName());
        try {
            Schema reader = new Schema.Parser().parse(schemaContent);
            for (SchemaTopics schemaTopic : query.getResultList()) {
                Schema writer = new Schema.Parser().parse(schemaTopic.getContents());
                SchemaCompatibility.SchemaPairCompatibility schemaCompatibility = SchemaCompatibility.checkReaderWriterCompatibility((Schema)reader, (Schema)writer);
                switch (schemaCompatibility.getType()) {
                    case COMPATIBLE: {
                        break;
                    }
                    case INCOMPATIBLE: {
                        return SchemaCompatiblityCheck.INCOMPATIBLE;
                    }
                }
            }
        }
        catch (SchemaParseException ex) {
            return SchemaCompatiblityCheck.INVALID;
        }
        return SchemaCompatiblityCheck.COMPATIBLE;
    }

    public void addSchemaForTopics(SchemaDTO schemaDto) {
        int newVersion = 1;
        TypedQuery query = this.em.createNamedQuery("SchemaTopics.findByName", SchemaTopics.class);
        query.setParameter("name", (Object)schemaDto.getName());
        List schemaTopics = query.getResultList();
        if (schemaTopics != null && !schemaTopics.isEmpty()) {
            for (SchemaTopics schemaTopic : schemaTopics) {
                int schemaVersion = schemaTopic.getSchemaTopicsPK().getVersion();
                if (newVersion >= schemaVersion) continue;
                newVersion = schemaVersion;
            }
            ++newVersion;
        }
        SchemaTopics schema = new SchemaTopics(schemaDto.getName(), newVersion, schemaDto.getContents(), new Date());
        this.em.persist((Object)schema);
        this.em.flush();
    }

    public SchemaDTO getSchemaForTopic(String topicName) {
        ProjectTopics topic;
        SchemaTopics schema;
        List topics = this.em.createNamedQuery("ProjectTopics.findByTopicName", ProjectTopics.class).setParameter("topicName", (Object)topicName).getResultList();
        if (topics != null && !topics.isEmpty() && (schema = (SchemaTopics)this.em.find(SchemaTopics.class, (Object)new SchemaTopicsPK((topic = (ProjectTopics)topics.get(0)).getSchemaTopics().getSchemaTopicsPK().getName(), topic.getSchemaTopics().getSchemaTopicsPK().getVersion()))) != null) {
            return new SchemaDTO(schema.getContents());
        }
        return null;
    }

    public SchemaTopics getSchema(String schemaName, Integer schemaVersion) {
        return (SchemaTopics)this.em.createNamedQuery("SchemaTopics.findByNameAndVersion", SchemaTopics.class).setParameter("name", (Object)schemaName).setParameter("version", (Object)schemaVersion).getSingleResult();
    }

    public List<SchemaDTO> listSchemasForTopics() {
        HashMap<String, List> schemas = new HashMap<String, List>();
        ArrayList<SchemaDTO> schemaDtos = new ArrayList<SchemaDTO>();
        TypedQuery query = this.em.createNamedQuery("SchemaTopics.findAll", SchemaTopics.class);
        for (SchemaTopics schemaTopics : query.getResultList()) {
            String schemaName = schemaTopics.getSchemaTopicsPK().getName();
            schemas.computeIfAbsent(schemaName, k -> new ArrayList());
            ((List)schemas.get(schemaName)).add(schemaTopics.getSchemaTopicsPK().getVersion());
        }
        for (Map.Entry entry : schemas.entrySet()) {
            schemaDtos.add(new SchemaDTO((String)entry.getKey(), (List)entry.getValue()));
        }
        return schemaDtos;
    }

    public SchemaDTO getSchemaContent(String schemaName, Integer schemaVersion) throws KafkaException {
        SchemaTopics schemaTopic = (SchemaTopics)this.em.find(SchemaTopics.class, (Object)new SchemaTopicsPK(schemaName, schemaVersion));
        if (schemaTopic == null) {
            throw new KafkaException(RESTCodes.KafkaErrorCode.SCHEMA_NOT_FOUND, Level.FINE, "Schema: " + schemaName);
        }
        return new SchemaDTO(schemaTopic.getContents());
    }

    public void deleteSchema(String schemaName, Integer version) throws KafkaException {
        this.validateSchemaNameAgainstBlacklist(schemaName, RESTCodes.KafkaErrorCode.DELETE_RESERVED_SCHEMA);
        List topics = this.em.createNamedQuery("ProjectTopics.findBySchemaVersion", ProjectTopics.class).setParameter("schema_name", (Object)schemaName).setParameter("schema_version", (Object)version).getResultList();
        if (topics != null && !topics.isEmpty()) {
            throw new KafkaException(RESTCodes.KafkaErrorCode.SCHEMA_IN_USE, Level.FINE);
        }
        SchemaTopics schema = (SchemaTopics)this.em.find(SchemaTopics.class, (Object)new SchemaTopicsPK(schemaName, version));
        this.em.remove((Object)schema);
        this.em.flush();
    }
}

