/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dao.kagent;

import io.hops.hopsworks.common.dao.host.Health;
import io.hops.hopsworks.common.dao.host.Hosts;
import io.hops.hopsworks.common.dao.host.Status;
import java.io.Serializable;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@Entity
@Table(name="hopsworks.host_services")
@NamedQueries(value={@NamedQuery(name="HostServices.findAll", query="SELECT r from HostServices r"), @NamedQuery(name="HostServices.findGroups", query="SELECT DISTINCT r.group FROM HostServices r"), @NamedQuery(name="HostServices.find", query="SELECT r FROM HostServices r WHERE r.group = :group AND r.service = :service AND r.host.hostname = :hostname"), @NamedQuery(name="HostServices.findOnHost", query="SELECT r FROM HostServices r WHERE r.group = :group AND r.service = :service AND r.host.hostname = :hostname"), @NamedQuery(name="HostServices.findBy-Hostname", query="SELECT r FROM HostServices r WHERE r.host.hostname = :hostname ORDER BY r.group, r.service"), @NamedQuery(name="HostServices.findBy-Group", query="SELECT r FROM HostServices r WHERE r.group = :group "), @NamedQuery(name="HostServices.findBy-Group-Service", query="SELECT r FROM HostServices r WHERE r.group = :group AND r.service = :service"), @NamedQuery(name="HostServices.findBy-Service", query="SELECT r FROM HostServices r WHERE r.service = :service"), @NamedQuery(name="HostServices.Count", query="SELECT COUNT(r) FROM HostServices r WHERE r.group = :group AND r.service = :service"), @NamedQuery(name="HostServices.Count-services", query="SELECT COUNT(r) FROM HostServices r WHERE r.group = :group"), @NamedQuery(name="HostServices.DeleteBy-Hostname", query="DELETE FROM HostServices r WHERE r.host.hostname = :hostname")})
public class HostServices
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Basic(optional=false)
    @Column(name="id")
    private Long id;
    @Column(name="pid")
    private Integer pid;
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=48)
    @Column(name="group_name")
    private String group;
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=48)
    @Column(name="service")
    private String service;
    @Basic(optional=false)
    @NotNull
    @Enumerated(value=EnumType.ORDINAL)
    @Column(name="status")
    private Status status;
    @Column(name="uptime")
    private long uptime;
    @Column(name="startTime")
    private long startTime;
    @Column(name="stopTime")
    private long stopTime;
    @JoinColumn(name="host_id", referencedColumnName="id")
    @ManyToOne
    private Hosts host;

    public HostServices() {
    }

    public HostServices(Long id) {
        this.id = id;
    }

    public HostServices(Long id, String service, String group, Status status, Hosts host) {
        this.id = id;
        this.service = service;
        this.group = group;
        this.status = status;
        this.host = host;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Integer getPid() {
        return this.pid;
    }

    public void setPid(Integer pid) {
        this.pid = pid;
    }

    public String getService() {
        return this.service;
    }

    public void setService(String service) {
        this.service = service;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public long getUptime() {
        return this.uptime;
    }

    public void setUptime(long uptime) {
        this.uptime = uptime;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getStopTime() {
        return this.stopTime;
    }

    public void setStopTime(long stopTime) {
        this.stopTime = stopTime;
    }

    public Hosts getHost() {
        return this.host;
    }

    public void setHost(Hosts host) {
        this.host = host;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.id != null ? this.id.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof HostServices)) {
            return false;
        }
        HostServices other = (HostServices)object;
        return (this.id != null || other.id == null) && (this.id == null || this.id.equals(other.id));
    }

    public String toString() {
        return "io.hops.hopsworks.common.dao.kagent.Services[ id=" + this.id + " ]";
    }

    public Health getHealth() {
        if (this.status == Status.Failed || this.status == Status.Stopped) {
            return Health.Bad;
        }
        return Health.Good;
    }
}

