/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.hdfs;

import com.google.common.base.CharMatcher;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Scanner;
import java.util.logging.Logger;
import javax.json.Json;
import javax.json.stream.JsonParsingException;
import org.apache.hadoop.fs.Path;

public final class Utils {
    private static final Logger logger = Logger.getLogger(Utils.class.getName());

    public static String getFileName(String path) {
        int lastSlash = path.lastIndexOf("/");
        int startName = lastSlash > -1 ? lastSlash + 1 : 0;
        return path.substring(startName);
    }

    public static String getExtension(String filename) {
        int lastDot = filename.lastIndexOf(".");
        if (lastDot < 0) {
            return "";
        }
        return filename.substring(lastDot);
    }

    public static String stripExtension(String filename) {
        int lastDot = filename.lastIndexOf(".");
        if (lastDot < 0) {
            return filename;
        }
        return filename.substring(0, lastDot);
    }

    public static String getDirectoryPart(String path) {
        int lastSlash = path.lastIndexOf("/");
        int startName = lastSlash > -1 ? lastSlash + 1 : 0;
        return path.substring(0, startName);
    }

    public static String getProjectPath(String projectname) {
        return "/Projects/" + projectname + "/";
    }

    public static String ensurePathEndsInSlash(String path) {
        if (!path.endsWith(File.separator)) {
            return path + File.separator;
        }
        return path;
    }

    public static int pathLen(String path) {
        return CharMatcher.is((char)'/').countIn((CharSequence)path);
    }

    public static boolean checkJsonValidity(String pathName) throws FileNotFoundException {
        String fileContent = Utils.getFileContents(pathName);
        if (fileContent == null) {
            return false;
        }
        try {
            Json.createReader((Reader)new StringReader(fileContent)).readObject();
        }
        catch (JsonParsingException e) {
            return false;
        }
        return true;
    }

    public static String getFileContents(String filePath) throws FileNotFoundException {
        File file = new File(filePath);
        Scanner scanner = new Scanner(file);
        if (!scanner.hasNext()) {
            return null;
        }
        return scanner.useDelimiter("\\Z").next();
    }

    public static String prepPath(String path) throws UnsupportedEncodingException {
        String result = path;
        if (path.contains("::")) {
            String[] parts = path.split("::");
            Path p = new Path(parts[0]);
            p = new Path(URLDecoder.decode(p.toUri().getRawPath(), StandardCharsets.UTF_8.toString()));
            result = p.toString() + "::" + parts[1];
        } else {
            Path p = new Path(path);
            p = new Path(URLDecoder.decode(p.toUri().getRawPath(), StandardCharsets.UTF_8.toString()));
            result = p.toString();
        }
        return result;
    }
}

