/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dataset;

import io.hops.hopsworks.common.util.ProjectUtils;
import io.hops.hopsworks.exceptions.DatasetException;
import io.hops.hopsworks.exceptions.ProjectException;
import io.hops.hopsworks.restutils.RESTCodes;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FolderNameValidator {
    private static Pattern datasetNameRegex = Pattern.compile("^((?!__)[-_a-zA-Z0-9\\.]){1,87}[-_a-zA-Z0-9]$");
    private static Pattern subDirNameRegex = Pattern.compile("^((?!__)[-_a-zA-Z0-9 \\.]){0,87}[-_a-zA-Z0-9]$");
    private static Pattern projectNameRegexValidator = Pattern.compile("^[a-zA-Z0-9]((?!__)[_a-zA-Z0-9]){0,61}[a-zA-Z0-9]$");

    public static void isValidName(String name, boolean subdir) throws DatasetException {
        if (name == null) {
            throw new IllegalArgumentException("Dataset name is null");
        }
        Matcher m = subdir ? subDirNameRegex.matcher(name) : datasetNameRegex.matcher(name);
        if (!m.find()) {
            throw new DatasetException(RESTCodes.DatasetErrorCode.DATASET_NAME_INVALID, Level.FINE);
        }
    }

    public static void isValidProjectName(ProjectUtils projectUtils, String name) throws ProjectException {
        if (name == null) {
            throw new IllegalArgumentException("Project name is null");
        }
        if (name.length() > 30) {
            throw new ProjectException(RESTCodes.ProjectErrorCode.PROJECT_NAME_TOO_LONG, Level.FINE);
        }
        for (String reservedName : projectUtils.getReservedProjectNames()) {
            if (name.compareToIgnoreCase(reservedName) != 0) continue;
            throw new ProjectException(RESTCodes.ProjectErrorCode.RESERVED_PROJECT_NAME, Level.FINE);
        }
        Matcher m = projectNameRegexValidator.matcher(name);
        if (!m.find()) {
            throw new ProjectException(RESTCodes.ProjectErrorCode.INVALID_PROJECT_NAME, Level.FINE);
        }
    }
}

