/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.python.environment;

import io.hops.hopsworks.common.agent.AgentController;
import io.hops.hopsworks.common.dao.host.Hosts;
import io.hops.hopsworks.common.dao.host.HostsFacade;
import io.hops.hopsworks.common.dao.project.Project;
import io.hops.hopsworks.common.dao.project.ProjectFacade;
import io.hops.hopsworks.common.dao.python.CondaCommandFacade;
import io.hops.hopsworks.common.dao.python.CondaCommands;
import io.hops.hopsworks.common.dao.python.LibraryFacade;
import io.hops.hopsworks.common.dao.python.PythonDep;
import io.hops.hopsworks.common.dao.user.Users;
import io.hops.hopsworks.common.elastic.ElasticController;
import io.hops.hopsworks.common.hdfs.DistributedFileSystemOps;
import io.hops.hopsworks.common.hdfs.DistributedFsService;
import io.hops.hopsworks.common.hdfs.HdfsUsersController;
import io.hops.hopsworks.common.python.commands.CommandsController;
import io.hops.hopsworks.common.python.library.LibraryController;
import io.hops.hopsworks.common.util.OSProcessExecutor;
import io.hops.hopsworks.common.util.ProcessDescriptor;
import io.hops.hopsworks.common.util.ProcessResult;
import io.hops.hopsworks.common.util.ProjectUtils;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.exceptions.ProjectException;
import io.hops.hopsworks.exceptions.PythonException;
import io.hops.hopsworks.exceptions.ServiceException;
import io.hops.hopsworks.restutils.RESTCodes;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.hadoop.fs.Path;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class EnvironmentController {
    @EJB
    private ProjectFacade projectFacade;
    @EJB
    private HostsFacade hostsFacade;
    @EJB
    private OSProcessExecutor osProcessExecutor;
    @EJB
    private Settings settings;
    @EJB
    private ProjectUtils projectUtils;
    @EJB
    private AgentController agentController;
    @EJB
    private LibraryController libraryController;
    @EJB
    private CondaCommandFacade condaCommandFacade;
    @EJB
    private CommandsController commandsController;
    @EJB
    private ElasticController elasticController;
    @EJB
    private HdfsUsersController hdfsUsersController;
    @EJB
    private DistributedFsService dfs;
    private static final Logger LOGGER = Logger.getLogger(EnvironmentController.class.getName());
    private static final DateTimeFormatter ELASTIC_INDEX_FORMATTER = DateTimeFormatter.ofPattern("yyyy.MM.dd");

    public void checkCondaEnabled(Project project, String pythonVersion) throws PythonException {
        if (!project.getConda().booleanValue() || !pythonVersion.equals(project.getPythonVersion())) {
            throw new PythonException(RESTCodes.PythonErrorCode.ANACONDA_ENVIRONMENT_NOT_FOUND, Level.FINE);
        }
    }

    public void checkCondaEnvExists(Project project) throws ServiceException, ProjectException, PythonException {
        if (!project.getConda().booleanValue()) {
            throw new PythonException(RESTCodes.PythonErrorCode.ANACONDA_ENVIRONMENT_NOT_FOUND, Level.FINE);
        }
        if (!project.getCondaEnv().booleanValue()) {
            this.createKibanaIndex(project);
            this.copyOnWriteCondaEnv(project);
        }
    }

    public void synchronizeDependencies(Project project) throws ServiceException {
        String envStr = this.agentController.listCondaEnvironment(this.projectUtils.getCurrentCondaEnvironment(project));
        Collection<PythonDep> pythonDeps = this.agentController.synchronizeDependencies(envStr, project.getPythonDepCollection());
        this.libraryController.addPythonDepsForProject(project, pythonDeps);
    }

    public JsonObject getMachineTypes() throws ServiceException {
        JsonObjectBuilder response = Json.createObjectBuilder();
        String cpuHost = this.hostsFacade.findCPUHost();
        if (cpuHost != null) {
            response.add("CPU", true);
        } else {
            response.add("CPU", false);
        }
        String gpuHost = this.hostsFacade.findGPUHost();
        if (gpuHost != null) {
            response.add("GPU", true);
        } else {
            response.add("GPU", false);
        }
        if (cpuHost == null && gpuHost == null) {
            throw new ServiceException(RESTCodes.ServiceErrorCode.HOST_NOT_FOUND, Level.WARNING, "Could not find any CPU or GPU host");
        }
        return response.build();
    }

    public boolean isEnvironmentReady(Project project) {
        List<CondaCommands> ops = this.condaCommandFacade.getCommandsForProject(project);
        for (CondaCommands condaCommand : ops) {
            CondaCommandFacade.CondaStatus status;
            CondaCommandFacade.CondaOp operation = condaCommand.getOp();
            if (!operation.equals((Object)CondaCommandFacade.CondaOp.CREATE) && !operation.equals((Object)CondaCommandFacade.CondaOp.YML) || !(status = condaCommand.getStatus()).equals((Object)CondaCommandFacade.CondaStatus.NEW) && !status.equals((Object)CondaCommandFacade.CondaStatus.ONGOING)) continue;
            return false;
        }
        return true;
    }

    public Collection<PythonDep> createProjectInDb(Project project, String pythonVersion, LibraryFacade.MachineType machineType, String environmentYml, Boolean installJupyter) throws ServiceException {
        if (environmentYml == null && pythonVersion.compareToIgnoreCase("2.7") != 0 && pythonVersion.compareToIgnoreCase("3.5") != 0 && pythonVersion.compareToIgnoreCase("3.6") != 0 && !pythonVersion.contains("X")) {
            throw new ServiceException(RESTCodes.ServiceErrorCode.PYTHON_INVALID_VERSION, Level.INFO, "pythonVersion: " + pythonVersion);
        }
        if (environmentYml != null) {
            this.condaEnvironmentOp(CondaCommandFacade.CondaOp.YML, pythonVersion, project, pythonVersion, machineType, environmentYml, installJupyter);
            this.setCondaEnv(project, true);
        } else {
            this.validateCondaHosts(machineType);
        }
        ArrayList<PythonDep> all = new ArrayList<PythonDep>();
        this.enableConda(project);
        return all;
    }

    private void enableConda(Project project) {
        if (project != null) {
            project.setConda(true);
            this.projectFacade.update(project);
            this.projectFacade.flushEm();
        }
    }

    private void setCondaEnv(Project project, boolean condaEnv) {
        project.setCondaEnv(condaEnv);
        this.projectFacade.mergeProject(project);
    }

    private List<Hosts> validateCondaHosts(LibraryFacade.MachineType machineType) throws ServiceException {
        List<Hosts> hosts = this.hostsFacade.getCondaHosts(machineType);
        if (hosts.isEmpty()) {
            throw new ServiceException(RESTCodes.ServiceErrorCode.ANACONDA_NODES_UNAVAILABLE, Level.WARNING);
        }
        return hosts;
    }

    public boolean condaEnabledHosts() {
        List<Hosts> hosts = this.hostsFacade.getCondaHosts(LibraryFacade.MachineType.ALL);
        return !hosts.isEmpty();
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void copyOnWriteCondaEnv(Project project) throws ServiceException {
        this.condaEnvironmentOp(CondaCommandFacade.CondaOp.CREATE, project.getPythonVersion(), project, project.getPythonVersion(), LibraryFacade.MachineType.ALL, null, false);
        this.setCondaEnv(project, true);
    }

    public void removeEnvironment(Project proj) throws ServiceException {
        this.commandsController.deleteCommandsForProject(proj);
        if (proj.getCondaEnv().booleanValue()) {
            this.condaEnvironmentRemove(proj);
            this.setCondaEnv(proj, false);
        }
        this.removePythonForProject(proj);
    }

    public void cloneProject(Project srcProject, Project destProj) throws ServiceException {
        this.condaEnvironmentClone(srcProject, destProj);
    }

    private void condaEnvironmentOp(CondaCommandFacade.CondaOp op, String pythonVersion, Project proj, String arg, LibraryFacade.MachineType machineType, String environmentYml, Boolean installJupyter) throws ServiceException {
        if (this.projectUtils.isReservedProjectName(proj.getName())) {
            throw new IllegalStateException("Tried to execute a conda env op on a reserved project name");
        }
        List<Hosts> hosts = this.validateCondaHosts(machineType);
        for (Hosts h : hosts) {
            CondaCommands cc = new CondaCommands(h, this.settings.getAnacondaUser(), op, CondaCommandFacade.CondaStatus.NEW, CondaCommandFacade.CondaInstallType.ENVIRONMENT, machineType, proj, pythonVersion, "", "defaults", new Date(), arg, environmentYml, installJupyter);
            this.condaCommandFacade.save(cc);
        }
    }

    private void condaEnvironmentRemove(Project proj) throws ServiceException {
        this.condaEnvironmentOp(CondaCommandFacade.CondaOp.REMOVE, "", proj, "", LibraryFacade.MachineType.ALL, null, false);
    }

    private void condaEnvironmentClone(Project srcProj, Project destProj) throws ServiceException {
        this.condaEnvironmentOp(CondaCommandFacade.CondaOp.CLONE, "", srcProj, destProj.getName(), LibraryFacade.MachineType.ALL, null, false);
    }

    public CondaCommands getOngoingEnvCreation(Project proj) {
        List<CondaCommands> commands = this.condaCommandFacade.getCommandsForProject(proj);
        for (CondaCommands command : commands) {
            if (!command.getOp().equals((Object)CondaCommandFacade.CondaOp.YML) && !command.getOp().equals((Object)CondaCommandFacade.CondaOp.CREATE) || !command.getStatus().equals((Object)CondaCommandFacade.CondaStatus.NEW) && !command.getStatus().equals((Object)CondaCommandFacade.CondaStatus.ONGOING)) continue;
            return command;
        }
        return null;
    }

    public void cleanupConda() throws ServiceException {
        List<Project> projects = this.projectFacade.findAll();
        if (projects != null && !projects.isEmpty()) {
            Project project = projects.get(0);
            this.condaEnvironmentOp(CondaCommandFacade.CondaOp.CLEAN, "", project, "", LibraryFacade.MachineType.ALL, "", false);
        }
    }

    private void removePythonForProject(Project proj) {
        proj.setPythonDepCollection(new ArrayList<PythonDep>());
        proj.setPythonVersion("");
        proj.setConda(false);
        this.projectFacade.update(proj);
    }

    public String findPythonVersion(String ymlFile) throws PythonException {
        String foundVersion = null;
        Pattern urlPattern = Pattern.compile("(- python=(\\d+.\\d+))");
        Matcher urlMatcher = urlPattern.matcher(ymlFile);
        if (!urlMatcher.find()) {
            throw new PythonException(RESTCodes.PythonErrorCode.YML_FILE_MISSING_PYTHON_VERSION, Level.FINE);
        }
        foundVersion = urlMatcher.group(2);
        return foundVersion;
    }

    public String createEnvironmentFromYml(String allYmlPath, String cpuYmlPath, String gpuYmlPath, boolean installJupyter, Users user, Project project) throws PythonException, ServiceException, ProjectException {
        String pythonVersionGPUYml;
        if (project.getConda().booleanValue() || project.getCondaEnv().booleanValue()) {
            throw new PythonException(RESTCodes.PythonErrorCode.ANACONDA_ENVIRONMENT_ALREADY_INITIALIZED, Level.FINE);
        }
        String username = this.hdfsUsersController.getHdfsUserName(project, user);
        String version = "0.0";
        if (allYmlPath != null && !allYmlPath.isEmpty()) {
            String pythonVersion;
            if (!allYmlPath.substring(allYmlPath.length() - 4).equals(".yml")) {
                throw new ServiceException(RESTCodes.ServiceErrorCode.INVALID_YML, Level.FINE, "allYmlPath is not a valid .yml file");
            }
            String allYml = this.getYmlFromPath(new Path(allYmlPath), username);
            version = pythonVersion = this.findPythonVersion(allYml);
            this.createKibanaIndex(project);
            this.createProjectInDb(project, version, LibraryFacade.MachineType.ALL, allYml, installJupyter);
            project.setPythonVersion(version);
            this.projectFacade.update(project);
            return version;
        }
        if (cpuYmlPath != null && !cpuYmlPath.isEmpty() && !cpuYmlPath.substring(cpuYmlPath.length() - 4).equals(".yml")) {
            throw new ServiceException(RESTCodes.ServiceErrorCode.INVALID_YML, Level.FINE, "cpuYmlPath is not a valid .yml file");
        }
        if (gpuYmlPath != null && !gpuYmlPath.isEmpty() && !gpuYmlPath.substring(gpuYmlPath.length() - 4).equals(".yml")) {
            throw new ServiceException(RESTCodes.ServiceErrorCode.INVALID_YML, Level.FINE, "gpuYmlPath is not a valid .yml file");
        }
        String cpuYml = cpuYmlPath != null && !cpuYmlPath.isEmpty() ? this.getYmlFromPath(new Path(cpuYmlPath), username) : "";
        String gpuYml = gpuYmlPath != null && !gpuYmlPath.isEmpty() ? this.getYmlFromPath(new Path(gpuYmlPath), username) : "";
        String pythonVersionCPUYml = this.findPythonVersion(cpuYml);
        if (!pythonVersionCPUYml.equals(pythonVersionGPUYml = this.findPythonVersion(gpuYml))) {
            throw new ServiceException(RESTCodes.ServiceErrorCode.INVALID_YML, Level.FINE, "python version mismatch between .yml files.");
        }
        version = pythonVersionCPUYml;
        this.createKibanaIndex(project);
        this.createProjectInDb(project, version, LibraryFacade.MachineType.CPU, cpuYml, installJupyter);
        this.createProjectInDb(project, version, LibraryFacade.MachineType.GPU, gpuYml, installJupyter);
        project.setPythonVersion(version);
        this.projectFacade.update(project);
        return version;
    }

    public void exportEnv(Users user, Project project) throws PythonException, ServiceException {
        String gpuHost;
        if (!project.getConda().booleanValue()) {
            throw new PythonException(RESTCodes.PythonErrorCode.ANACONDA_ENVIRONMENT_NOT_FOUND, Level.FINE);
        }
        String hdfsUser = this.hdfsUsersController.getHdfsUserName(project, user);
        String cpuHost = this.hostsFacade.findCPUHost();
        Date date = new Date();
        if (cpuHost != null) {
            this.exportEnvironment(cpuHost, "environment_cpu_" + date.getTime() + ".yml", hdfsUser, project);
        }
        if ((gpuHost = this.hostsFacade.findGPUHost()) != null) {
            this.exportEnvironment(gpuHost, "environment_gpu_" + date.getTime() + ".yml", hdfsUser, project);
        }
    }

    public void createEnv(String version, Project project) throws PythonException, ServiceException {
        if (project.getConda().booleanValue() || project.getCondaEnv().booleanValue()) {
            throw new PythonException(RESTCodes.PythonErrorCode.ANACONDA_ENVIRONMENT_ALREADY_INITIALIZED, Level.FINE);
        }
        this.createProjectInDb(project, version, LibraryFacade.MachineType.ALL, null, false);
        project.setPythonVersion(version);
        this.projectFacade.update(project);
        this.synchronizeDependencies(project);
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getYmlFromPath(Path fullPath, String username) throws ServiceException {
        DistributedFileSystemOps udfso = null;
        try {
            udfso = this.dfs.getDfsOps(username);
            long fileSize = udfso.getFileStatus(fullPath).getLen();
            byte[] ymlFileInBytes = new byte[(int)fileSize];
            if (fileSize >= 10000L) throw new ServiceException(RESTCodes.ServiceErrorCode.INVALID_YML_SIZE, Level.WARNING);
            try (DataInputStream dis = new DataInputStream((InputStream)udfso.open(fullPath));){
                dis.readFully(ymlFileInBytes, 0, (int)fileSize);
                String ymlFileContents = new String(ymlFileInBytes);
                String string = ymlFileContents = Arrays.stream(ymlFileContents.split(System.lineSeparator())).filter(line -> !line.contains("jupyter")).filter(line -> !line.contains("sparkmagic")).filter(line -> !line.contains("hdfscontents")).collect(Collectors.joining(System.lineSeparator()));
                return string;
            }
            {
                catch (IOException ex) {
                    throw new ServiceException(RESTCodes.ServiceErrorCode.ANACONDA_FROM_YML_ERROR, Level.SEVERE, "path: " + fullPath, ex.getMessage(), (Throwable)ex);
                }
            }
        }
        finally {
            if (udfso != null) {
                this.dfs.closeDfsClient(udfso);
            }
        }
    }

    private void exportEnvironment(String host, String environmentFile, String hdfsUser, Project project) throws ServiceException {
        String secretDir = DigestUtils.sha256Hex((String)(hdfsUser + environmentFile));
        String exportPath = this.settings.getStagingDir() + "/private_dirs/" + secretDir;
        File exportDir = new File(exportPath);
        exportDir.mkdirs();
        String prog = this.settings.getHopsworksDomainDir() + "/bin/condaexport.sh";
        ProcessDescriptor processDescriptor = new ProcessDescriptor.Builder().addCommand("/usr/bin/sudo").addCommand(prog).addCommand(exportPath).addCommand(project.getName()).addCommand(this.projectUtils.getCurrentCondaEnvironment(project)).addCommand(host).addCommand(environmentFile).addCommand(hdfsUser).setWaitTimeout(180L, TimeUnit.SECONDS).ignoreOutErrStreams(false).build();
        try {
            ProcessResult processResult = this.osProcessExecutor.execute(processDescriptor);
            if (processResult.getExitCode() != 0) {
                throw new IOException("A problem occurred when exporting the environment.");
            }
        }
        catch (IOException ex) {
            throw new ServiceException(RESTCodes.ServiceErrorCode.ANACONDA_EXPORT_ERROR, Level.SEVERE, "host: " + host + ", environmentFile: " + environmentFile + ", hdfsUser: " + hdfsUser, ex.getMessage(), (Throwable)ex);
        }
    }

    public void createKibanaIndex(Project project) throws ServiceException, ProjectException {
        String indexName = project.getName().toLowerCase() + "_kagent-*".replace("*", LocalDateTime.now().format(ELASTIC_INDEX_FORMATTER));
        if (!this.elasticController.indexExists(indexName)) {
            this.elasticController.createIndex(indexName);
        }
        this.elasticController.createIndexPattern(project, project.getName().toLowerCase() + "_kagent-*");
    }
}

