/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.util;

import io.hops.hopsworks.common.util.Ip;
import java.util.ArrayList;
import java.util.List;

public class ElasticSettings {
    public static final String ELASTIC_IP_DEFAULT = "127.0.0.1";
    public static final int ELASTIC_PORT_DEFAULT = 9300;
    public static final int ELASTIC_REST_PORT_DEFAULT = 9200;
    private final List<String> elasticIps;
    private final int elasticPort;
    private final int elasticRestPort;
    private int rrIndex = 0;

    public ElasticSettings(String elasticIps, int elasticPort, int elasticRestPort) {
        String[] ips = elasticIps.split(",");
        ArrayList<String> validIps = new ArrayList<String>();
        for (String ip : ips) {
            if (!Ip.validIp(ip)) continue;
            validIps.add(ip);
        }
        this.elasticIps = validIps;
        this.elasticPort = elasticPort;
        this.elasticRestPort = elasticRestPort;
    }

    public List<String> getElasticIps() {
        return this.elasticIps;
    }

    public String getElasticEndpoint() {
        return this.getElasticIp() + ":" + this.elasticPort;
    }

    public String getElasticRESTEndpoint() {
        return this.getElasticIp() + ":" + this.elasticRestPort;
    }

    public int getElasticPort() {
        return this.elasticPort;
    }

    private String getElasticIp() {
        if (this.rrIndex == this.elasticIps.size()) {
            this.rrIndex = 0;
        }
        return this.elasticIps.get(this.rrIndex++);
    }
}

