/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dao.certificates;

import io.hops.hopsworks.common.dao.certificates.UserCertsPK;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.Lob;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.XmlRootElement;

@Entity
@Table(name="user_certs", catalog="hopsworks", schema="")
@XmlRootElement
@NamedQueries(value={@NamedQuery(name="UserCerts.findAll", query="SELECT u FROM UserCerts u"), @NamedQuery(name="UserCerts.findByProjectname", query="SELECT u FROM UserCerts u WHERE u.userCertsPK.projectname = :projectname"), @NamedQuery(name="UserCerts.findByUsername", query="SELECT u FROM UserCerts u WHERE u.userCertsPK.username = :username"), @NamedQuery(name="UserCerts.findUserProjectCert", query="SELECT u FROM UserCerts u WHERE u.userCertsPK.username = :username AND u.userCertsPK.projectname = :projectname")})
public class UserCerts
implements Serializable {
    private static final long serialVersionUID = 1L;
    @EmbeddedId
    protected UserCertsPK userCertsPK;
    @Lob
    @Column(name="user_key")
    private byte[] userKey;
    @Lob
    @Column(name="user_cert")
    private byte[] userCert;
    @Size(min=1, max=200)
    @Column(name="user_key_pwd")
    private String userKeyPwd;

    public UserCerts() {
    }

    public UserCerts(UserCertsPK userCertsPK) {
        this.userCertsPK = userCertsPK;
    }

    public UserCerts(String projectname, String username) {
        this.userCertsPK = new UserCertsPK(projectname, username);
    }

    public UserCertsPK getUserCertsPK() {
        return this.userCertsPK;
    }

    public void setUserCertsPK(UserCertsPK userCertsPK) {
        this.userCertsPK = userCertsPK;
    }

    public byte[] getUserKey() {
        return this.userKey;
    }

    public void setUserKey(byte[] userKey) {
        this.userKey = userKey;
    }

    public byte[] getUserCert() {
        return this.userCert;
    }

    public void setUserCert(byte[] userCert) {
        this.userCert = userCert;
    }

    public String getUserKeyPwd() {
        return this.userKeyPwd;
    }

    public void setUserKeyPwd(String userKeyPwd) {
        this.userKeyPwd = userKeyPwd;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.userCertsPK != null ? this.userCertsPK.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof UserCerts)) {
            return false;
        }
        UserCerts other = (UserCerts)object;
        return !(this.userCertsPK == null && other.userCertsPK != null || this.userCertsPK != null && !this.userCertsPK.equals(other.userCertsPK));
    }

    public String toString() {
        return "se.kth.hopsworks.certificates.UserCerts[ userCertsPK=" + this.userCertsPK + " ]";
    }
}

