/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dao.kagent;

import io.hops.hopsworks.common.agent.AgentController;
import io.hops.hopsworks.common.dao.host.Hosts;
import io.hops.hopsworks.common.dao.host.HostsFacade;
import io.hops.hopsworks.common.dao.host.Status;
import io.hops.hopsworks.common.dao.kagent.Action;
import io.hops.hopsworks.common.dao.kagent.HostServices;
import io.hops.hopsworks.common.util.WebCommunication;
import io.hops.hopsworks.exceptions.GenericException;
import io.hops.hopsworks.exceptions.ServiceException;
import io.hops.hopsworks.restutils.RESTCodes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.NonUniqueResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import javax.ws.rs.core.Response;

@Stateless
public class HostServicesFacade {
    @EJB
    private WebCommunication web;
    @EJB
    private HostsFacade hostEJB;
    private static final Logger LOGGER = Logger.getLogger(HostServicesFacade.class.getName());
    @PersistenceContext(unitName="kthfsPU")
    private EntityManager em;

    public HostServices find(String hostname, String group, String service) {
        TypedQuery query = this.em.createNamedQuery("HostServices.find", HostServices.class).setParameter("hostname", (Object)hostname).setParameter("group", (Object)group).setParameter("service", (Object)service);
        List results = query.getResultList();
        if (results.isEmpty()) {
            return null;
        }
        if (results.size() == 1) {
            return (HostServices)results.get(0);
        }
        throw new NonUniqueResultException();
    }

    public List<HostServices> findAll() {
        TypedQuery query = this.em.createNamedQuery("HostServices.findAll", HostServices.class);
        return query.getResultList();
    }

    public List<HostServices> findGroupServices(String group) {
        TypedQuery query = this.em.createNamedQuery("HostServices.findBy-Group", HostServices.class).setParameter("group", (Object)group);
        return query.getResultList();
    }

    public List<String> findGroups() {
        return this.em.createNamedQuery("HostServices.findGroups", String.class).getResultList();
    }

    public List<HostServices> findHostServiceByHostname(String hostname) {
        TypedQuery query = this.em.createNamedQuery("HostServices.findBy-Hostname", HostServices.class).setParameter("hostname", (Object)hostname);
        return query.getResultList();
    }

    public List<HostServices> findServices(String service) {
        TypedQuery query = this.em.createNamedQuery("HostServices.findBy-Service", HostServices.class).setParameter("service", (Object)service);
        return query.getResultList();
    }

    public Long count(String group, String service) {
        TypedQuery query = this.em.createNamedQuery("HostServices.Count", Long.class).setParameter("group", (Object)group).setParameter("service", (Object)service);
        return (Long)query.getSingleResult();
    }

    public Long countServices(String group) {
        TypedQuery query = this.em.createNamedQuery("HostServices.Count-services", Long.class).setParameter("group", (Object)group);
        return (Long)query.getSingleResult();
    }

    public void persist(HostServices hostService) {
        this.em.persist((Object)hostService);
    }

    public void store(HostServices service) {
        TypedQuery query = this.em.createNamedQuery("HostServices.find", HostServices.class).setParameter("hostname", (Object)service.getHost().getHostname()).setParameter("group", (Object)service.getGroup()).setParameter("service", (Object)service.getService());
        List s = query.getResultList();
        if (s.size() > 0) {
            service.setId(((HostServices)s.get(0)).getId());
            this.em.merge((Object)service);
        } else {
            this.em.persist((Object)service);
        }
    }

    public void deleteServicesByHostname(String hostname) {
        this.em.createNamedQuery("HostServices.DeleteBy-Hostname").setParameter("hostname", (Object)hostname).executeUpdate();
    }

    public String groupOp(String group, Action action) throws GenericException {
        return this.webOp(action, this.findGroupServices(group));
    }

    public String serviceOp(String service, Action action) throws GenericException {
        return this.webOp(action, this.findServices(service));
    }

    public String serviceOnHostOp(String group, String serviceName, String hostname, Action action) throws GenericException {
        return this.webOp(action, Arrays.asList(this.find(hostname, group, serviceName)));
    }

    private String webOp(Action operation, List<HostServices> services) throws GenericException {
        if (operation == null) {
            throw new IllegalArgumentException("The action is not valid, valid action are " + Arrays.toString((Object[])Action.values()));
        }
        if (services == null || services.isEmpty()) {
            throw new IllegalArgumentException("service was not provided.");
        }
        String result = "";
        boolean success = false;
        int exception = Response.Status.BAD_REQUEST.getStatusCode();
        for (HostServices service : services) {
            Hosts h = service.getHost();
            if (h != null) {
                String ip = h.getPublicOrPrivateIp();
                String agentPassword = h.getAgentPassword();
                try {
                    result = result + service.toString() + " " + this.web.serviceOp(operation.value(), ip, agentPassword, service.getGroup(), service.getService());
                    success = true;
                }
                catch (GenericException ex) {
                    if (services.size() == 1) {
                        throw ex;
                    }
                    exception = ex.getErrorCode().getRespStatus().getStatusCode();
                    result = result + service.toString() + " " + ex.getErrorCode().getRespStatus() + " " + ex.getMessage();
                }
            } else {
                result = result + service.toString() + " host not found: " + service.getHost();
            }
            result = result + "\n";
        }
        if (!success) {
            throw new GenericException(RESTCodes.GenericErrorCode.UNKNOWN_ERROR, Level.SEVERE, "webOp error, exception: " + exception + ", result: " + result);
        }
        return result;
    }

    public List<HostServices> updateHostServices(AgentController.AgentHeartbeatDTO heartbeat) throws ServiceException {
        Hosts host = this.hostEJB.findByHostname(heartbeat.getHostId());
        if (host == null) {
            throw new ServiceException(RESTCodes.ServiceErrorCode.HOST_NOT_FOUND, Level.WARNING, "hostId: " + heartbeat.getHostId());
        }
        ArrayList<HostServices> hostServices = new ArrayList<HostServices>(heartbeat.getServices().size());
        for (AgentController.AgentServiceDTO service : heartbeat.getServices()) {
            String name = service.getService();
            String group = service.getGroup();
            HostServices hostService = null;
            try {
                hostService = this.find(heartbeat.getHostId(), group, name);
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, "Could not find service for " + heartbeat.getHostId() + "/" + group + "/" + name);
                continue;
            }
            if (hostService == null) {
                hostService = new HostServices();
                hostService.setHost(host);
                hostService.setGroup(group);
                hostService.setService(name);
                hostService.setStartTime(heartbeat.getAgentTime());
            }
            Integer pid = service.getPid() != null ? service.getPid() : -1;
            hostService.setPid(pid);
            if (service.getStatus() != null) {
                if ((hostService.getStatus() == null || !hostService.getStatus().equals((Object)Status.Started)) && service.getStatus().equals((Object)Status.Started)) {
                    hostService.setStartTime(heartbeat.getAgentTime());
                }
                hostService.setStatus(service.getStatus());
            } else {
                hostService.setStatus(Status.None);
            }
            if (service.getStatus().equals((Object)Status.Started)) {
                hostService.setStopTime(heartbeat.getAgentTime());
            }
            Long startTime = hostService.getStartTime();
            Long stopTime = hostService.getStopTime();
            if (startTime != null && stopTime != null) {
                hostService.setUptime(stopTime - startTime);
            } else {
                hostService.setUptime(0L);
            }
            this.store(hostService);
            hostServices.add(hostService);
        }
        return hostServices;
    }
}

