/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.security;

import io.hops.hopsworks.common.security.CertificatesMgmService;
import io.hops.hopsworks.common.util.Settings;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.ejb.DependsOn;
import javax.ejb.EJB;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.ejb.Timeout;
import javax.ejb.Timer;
import javax.ejb.TimerService;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;

@Singleton
@Startup
@DependsOn(value={"Settings"})
public class ServiceCertificateRotationTimer {
    private static final Logger LOG = Logger.getLogger(ServiceCertificateRotationTimer.class.getName());
    private static final String TO_BE_REVOKED = ".cert.pem.TO_BE_REVOKED.{COMMAND_ID}";
    @Resource
    private TimerService timerService;
    @EJB
    private Settings settings;
    @EJB
    private CertificatesMgmService certificatesMgmService;

    @PostConstruct
    public void init() {
        String rawInterval = this.settings.getServiceKeyRotationInterval();
        Long intervalValue = this.settings.getConfTimeValue(rawInterval);
        TimeUnit intervalTimeunit = this.settings.getConfTimeTimeUnit(rawInterval);
        LOG.log(Level.INFO, "Service certificate rotation is configured to run every " + intervalValue + " " + intervalTimeunit.name());
        intervalValue = intervalTimeunit.toMillis(intervalValue);
        if (this.settings.isServiceKeyRotationEnabled()) {
            this.timerService.createTimer(intervalValue.longValue(), intervalValue.longValue(), (Serializable)((Object)"Service certificate rotation"));
        }
    }

    @Timeout
    public void rotate(Timer timer) {
        LOG.log(Level.FINEST, "Rotating service certificates");
        this.certificatesMgmService.issueServiceKeyRotationCommand();
    }

    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public String getToBeRevokedSuffix(String commandId) {
        return TO_BE_REVOKED.replaceAll("\\{COMMAND_ID\\}", commandId);
    }
}

