/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dao.certificates;

import io.hops.hopsworks.common.dao.certificates.UserCerts;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.EntityNotFoundException;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;

@Stateless
public class CertsFacade {
    private final Logger LOG = Logger.getLogger(CertsFacade.class.getName());
    @PersistenceContext(unitName="kthfsPU")
    private EntityManager em;

    protected EntityManager getEntityManager() {
        return this.em;
    }

    public UserCerts findUserCert(String projectName, String username) {
        TypedQuery query = this.em.createNamedQuery("UserCerts.findUserProjectCert", UserCerts.class);
        query.setParameter("projectname", (Object)projectName);
        query.setParameter("username", (Object)username);
        try {
            UserCerts res = (UserCerts)query.getSingleResult();
            return res;
        }
        catch (NoResultException e) {
            Logger.getLogger(CertsFacade.class.getName()).log(Level.SEVERE, null, e);
            return new UserCerts();
        }
    }

    public List<UserCerts> findAllUserCerts() {
        TypedQuery query = this.em.createNamedQuery("UserCerts.findAll", UserCerts.class);
        try {
            List res = query.getResultList();
            return res;
        }
        catch (EntityNotFoundException e) {
            Logger.getLogger(CertsFacade.class.getName()).log(Level.SEVERE, null, e);
            return new ArrayList<UserCerts>();
        }
    }

    public List<UserCerts> findUserCertsByProjectId(String projectname) {
        TypedQuery query = this.em.createNamedQuery("UserCerts.findByProjectname", UserCerts.class);
        query.setParameter("projectname", (Object)projectname);
        try {
            List res = query.getResultList();
            return res;
        }
        catch (EntityNotFoundException e) {
            Logger.getLogger(CertsFacade.class.getName()).log(Level.SEVERE, null, e);
            return new ArrayList<UserCerts>();
        }
    }

    public List<UserCerts> findUserCertsByUid(String username) {
        TypedQuery query = this.em.createNamedQuery("UserCerts.findByUsername", UserCerts.class);
        query.setParameter("username", (Object)username);
        try {
            List res = query.getResultList();
            return res;
        }
        catch (EntityNotFoundException e) {
            Logger.getLogger(CertsFacade.class.getName()).log(Level.SEVERE, null, e);
            return new ArrayList<UserCerts>();
        }
    }

    public void persist(UserCerts uc) {
        this.em.persist((Object)uc);
    }

    public UserCerts putUserCerts(String projectname, String username, byte[] kStoreBlob, byte[] tStoreBlob, String userKeyPwd) {
        UserCerts uc = new UserCerts(projectname, username);
        uc.setUserKey(kStoreBlob);
        uc.setUserCert(tStoreBlob);
        uc.setUserKeyPwd(userKeyPwd);
        this.em.persist((Object)uc);
        this.em.flush();
        return uc;
    }

    public void update(UserCerts uc) {
        this.em.merge((Object)uc);
    }

    public <T> void remove(T uc) {
        if (uc != null) {
            this.em.remove(uc);
        }
    }

    public void removeUserProjectCerts(String projectname, String username) {
        UserCerts item = this.findUserCert(projectname, username);
        if (item != null) {
            UserCerts tmp = (UserCerts)this.em.merge((Object)item);
            this.remove(tmp);
        }
    }

    public void removeAllCertsOfAUser(String username) {
        List<UserCerts> items = this.findUserCertsByUid(username);
        if (items != null) {
            for (UserCerts uc : items) {
                UserCerts tmp = (UserCerts)this.em.merge((Object)uc);
                this.remove(tmp);
            }
        }
    }

    public void removeAllCertsOfAProject(String projectname) {
        List<UserCerts> items = this.findUserCertsByProjectId(projectname);
        this.removeCerts(items);
    }

    private <T> void removeCerts(List<T> items) {
        if (items != null) {
            for (T item : items) {
                Object tmp = this.em.merge(item);
                this.remove(tmp);
            }
        }
    }
}

