/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dao.dela.certs;

import io.hops.hopsworks.common.dao.dela.certs.ClusterCertificate;
import java.util.List;
import java.util.Optional;
import java.util.logging.Logger;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;

@Stateless
public class ClusterCertificateFacade {
    private static final Logger LOG = Logger.getLogger(ClusterCertificateFacade.class.getName());
    @PersistenceContext(unitName="kthfsPU")
    private EntityManager em;

    protected EntityManager getEntityManager() {
        return this.em;
    }

    public void saveClusterCerts(String clusterName, byte[] keystore, byte[] truststore, String certPswd) {
        ClusterCertificate sc = new ClusterCertificate();
        sc.setClusterName(clusterName);
        sc.setClusterKey(keystore);
        sc.setClusterCert(truststore);
        sc.setCertificatePassword(certPswd);
        this.em.persist((Object)sc);
        this.em.flush();
    }

    public void saveClusterCerts(ClusterCertificate clusterCertificate) {
        this.em.persist((Object)clusterCertificate);
    }

    public void updateClusterCerts(ClusterCertificate clusterCertificate) {
        this.em.merge((Object)clusterCertificate);
    }

    public Optional<ClusterCertificate> getClusterCert(String clusterName) {
        TypedQuery query = this.em.createNamedQuery("ClusterCertificate.findByName", ClusterCertificate.class).setParameter("clusterName", (Object)clusterName);
        try {
            ClusterCertificate res = (ClusterCertificate)query.getSingleResult();
            return Optional.of(res);
        }
        catch (NoResultException ex) {
            return Optional.empty();
        }
    }

    public Optional<List<ClusterCertificate>> getAllClusterCerts() {
        TypedQuery query = this.em.createNamedQuery("ClusterCertificate.findAll", ClusterCertificate.class);
        try {
            List result = query.getResultList();
            return Optional.of(result);
        }
        catch (NoResultException ex) {
            return Optional.empty();
        }
    }
}

