/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dao.jupyter.config;

import freemarker.template.TemplateException;
import io.hops.hopsworks.common.dao.jupyter.JupyterSettings;
import io.hops.hopsworks.common.dao.jupyter.config.JupyterPaths;
import io.hops.hopsworks.common.dao.project.Project;
import io.hops.hopsworks.common.jobs.spark.SparkJobConfiguration;
import io.hops.hopsworks.common.jupyter.JupyterContentsManager;
import io.hops.hopsworks.common.jupyter.JupyterNbVCSController;
import io.hops.hopsworks.common.tensorflow.TfLibMappingUtil;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.common.util.SparkConfigurationUtil;
import io.hops.hopsworks.common.util.TemplateEngine;
import io.hops.hopsworks.common.util.templates.jupyter.JupyterNotebookConfigTemplate;
import io.hops.hopsworks.common.util.templates.jupyter.JupyterNotebookConfigTemplateBuilder;
import io.hops.hopsworks.common.util.templates.jupyter.KernelTemplate;
import io.hops.hopsworks.common.util.templates.jupyter.KernelTemplateBuilder;
import io.hops.hopsworks.common.util.templates.jupyter.SparkMagicConfigTemplateBuilder;
import io.hops.hopsworks.exceptions.ServiceException;
import io.hops.hopsworks.restutils.RESTCodes;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.inject.Inject;
import org.apache.commons.io.FileUtils;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class JupyterConfigFilesGenerator {
    private static final Logger LOGGER = Logger.getLogger(JupyterConfigFilesGenerator.class.getName());
    @EJB
    private Settings settings;
    @EJB
    private TfLibMappingUtil tfLibMappingUtil;
    @Inject
    private JupyterNbVCSController jupyterNbVCSController;
    @EJB
    private TemplateEngine templateEngine;

    public JupyterPaths generateJupyterPaths(Project project, String hdfsUser, String secretConfig) {
        return new JupyterPaths(this.settings.getJupyterDir(), project.getName(), hdfsUser, secretConfig);
    }

    public JupyterPaths generateConfiguration(Project project, String secretConfig, String hdfsUser, String usersFullName, String nameNodeEndpoint, JupyterSettings js, Integer port, String allowOrigin) throws ServiceException {
        boolean newDir = false;
        JupyterPaths jp = this.generateJupyterPaths(project, hdfsUser, secretConfig);
        try {
            newDir = this.createJupyterDirs(jp);
            this.createConfigFiles(jp, hdfsUser, usersFullName, project, nameNodeEndpoint, port, js, allowOrigin);
        }
        catch (Exception e) {
            if (newDir) {
                this.removeProjectUserDirRecursive(jp);
            }
            LOGGER.log(Level.SEVERE, "Error in initializing JupyterConfig for project: {0}. {1}", new Object[]{project.getName(), e});
            throw new ServiceException(RESTCodes.ServiceErrorCode.JUPYTER_ADD_FAILURE, Level.SEVERE, null, e.getMessage(), (Throwable)e);
        }
        return jp;
    }

    private boolean createJupyterDirs(JupyterPaths jp) throws IOException {
        File projectDir = new File(jp.getProjectUserPath());
        projectDir.mkdirs();
        File baseDir = new File(jp.getNotebookPath());
        baseDir.mkdirs();
        HashSet<PosixFilePermission> xOnly = new HashSet<PosixFilePermission>();
        xOnly.add(PosixFilePermission.OWNER_WRITE);
        xOnly.add(PosixFilePermission.OWNER_READ);
        xOnly.add(PosixFilePermission.OWNER_EXECUTE);
        xOnly.add(PosixFilePermission.GROUP_WRITE);
        xOnly.add(PosixFilePermission.GROUP_EXECUTE);
        HashSet<PosixFilePermission> perms = new HashSet<PosixFilePermission>();
        perms.add(PosixFilePermission.OWNER_READ);
        perms.add(PosixFilePermission.OWNER_WRITE);
        perms.add(PosixFilePermission.OWNER_EXECUTE);
        perms.add(PosixFilePermission.GROUP_READ);
        perms.add(PosixFilePermission.GROUP_WRITE);
        perms.add(PosixFilePermission.GROUP_EXECUTE);
        perms.add(PosixFilePermission.OTHERS_READ);
        perms.add(PosixFilePermission.OTHERS_EXECUTE);
        Files.setPosixFilePermissions(Paths.get(jp.getNotebookPath(), new String[0]), perms);
        Files.setPosixFilePermissions(Paths.get(jp.getProjectUserPath(), new String[0]), xOnly);
        new File(jp.getConfDirPath()).mkdirs();
        new File(jp.getRunDirPath()).mkdirs();
        new File(jp.getLogDirPath()).mkdirs();
        new File(jp.getCertificatesDir()).mkdirs();
        new File(jp.getKernelsDir()).mkdirs();
        return true;
    }

    public String pythonKernelName(String pythonVersion) {
        return "python" + pythonVersion.charAt(0);
    }

    public String pythonKernelPath(String kernelsDir, String pythonKernelName) {
        return kernelsDir + File.separator + pythonKernelName;
    }

    public void createJupyterKernelConfig(Writer out, Project project, JupyterSettings js, String hdfsUser) throws IOException {
        KernelTemplate kernelTemplate = KernelTemplateBuilder.newBuilder().setHdfsUser(hdfsUser).setHadoopHome(this.settings.getHadoopSymbolicLinkDir()).setHadoopVersion(this.settings.getHadoopVersion()).setAnacondaHome(this.settings.getAnacondaProjectDir(project)).setSecretDirectory(this.settings.getStagingDir() + "/private_dirs/" + js.getSecret()).setProject(project).setHiveEndpoints(this.settings.getHiveServerHostName(false)).setLibHdfsOpts("-Xmx512m").build();
        HashMap<String, Object> dataModel = new HashMap<String, Object>(1);
        dataModel.put("kernel", kernelTemplate);
        try {
            this.templateEngine.template("kernel_template.json", dataModel, out);
        }
        catch (TemplateException ex) {
            throw new IOException(ex);
        }
    }

    public void createJupyterNotebookConfig(Writer out, Project project, String nameNodeEndpoint, int port, JupyterSettings js, String hdfsUser, String pythonKernelName, String certsDir, String allowOrigin) throws IOException, ServiceException {
        String[] nn = nameNodeEndpoint.split(":");
        String nameNodeIp = nn[0];
        String nameNodePort = nn[1];
        String remoteGitURL = "";
        String apiKey = "";
        if (js.isGitBackend().booleanValue() && js.getGitConfig() != null) {
            remoteGitURL = js.getGitConfig().getRemoteGitURL();
            apiKey = this.jupyterNbVCSController.getGitApiKey(hdfsUser, js.getGitConfig().getApiKeyName());
        }
        JupyterContentsManager jcm = this.jupyterNbVCSController.getJupyterContentsManagerClass(remoteGitURL);
        JupyterNotebookConfigTemplate template = JupyterNotebookConfigTemplateBuilder.newBuilder().setProject(project).setNamenodeIp(nameNodeIp).setNamenodePort(nameNodePort).setContentsManager(jcm.getClassName()).setHopsworksEndpoint(this.settings.getRestEndpoint()).setElasticEndpoint(this.settings.getElasticEndpoint()).setPort(port).setBaseDirectory(js.getBaseDir()).setHdfsUser(hdfsUser).setWhiteListedKernels(this.getWhitelistedKernels(js)).setHadoopHome(this.settings.getHadoopSymbolicLinkDir()).setJupyterCertsDirectory(certsDir).setSecretDirectory(this.settings.getStagingDir() + "/private_dirs/" + js.getSecret()).setAllowOrigin(allowOrigin).setWsPingInterval(this.settings.getJupyterWSPingInterval()).setApiKey(apiKey).setFlinkConfDirectory(this.settings.getFlinkConfDir()).setRequestsVerify(this.settings.getRequestsVerify()).setDomainCATruststorePem(this.settings.getSparkConfDir() + File.separator + "cacerts.pem").build();
        HashMap<String, Object> dataModel = new HashMap<String, Object>(1);
        dataModel.put("conf", template);
        try {
            this.templateEngine.template("jupyter_notebook_config_template.py", dataModel, out);
        }
        catch (TemplateException ex) {
            throw new IOException(ex);
        }
    }

    public void createSparkMagicConfig(Writer out, Project project, JupyterSettings js, String hdfsUser, String confDirPath, String usersFullName) throws IOException {
        SparkJobConfiguration sparkJobConfiguration = (SparkJobConfiguration)js.getJobConfig();
        String tfLdLibraryPath = this.tfLibMappingUtil.getTfLdLibraryPath(project);
        SparkConfigurationUtil sparkConfigurationUtil = new SparkConfigurationUtil();
        HashMap<String, String> extraJavaOptions = new HashMap<String, String>();
        extraJavaOptions.put("hopsworks.logstash.job.info", project.getName().toLowerCase() + ",jupyter,notebook,?");
        HashMap<String, String> finalSparkConfiguration = new HashMap<String, String>();
        finalSparkConfiguration.put("spark.yarn.stagingDir", "hdfs:///Projects/" + project.getName() + "/Resources");
        finalSparkConfiguration.putAll(sparkConfigurationUtil.getFrameworkProperties(project, sparkJobConfiguration, this.settings, hdfsUser, usersFullName, tfLdLibraryPath, extraJavaOptions));
        StringBuilder sparkConfBuilder = new StringBuilder();
        ArrayList keys = new ArrayList(finalSparkConfiguration.keySet());
        Collections.sort(keys);
        for (String configKey : keys) {
            sparkConfBuilder.append("\t\"" + configKey + "\":\"" + (String)finalSparkConfiguration.get(configKey) + "\",\n");
        }
        sparkConfBuilder.deleteCharAt(sparkConfBuilder.lastIndexOf(","));
        SparkMagicConfigTemplateBuilder templateBuilder = SparkMagicConfigTemplateBuilder.newBuilder().setLivyIp(this.settings.getLivyIp()).setJupyterHome(confDirPath).setDriverCores(Integer.parseInt((String)finalSparkConfiguration.get("spark.driver.cores"))).setDriverMemory((String)finalSparkConfiguration.get("spark.driver.memory"));
        if (sparkJobConfiguration.isDynamicAllocationEnabled() || sparkJobConfiguration.getExperimentType() != null) {
            templateBuilder.setNumExecutors(1);
        } else {
            templateBuilder.setNumExecutors(Integer.parseInt((String)finalSparkConfiguration.get("spark.executor.instances")));
        }
        templateBuilder.setExecutorCores(Integer.parseInt((String)finalSparkConfiguration.get("spark.executor.cores"))).setExecutorMemory((String)finalSparkConfiguration.get("spark.executor.memory")).setHdfsUser(hdfsUser).setYarnQueue(sparkJobConfiguration.getAmQueue()).setHadoopHome(this.settings.getHadoopSymbolicLinkDir()).setHadoopVersion(this.settings.getHadoopVersion()).setSparkConfiguration(sparkConfBuilder.toString());
        HashMap<String, Object> dataModel = new HashMap<String, Object>(1);
        dataModel.put("conf", templateBuilder.build());
        try {
            this.templateEngine.template("config_template.json", dataModel, out);
        }
        catch (TemplateException ex) {
            throw new IOException(ex);
        }
    }

    private void createConfigFiles(JupyterPaths jp, String hdfsUser, String usersFullName, Project project, String nameNodeEndpoint, Integer port, JupyterSettings js, String allowOrigin) throws IOException, ServiceException {
        String confDirPath = jp.getConfDirPath();
        String kernelsDir = jp.getKernelsDir();
        String certsDir = jp.getCertificatesDir();
        File jupyter_config_file = new File(confDirPath, "jupyter_notebook_config.py");
        File sparkmagic_config_file = new File(confDirPath, "config.json");
        if (!jupyter_config_file.exists()) {
            String pythonKernelName = this.pythonKernelName(project.getPythonVersion());
            if (this.settings.isPythonKernelEnabled()) {
                String pythonKernelPath = this.pythonKernelPath(kernelsDir, pythonKernelName);
                File pythonKernelFile = new File(pythonKernelPath, "kernel.json");
                new File(pythonKernelPath).mkdir();
                try (FileWriter out = new FileWriter(pythonKernelFile, false);){
                    this.createJupyterKernelConfig(out, project, js, hdfsUser);
                }
            }
            try (FileWriter out = new FileWriter(jupyter_config_file, false);){
                this.createJupyterNotebookConfig(out, project, nameNodeEndpoint, port, js, hdfsUser, pythonKernelName, certsDir, allowOrigin);
            }
        }
        if (!sparkmagic_config_file.exists()) {
            try (FileWriter out = new FileWriter(sparkmagic_config_file, false);){
                this.createSparkMagicConfig(out, project, js, hdfsUser, confDirPath, usersFullName);
            }
        }
    }

    private void removeProjectUserDirRecursive(JupyterPaths jp) {
        try {
            FileUtils.deleteDirectory((File)new File(jp.getProjectUserPath()));
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Could not delete Jupyter directory: " + jp.getProjectUserPath(), e);
        }
    }

    private String getWhitelistedKernels(JupyterSettings js) {
        if (js.isPythonKernel()) {
            return "'" + this.pythonKernelName(js.getProject().getPythonVersion()) + "'";
        }
        SparkJobConfiguration sparkJobConfiguration = (SparkJobConfiguration)js.getJobConfig();
        if (sparkJobConfiguration.getExperimentType() != null) {
            return "'pysparkkernel'";
        }
        return "'pysparkkernel', 'sparkkernel', 'sparkrkernel'";
    }
}

