/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.elastic;

import io.hops.hopsworks.common.dao.project.Project;
import io.hops.hopsworks.common.dao.project.team.ProjectRoleTypes;
import io.hops.hopsworks.common.dao.project.team.ProjectTeamFacade;
import io.hops.hopsworks.common.dao.user.Users;
import io.hops.hopsworks.common.elastic.ElasticUtils;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.exceptions.ElasticException;
import io.hops.hopsworks.jwt.JWTController;
import io.hops.hopsworks.jwt.SignatureAlgorithm;
import io.hops.hopsworks.jwt.exception.DuplicateSigningKeyException;
import io.hops.hopsworks.jwt.exception.SigningKeyNotFoundException;
import io.hops.hopsworks.restutils.RESTCodes;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.HashMap;
import java.util.logging.Level;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class ElasticJWTController {
    @EJB
    private JWTController jwtController;
    @EJB
    private Settings settings;
    @EJB
    private ProjectTeamFacade projectTeamFacade;

    public String getSigningKeyForELK() throws ElasticException {
        SignatureAlgorithm alg = SignatureAlgorithm.valueOf((String)this.settings.getJWTSignatureAlg());
        try {
            return this.jwtController.getSigningKeyForELK(alg);
        }
        catch (NoSuchAlgorithmException e) {
            throw new ElasticException(RESTCodes.ElasticErrorCode.SIGNING_KEY_ERROR, Level.SEVERE, "Failed to get elk signing key", e.getMessage(), (Throwable)e);
        }
    }

    public String createTokenForELK(Users user, Project project) throws ElasticException {
        String userRole = this.projectTeamFacade.findCurrentRole(project, user);
        return this.createTokenForELK(project, userRole);
    }

    public String createTokenForELKAsDataOwner(Project project) throws ElasticException {
        return this.createTokenForELK(project, ProjectRoleTypes.DATA_OWNER.getRole());
    }

    public String createTokenForELKAsAdmin() throws ElasticException {
        return this.createTokenForELK("admin", "admin");
    }

    private String createTokenForELK(Project project, String role) throws ElasticException {
        String userRole = ElasticUtils.getValidRole(role);
        return this.createTokenForELK(project.getName(), userRole);
    }

    private String createTokenForELK(String project, String userRole) throws ElasticException {
        SignatureAlgorithm alg = SignatureAlgorithm.valueOf((String)this.settings.getJWTSignatureAlg());
        Date expiresAt = new Date(System.currentTimeMillis() + (long)this.settings.getElasicJwtExpMs());
        try {
            HashMap<String, String> claims = new HashMap<String, String>();
            claims.put("roles", userRole);
            claims.put("pn", ElasticUtils.getProjectNameWithNoSpecialCharacters(project));
            return this.jwtController.createTokenForELK(project, this.settings.getJWTIssuer(), claims, expiresAt, alg);
        }
        catch (DuplicateSigningKeyException | SigningKeyNotFoundException | NoSuchAlgorithmException e) {
            throw new ElasticException(RESTCodes.ElasticErrorCode.JWT_NOT_CREATED, Level.SEVERE, "Failed to create jwt token for elk", e.getMessage(), e);
        }
    }
}

