/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.elastic;

import io.hops.hopsworks.common.dao.project.team.ProjectRoleTypes;
import io.hops.hopsworks.exceptions.ElasticException;
import io.hops.hopsworks.restutils.RESTCodes;
import java.util.logging.Level;

public class ElasticUtils {
    public static String getKibanaTenantIndex(String project) {
        return ".kibana_" + project.hashCode() + "_" + ElasticUtils.getProjectNameWithNoSpecialCharacters(project);
    }

    public static String getAllKibanaTenantIndex(String project) {
        return ElasticUtils.getKibanaTenantIndex(project) + "*";
    }

    public static String getProjectNameWithNoSpecialCharacters(String project) {
        return project.toLowerCase().replaceAll("[^a-z0-9]+", "");
    }

    public static String getValidRole(String role) throws ElasticException {
        if (role != null && (role.equals(ProjectRoleTypes.DATA_OWNER.getRole()) || role.equals(ProjectRoleTypes.DATA_SCIENTIST.getRole()))) {
            return role.trim().toLowerCase().replace(" ", "_");
        }
        throw new ElasticException(RESTCodes.ElasticErrorCode.INVALID_ELASTIC_ROLE, Level.SEVERE, "Invalid security role : " + role);
    }
}

