/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.proxies.client;

import io.hops.hopsworks.common.util.Settings;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ejb.ConcurrencyManagement;
import javax.ejb.ConcurrencyManagementType;
import javax.ejb.EJB;
import javax.ejb.Singleton;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.client.ResponseHandler;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;

@Singleton
@TransactionAttribute(value=TransactionAttributeType.NEVER)
@ConcurrencyManagement(value=ConcurrencyManagementType.BEAN)
public class HttpClient {
    private static final String AUTH_HEADER_CONTENT = "Bearer %s";
    @EJB
    private Settings settings;
    private PoolingHttpClientConnectionManager connectionManager;
    private CloseableHttpClient client;
    private HttpHost host;

    @PostConstruct
    public void init() throws RuntimeException {
        try {
            this.connectionManager = this.createConnectionManager();
            this.client = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)this.connectionManager).setKeepAliveStrategy((httpResponse, httpContext) -> this.settings.getConnectionKeepAliveTimeout() * 1000).build();
            this.host = HttpHost.create((String)this.settings.getRestEndpoint());
        }
        catch (IOException | GeneralSecurityException ex) {
            throw new RuntimeException(ex);
        }
    }

    @PreDestroy
    public void destroy() {
        if (this.connectionManager != null) {
            this.connectionManager.shutdown();
        }
    }

    private Registry<ConnectionSocketFactory> createConnectionFactory() throws IOException, GeneralSecurityException {
        Path trustStore = Paths.get(this.settings.getHopsworksDomainDir(), "config", "cacerts.jks");
        char[] trustStorePassword = this.settings.getHopsworksMasterPasswordSsl().toCharArray();
        SSLContext sslCtx = SSLContexts.custom().loadTrustMaterial(trustStore.toFile(), trustStorePassword, (TrustStrategy)new TrustSelfSignedStrategy()).build();
        SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslCtx, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        return RegistryBuilder.create().register("https", (Object)sslsf).register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).build();
    }

    private PoolingHttpClientConnectionManager createConnectionManager() throws IOException, GeneralSecurityException {
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(this.createConnectionFactory());
        connectionManager.setMaxTotal(10);
        connectionManager.setDefaultMaxPerRoute(10);
        return connectionManager;
    }

    public void setAuthorizationHeader(HttpRequest httpRequest) {
        httpRequest.setHeader("Authorization", String.format(AUTH_HEADER_CONTENT, this.settings.getServiceMasterJWT()));
    }

    public <T> T execute(HttpRequest request, ResponseHandler<T> handler) throws IOException {
        return (T)this.client.execute(this.host, request, handler);
    }

    public <T> T execute(HttpHost host, HttpRequest request, ResponseHandler<T> handler) throws IOException {
        return (T)this.client.execute(host, request, handler);
    }
}

