/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.jobs.flink;

import com.google.common.base.Strings;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import io.hops.hopsworks.common.jobs.flink.FlinkController;
import io.hops.hopsworks.exceptions.JobException;
import io.hops.hopsworks.restutils.RESTCodes;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.ejb.ConcurrencyManagement;
import javax.ejb.ConcurrencyManagementType;
import javax.ejb.EJB;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;

@ConcurrencyManagement(value=ConcurrencyManagementType.BEAN)
@Singleton
@Startup
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class FlinkMasterAddrCache {
    private static final Logger LOGGER = Logger.getLogger(FlinkMasterAddrCache.class.getName());
    @EJB
    private FlinkController flinkController;
    private LoadingCache<String, String> cache;

    @PostConstruct
    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public void init() {
        CacheLoader<String, String> loader = new CacheLoader<String, String>(){

            public String load(String appId) throws JobException {
                LOGGER.log(Level.INFO, "Fetching FlinkMaster Addr into cache for appId:" + appId);
                String addr = FlinkMasterAddrCache.this.flinkController.getFlinkMasterAddr(appId);
                if (Strings.isNullOrEmpty((String)addr)) {
                    throw new JobException(RESTCodes.JobErrorCode.APPID_NOT_FOUND, Level.WARNING);
                }
                return addr;
            }
        };
        this.cache = CacheBuilder.newBuilder().maximumSize(100L).expireAfterAccess(1L, TimeUnit.HOURS).build((CacheLoader)loader);
    }

    public String get(String appId) {
        try {
            return (String)this.cache.get((Object)appId);
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "Could not get Flink Master Address from Cache.", ex);
            return null;
        }
    }
}

