/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dao.kafka.schemas;

import io.hops.hopsworks.common.dao.AbstractFacade;
import io.hops.hopsworks.common.dao.kafka.schemas.SchemaCompatibility;
import io.hops.hopsworks.common.dao.kafka.schemas.SubjectsCompatibility;
import io.hops.hopsworks.common.dao.project.Project;
import java.util.Optional;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;

@Stateless
public class SubjectsCompatibilityFacade
extends AbstractFacade<SubjectsCompatibility> {
    @PersistenceContext(unitName="kthfsPU")
    private EntityManager em;

    @Override
    protected EntityManager getEntityManager() {
        return this.em;
    }

    public SubjectsCompatibilityFacade() {
        super(SubjectsCompatibility.class);
    }

    public Optional<SubjectsCompatibility> findBySubject(Project project, String subject) {
        try {
            return Optional.of(this.em.createNamedQuery("SubjectsCompatibility.findBySubject", SubjectsCompatibility.class).setParameter("project", (Object)project).setParameter("subject", (Object)subject).getSingleResult());
        }
        catch (NoResultException e) {
            return Optional.empty();
        }
    }

    public Optional<SubjectsCompatibility> getProjectCompatibility(Project project) {
        try {
            return Optional.of(this.em.createNamedQuery("SubjectsCompatibility.getProjectCompatibility", SubjectsCompatibility.class).setParameter("project", (Object)project).getSingleResult());
        }
        catch (NoResultException e) {
            return Optional.empty();
        }
    }

    public void setProjectCompatibility(Project project, SchemaCompatibility sc) {
        this.updateSubjectCompatibility(project, "projectcompatibility", sc);
    }

    public void updateSubjectCompatibility(Project project, String subject, SchemaCompatibility sc) {
        SubjectsCompatibility subjectsCompatibility;
        Optional<SubjectsCompatibility> optional = this.findBySubject(project, subject);
        boolean newSubjectsCompatibility = false;
        if (!optional.isPresent()) {
            subjectsCompatibility = new SubjectsCompatibility(subject, project, sc);
            newSubjectsCompatibility = true;
        } else {
            subjectsCompatibility = optional.get();
        }
        subjectsCompatibility.setCompatibility(sc);
        if (newSubjectsCompatibility) {
            this.save(subjectsCompatibility);
        } else {
            this.update(subjectsCompatibility);
        }
        this.em.flush();
    }

    public Optional<SubjectsCompatibility> getSubjectCompatibility(Project project, String subject) {
        try {
            return Optional.of(this.em.createNamedQuery("SubjectsCompatibility.getSubjectCompatibility", SubjectsCompatibility.class).setParameter("project", (Object)project).setParameter("subject", (Object)subject).getSingleResult());
        }
        catch (NoResultException e) {
            return Optional.empty();
        }
    }
}

