/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.storageconnectors.jdbc;

import io.hops.hopsworks.common.dao.AbstractFacade;
import io.hops.hopsworks.common.dao.featurestore.Featurestore;
import io.hops.hopsworks.common.dao.featurestore.storageconnector.jdbc.FeaturestoreJdbcConnector;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import javax.validation.ConstraintViolationException;

@Stateless
public class FeaturestoreJdbcConnectorFacade
extends AbstractFacade<FeaturestoreJdbcConnector> {
    private static final Logger LOGGER = Logger.getLogger(FeaturestoreJdbcConnectorFacade.class.getName());
    @PersistenceContext(unitName="kthfsPU")
    private EntityManager em;

    public FeaturestoreJdbcConnectorFacade() {
        super(FeaturestoreJdbcConnector.class);
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void persist(FeaturestoreJdbcConnector featurestoreJdbcConnector) {
        try {
            this.em.persist((Object)featurestoreJdbcConnector);
            this.em.flush();
        }
        catch (ConstraintViolationException cve) {
            LOGGER.log(Level.WARNING, "Could not persist the new JDBC connection", cve);
            throw cve;
        }
    }

    public List<FeaturestoreJdbcConnector> findByFeaturestore(Featurestore featurestore) {
        TypedQuery q = this.em.createNamedQuery("FeaturestoreJdbcConnector.findByFeaturestore", FeaturestoreJdbcConnector.class).setParameter("featurestore", (Object)featurestore);
        return q.getResultList();
    }

    public FeaturestoreJdbcConnector findByIdAndFeaturestore(Integer id, Featurestore featurestore) {
        try {
            return (FeaturestoreJdbcConnector)this.em.createNamedQuery("FeaturestoreJdbcConnector.findByFeaturestoreAndId", FeaturestoreJdbcConnector.class).setParameter("featurestore", (Object)featurestore).setParameter("id", (Object)id).getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public FeaturestoreJdbcConnector updateJdbcConnector(FeaturestoreJdbcConnector featurestoreJdbcConnector) {
        this.em.merge((Object)featurestoreJdbcConnector);
        return featurestoreJdbcConnector;
    }

    @Override
    protected EntityManager getEntityManager() {
        return this.em;
    }
}

