/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dao.command;

import io.hops.hopsworks.common.dao.command.SystemCommandArguments;
import io.hops.hopsworks.common.dao.command.SystemCommandFacade;
import io.hops.hopsworks.common.dao.host.Hosts;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.xml.bind.annotation.XmlRootElement;

@Entity
@Table(name="system_commands", catalog="hopsworks")
@XmlRootElement
@NamedQueries(value={@NamedQuery(name="SystemCommand.findAll", query="SELECT c FROM SystemCommand c"), @NamedQuery(name="SystemCommand.findByHost", query="SELECT c FROM SystemCommand c WHERE c.host = :host"), @NamedQuery(name="SystemCommand.findNotFinishedByHost", query="SELECT c FROM SystemCommand c WHERE c.host = :host AND c.status != io.hops.hopsworks.common.dao.command.SystemCommandFacade.STATUS.FINISHED AND c.status != io.hops.hopsworks.common.dao.command.SystemCommandFacade.STATUS.FAILED")})
public class SystemCommand
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="id")
    private Integer id;
    @JoinColumn(name="host_id", referencedColumnName="id", nullable=false)
    @ManyToOne(optional=false)
    private Hosts host;
    @Column(name="op", nullable=false, length=50)
    @Basic(optional=false)
    @Enumerated(value=EnumType.STRING)
    private SystemCommandFacade.OP op;
    @Column(name="status", nullable=false, length=20)
    @Basic(optional=false)
    @Enumerated(value=EnumType.STRING)
    private SystemCommandFacade.STATUS status = SystemCommandFacade.STATUS.NEW;
    @Column(name="priority", nullable=false)
    @Basic(optional=false)
    private Integer priority = 0;
    @Column(name="exec_user", length=50)
    private String execUser;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="command", fetch=FetchType.LAZY)
    private List<SystemCommandArguments> commandArguments;

    public SystemCommand(Hosts host, SystemCommandFacade.OP op) {
        this.host = host;
        this.op = op;
    }

    public SystemCommand() {
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Hosts getHost() {
        return this.host;
    }

    public void setHost(Hosts host) {
        this.host = host;
    }

    public SystemCommandFacade.OP getOp() {
        return this.op;
    }

    public void setOp(SystemCommandFacade.OP op) {
        this.op = op;
    }

    public SystemCommandFacade.STATUS getStatus() {
        return this.status;
    }

    public void setStatus(SystemCommandFacade.STATUS status) {
        this.status = status;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public String getExecUser() {
        return this.execUser;
    }

    public void setExecUser(String execUser) {
        this.execUser = execUser;
    }

    public List<SystemCommandArguments> getCommandArguments() {
        return this.commandArguments;
    }

    public void setCommandArguments(List<SystemCommandArguments> commandArguments) {
        this.commandArguments = commandArguments;
    }

    public void setCommandArgumentsAsString(String commandArguments) {
        if (commandArguments != null) {
            String[] tokens = this.getSplitArguments(commandArguments, 13900);
            ArrayList<SystemCommandArguments> args = new ArrayList<SystemCommandArguments>(tokens.length);
            for (String arg : tokens) {
                SystemCommandArguments sca = new SystemCommandArguments(arg);
                sca.setCommand(this);
                args.add(sca);
            }
            this.setCommandArguments(args);
        }
    }

    public String getCommandArgumentsAsString() {
        StringBuilder sb = new StringBuilder();
        if (this.commandArguments != null) {
            for (SystemCommandArguments sca : this.commandArguments) {
                sb.append(sca.getArguments());
            }
        }
        return sb.toString();
    }

    private String[] getSplitArguments(String arguments, int columnSize) {
        int buckets = arguments.length() / columnSize;
        if (arguments.length() % columnSize != 0) {
            ++buckets;
        }
        String[] tokens = new String[buckets];
        int head = 0;
        int tail = arguments.length() > columnSize ? columnSize : arguments.length();
        for (int i = 0; i < buckets; ++i) {
            tokens[i] = arguments.substring(head, tail);
            head = tail;
            tail = tail + columnSize < arguments.length() ? tail + columnSize : arguments.length();
        }
        return tokens;
    }

    public String toString() {
        return "SystemCommand with ID " + this.id + " OP: " + (Object)((Object)this.op) + " STATUS: " + (Object)((Object)this.status);
    }
}

